/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestTaggedString
extends TestingPanel {
    public TestTaggedString(String[] args) throws Exception {
        super(args);
        this.setName("Tagged String");
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g != null) {
            VectorGraphics vg = VectorGraphics.create((Graphics)g);
            Dimension dim = this.getSize();
            Insets insets = this.getInsets();
            vg.setColor(Color.white);
            vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
            int x = insets.left;
            int dy = dim.height / 4;
            TagString text = new TagString("Ant<sup><b>Bull</b></sup>Cat<i><sub>Dog</sub></i><u>Eel</u><sup><udash>Frog</udash></sup><udot>Gecko</udot><sub><strike>Hog</strike></sub>");
            vg.setColor(Color.black);
            vg.setFont(new Font("SansSerif", 0, 30));
            vg.drawString(text, (double)x, (double)(1 * dy + insets.top));
            vg.setFont(new Font("Serif", 0, 30));
            vg.drawString(text, (double)x, (double)(2 * dy + insets.top));
            vg.setFont(new Font("Monospaced", 0, 30));
            vg.drawString(text, (double)x, (double)(3 * dy + insets.top));
        }
    }

    public static void main(String[] args) throws Exception {
        new TestTaggedString(args).runTest();
    }
}

