/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.RationalFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.RationalAggregator;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.math.MathType;

public class ArrayQ128
extends ScalarArray<RationalNumber> {
    public static final DenseArray.Factory<RationalNumber> FACTORY = new DenseArray.Factory<RationalNumber>(){

        @Override
        public AggregatorSet<RationalNumber> aggregator() {
            return RationalAggregator.getSet();
        }

        @Override
        public FunctionSet<RationalNumber> function() {
            return RationalFunction.getSet();
        }

        @Override
        public Scalar.Factory<RationalNumber> scalar() {
            return RationalNumber.FACTORY;
        }

        @Override
        MathType getMathType() {
            return MathType.Q128;
        }

        @Override
        PlainArray<RationalNumber> makeDenseArray(long size) {
            return ArrayQ128.make((int)size);
        }
    };

    public static ArrayQ128 make(int size) {
        return new ArrayQ128(size);
    }

    public static ArrayQ128 wrap(RationalNumber ... data) {
        return new ArrayQ128(data);
    }

    protected ArrayQ128(int size) {
        super(FACTORY, size);
    }

    protected ArrayQ128(RationalNumber[] data) {
        super(FACTORY, (Scalar[])data);
    }
}

