/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.nio.ByteBuffer;
import org.ojalgo.array.BufferArray;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.type.NumberDefinition;

final class BufferZ008
extends BufferArray {
    private final ByteBuffer myBuffer;

    BufferZ008(BufferArray.Factory factory, ByteBuffer buffer, AutoCloseable closeable) {
        super(factory, buffer, closeable);
        this.myBuffer = buffer;
    }

    @Override
    protected byte byteValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.myBuffer.put(index, supplier.byteValue());
    }

    @Override
    protected float floatValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void set(int index, double value) {
        this.myBuffer.put(index, (byte)Math.round(value));
    }

    @Override
    protected void set(int index, long value) {
        this.myBuffer.put(index, (byte)value);
    }

    @Override
    protected void set(int index, byte value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.set(index, this.byteValue(index) + NumberDefinition.byteValue(addend));
    }
}

