/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.ojalgo.array.BufferArray;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.type.NumberDefinition;

final class BufferZ064
extends BufferArray {
    private final LongBuffer myBuffer;

    BufferZ064(BufferArray.Factory factory, ByteBuffer buffer, AutoCloseable closeable) {
        this(factory, buffer.asLongBuffer(), closeable);
    }

    BufferZ064(BufferArray.Factory factory, LongBuffer buffer, AutoCloseable closeable) {
        super(factory, buffer, closeable);
        this.myBuffer = buffer;
    }

    @Override
    protected byte byteValue(int index) {
        return (byte)this.myBuffer.get(index);
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.myBuffer.put(index, supplier.longValue());
    }

    @Override
    protected float floatValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected int intValue(int index) {
        return (int)this.myBuffer.get(index);
    }

    @Override
    protected long longValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void set(int index, double value) {
        this.myBuffer.put(index, Math.round(value));
    }

    @Override
    protected short shortValue(int index) {
        return (short)this.myBuffer.get(index);
    }

    @Override
    protected void set(int index, long value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.set(index, this.longValue(index) + NumberDefinition.longValue(addend));
    }
}

