/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.scalar.Scalar;

public abstract class RotateLeft
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void invoke(double[] data, int structure, int rowA, int rowB, double cos, double sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            double oldA = data[indexA];
            double oldB = data[indexB];
            data[indexA] = cos * oldA + sin * oldB;
            data[indexB] = cos * oldB - sin * oldA;
            indexA += structure;
            indexB += structure;
        }
    }

    public static void invoke(float[] data, int structure, int rowA, int rowB, float cos, float sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            float oldA = data[indexA];
            float oldB = data[indexB];
            data[indexA] = cos * oldA + sin * oldB;
            data[indexB] = cos * oldB - sin * oldA;
            indexA += structure;
            indexB += structure;
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int structure, int rowA, int rowB, N cos, N sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            N oldA = data[indexA];
            N oldB = data[indexB];
            data[indexA] = (Scalar)((Scalar)cos.multiply(oldA)).add((Scalar)sin.multiply(oldB)).get();
            data[indexB] = (Scalar)((Scalar)cos.multiply(oldB)).subtract((Scalar)sin.multiply(oldA)).get();
            indexA += structure;
            indexB += structure;
        }
    }
}

