/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data;

import java.util.Collection;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;

public final class DataBatch
implements Access2D<Double>,
Access2D.Collectable<Double, Mutate2D.Receiver<Double>> {
    private int myCursor = 0;
    private final Mutate2D.ModifiableReceiver<Double> myData;

    public static DataBatch from(Factory2D<? extends Mutate2D.ModifiableReceiver<Double>> factory, int batchSize, int dataNodes) {
        return new DataBatch(factory.make(batchSize, dataNodes));
    }

    DataBatch(Mutate2D.ModifiableReceiver<Double> data) {
        this.myData = data;
    }

    public void addRow(Access1D<Double> row) {
        this.myData.fillRow((long)this.myCursor, (Double)((Object)row));
        ++this.myCursor;
    }

    public void addRows(Collection<? extends Access1D<Double>> rows) {
        rows.forEach(this::addRow);
    }

    public void addRowWithSingleUnit(int unitIndex) {
        this.myData.fillRow((long)this.myCursor, PrimitiveMath.ZERO);
        this.myData.set((long)this.myCursor, (long)unitIndex, PrimitiveMath.ONE);
        ++this.myCursor;
    }

    @Override
    public long countColumns() {
        return this.myData.countColumns();
    }

    @Override
    public long countRows() {
        return this.myData.countRows();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myData.doubleValue(row, col);
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    public boolean isFull() {
        return this.remaining() == 0;
    }

    public int remaining() {
        return this.getRowDim() - this.myCursor;
    }

    public void reset() {
        this.myCursor = 0;
    }

    @Override
    public void supplyTo(Mutate2D.Receiver<Double> receiver) {
        receiver.fillMatching(this.myData);
    }
}

