/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import org.ojalgo.data.domain.finance.series.AlphaVantageParser;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.data.domain.finance.series.IEXTradingParser;
import org.ojalgo.data.domain.finance.series.YahooParser;
import org.ojalgo.netio.DetectingParser;
import org.ojalgo.netio.LineSplittingParser;
import org.ojalgo.netio.TextLineReader;

public final class DatePriceParser
extends DetectingParser<DatePrice> {
    public DatePriceParser() {
        super(new DefaultParser());
        this.addPotentialParser(YahooParser::testHeader, new YahooParser());
        this.addPotentialParser(AlphaVantageParser::testHeader, new AlphaVantageParser());
        this.addPotentialParser(IEXTradingParser::testHeader, new IEXTradingParser());
    }

    static final class DefaultParser
    implements TextLineReader.Parser<DatePrice> {
        private final LineSplittingParser myDelegate = new LineSplittingParser();

        DefaultParser() {
        }

        @Override
        public DatePrice parse(String line) {
            String[] parsed = this.myDelegate.parse(line);
            return DatePrice.of((CharSequence)parsed[0], (CharSequence)parsed[1]);
        }
    }
}

