/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.data.domain.finance.series.FinanceData;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.netio.TextLineReader;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.SimpleSeries;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.function.AutoSupplier;
import org.ojalgo.type.keyvalue.KeyValue;

public final class FinanceDataReader<DP extends DatePrice>
implements FinanceData<DP>,
DataFetcher {
    private final File myFile;
    private final InMemoryFile myInMemoryFile;
    private final TextLineReader.Parser<DP> myParser;
    private final CalendarDateUnit myResolution;

    public static <T extends DatePrice> FinanceDataReader<T> of(File file, TextLineReader.Parser<T> parser) {
        return new FinanceDataReader<T>(file, parser, CalendarDateUnit.DAY);
    }

    public static <T extends DatePrice> FinanceDataReader<T> of(File file, TextLineReader.Parser<T> parser, CalendarDateUnit resolution) {
        return new FinanceDataReader<T>(file, parser, resolution);
    }

    public static <T extends DatePrice> FinanceDataReader<T> of(InMemoryFile file, TextLineReader.Parser<T> parser) {
        return new FinanceDataReader<T>(file, parser, CalendarDateUnit.DAY);
    }

    public static <T extends DatePrice> FinanceDataReader<T> of(InMemoryFile file, TextLineReader.Parser<T> parser, CalendarDateUnit resolution) {
        return new FinanceDataReader<T>(file, parser, resolution);
    }

    public static String toSymbol(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return "UNKNOWN";
        }
        String retVal = fileName;
        int lastDotIndex = retVal.lastIndexOf(46);
        if (lastDotIndex > 0) {
            retVal = retVal.substring(0, lastDotIndex);
        }
        return retVal.toUpperCase();
    }

    FinanceDataReader(File file, TextLineReader.Parser<DP> parser, CalendarDateUnit resolution) {
        this.myFile = file;
        this.myInMemoryFile = null;
        this.myParser = parser;
        this.myResolution = resolution;
    }

    FinanceDataReader(InMemoryFile file, TextLineReader.Parser<DP> parser, CalendarDateUnit resolution) {
        this.myFile = null;
        this.myInMemoryFile = file;
        this.myParser = parser;
        this.myResolution = resolution;
    }

    @Override
    public KeyValue<String, List<DP>> getHistoricalData() {
        return KeyValue.of(this.getSymbol(), this.getHistoricalPrices());
    }

    @Override
    public List<DP> getHistoricalPrices() {
        ArrayList retVal;
        block30: {
            retVal = new ArrayList();
            if (this.myFile != null) {
                try (TextLineReader reader = TextLineReader.of(this.myFile);
                     AutoSupplier<DP> supplier = reader.withFilteredParser(this.myParser);){
                    supplier.forEach(retVal::add);
                    break block30;
                }
                catch (Exception cause) {
                    throw new RuntimeException(cause);
                }
            }
            if (this.myInMemoryFile != null) {
                try (TextLineReader reader = TextLineReader.of(this.myInMemoryFile);
                     AutoSupplier<DP> supplier = reader.withFilteredParser(this.myParser);){
                    supplier.forEach(retVal::add);
                    break block30;
                }
                catch (Exception cause) {
                    throw new RuntimeException(cause);
                }
            }
            throw new IllegalStateException();
        }
        return retVal;
    }

    @Override
    public InputStream getInputStream() {
        if (this.myFile != null) {
            try {
                return new FileInputStream(this.myFile);
            }
            catch (FileNotFoundException cause) {
                throw new RuntimeException(cause);
            }
        }
        if (this.myInMemoryFile != null) {
            return this.myInMemoryFile.newInputStream();
        }
        throw new IllegalStateException();
    }

    @Override
    public BasicSeries<LocalDate, PrimitiveNumber> getPriceSeries() {
        SimpleSeries<LocalDate, PrimitiveNumber> retVal;
        block30: {
            retVal = new SimpleSeries<LocalDate, PrimitiveNumber>();
            if (this.myFile != null) {
                try (TextLineReader reader = TextLineReader.of(this.myFile);
                     AutoSupplier<DP> supplier = reader.withFilteredParser(this.myParser);){
                    supplier.forEach(dp -> retVal.put(dp.date, (PrimitiveNumber)dp));
                    break block30;
                }
                catch (Exception cause) {
                    throw new RuntimeException(cause);
                }
            }
            if (this.myInMemoryFile != null) {
                try (TextLineReader reader = TextLineReader.of(this.myInMemoryFile);
                     AutoSupplier<DP> supplier = reader.withFilteredParser(this.myParser);){
                    supplier.forEach(dp -> retVal.put(dp.date, (PrimitiveNumber)dp));
                    break block30;
                }
                catch (Exception cause) {
                    throw new RuntimeException(cause);
                }
            }
            throw new IllegalStateException();
        }
        return retVal;
    }

    @Override
    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    @Override
    public String getSymbol() {
        if (this.myFile != null) {
            return FinanceDataReader.toSymbol(this.myFile.getName());
        }
        if (this.myInMemoryFile != null) {
            return FinanceDataReader.toSymbol(this.myInMemoryFile.getName().orElse(""));
        }
        throw new IllegalStateException();
    }
}

