/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.InputStream;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.netio.ServiceClient;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;

public final class YahooSession {
    private static final CalendarDateDuration DURATION_30_YEARS = new CalendarDateDuration(30.0, CalendarDateUnit.YEAR);
    private final ServiceClient.Session mySession = ServiceClient.newSession();

    public Fetcher newFetcher(String symbol, CalendarDateUnit resolution) {
        return new Fetcher(this.mySession, symbol, resolution);
    }

    public static final class Fetcher
    implements DataFetcher {
        private final CalendarDateUnit myResolution;
        private final ServiceClient.Session mySession;
        private final String mySymbol;

        Fetcher(ServiceClient.Session session, String symbol, CalendarDateUnit resolution) {
            this.mySession = session;
            this.mySymbol = symbol;
            this.myResolution = resolution;
        }

        @Override
        public InputStream getInputStream() {
            ServiceClient.Request request = this.mySession.newRequest().host("query1.finance.yahoo.com").path("/v7/finance/download/" + this.mySymbol);
            Instant now = Instant.now();
            Instant past = now.minus(DURATION_30_YEARS.toDurationInMillis(), ChronoUnit.MILLIS);
            request.query("period1", Long.toString(past.getEpochSecond()));
            request.query("period2", Long.toString(now.getEpochSecond()));
            switch (this.myResolution) {
                case MONTH: {
                    request.query("interval", "1mo");
                    break;
                }
                case WEEK: {
                    request.query("interval", "1wk");
                    break;
                }
                default: {
                    request.query("interval", "1d");
                }
            }
            request.query("events", "history");
            request.query("includeAdjustedClose", "true");
            ServiceClient.Response<InputStream> response = request.send(HttpResponse.BodyHandlers.ofInputStream());
            if (response.isResponseOK()) {
                return response.getBody();
            }
            return InputStream.nullInputStream();
        }

        @Override
        public CalendarDateUnit getResolution() {
            return this.myResolution;
        }

        @Override
        public String getSymbol() {
            return this.mySymbol;
        }
    }
}

