/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.ConstantFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class AffineFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Affine<N> {
    private final MatrixStore<N> myCoefficients;
    private final ConstantFunction<N> myConstant;

    public static AffineFunction<ComplexNumber> makeComplex(Access1D<?> coefficients) {
        return new AffineFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.rows(coefficients));
    }

    public static AffineFunction<ComplexNumber> makeComplex(int arity) {
        return new AffineFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.make(1, arity));
    }

    public static AffineFunction<Double> makePrimitive(Access1D<?> coefficients) {
        return new AffineFunction<Double>((MatrixStore)Primitive64Store.FACTORY.rows(coefficients));
    }

    public static AffineFunction<Double> makePrimitive(int arity) {
        return new AffineFunction<Double>((MatrixStore)Primitive64Store.FACTORY.make(1, arity));
    }

    public static AffineFunction<RationalNumber> makeRational(Access1D<?> coefficients) {
        return new AffineFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.rows(coefficients));
    }

    public static AffineFunction<RationalNumber> makeRational(int arity) {
        return new AffineFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.make(1, arity));
    }

    public static <N extends Comparable<N>> AffineFunction<N> wrap(PhysicalStore<N> coefficients) {
        return new AffineFunction<N>(coefficients);
    }

    AffineFunction(MatrixStore<N> coefficients) {
        if (!coefficients.isVector()) {
            throw new IllegalArgumentException("Must be a  vector!");
        }
        this.myCoefficients = coefficients;
        this.myConstant = new ConstantFunction<N>(coefficients.count(), coefficients.physical());
    }

    @Override
    public int arity() {
        return Math.toIntExact(this.myCoefficients.count());
    }

    @Override
    public N getConstant() {
        return this.myConstant.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myCoefficients.physical().makeZero(this.arity(), this.arity());
    }

    @Override
    public MatrixStore<N> getLinearFactors() {
        if (this.myCoefficients.countRows() == 1L) {
            return this.myCoefficients.transpose();
        }
        return this.myCoefficients;
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return (N)((Comparable)this.getScalarValue(arg).get());
    }

    @Override
    public PhysicalStore<N> linear() {
        return (PhysicalStore)this.myCoefficients;
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myConstant.setConstant(constant);
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myCoefficients.physical();
    }

    Scalar<N> getScalarValue(Access1D<N> arg) {
        PhysicalStore preallocated = (PhysicalStore)this.myCoefficients.physical().make(1L, 1L);
        Scalar retVal = this.myConstant.getScalarConstant();
        this.myCoefficients.multiply(arg, preallocated);
        retVal = (Scalar)retVal.add(preallocated.get(0L, 0L));
        return retVal;
    }
}

