/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.util.List;
import java.util.Optional;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Matrix2D;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Operate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public abstract class BasicMatrix<N extends Comparable<N>, M extends BasicMatrix<N, M>>
implements Matrix2D<N, M>,
Structure2D.ReducibleTo1D<M>,
NumberContext.Enforceable<M>,
Access2D.Collectable<N, TransformableRegion<N>>,
Provider2D.Inverse<M>,
Provider2D.Condition,
Provider2D.Rank,
Provider2D.Symmetric,
Provider2D.Hermitian,
Provider2D.Trace<N>,
Provider2D.Determinant<N>,
Provider2D.Solution<M>,
Provider2D.Eigenpairs,
Structure2D.Logical<Access2D<N>, M>,
Operate2D<N, M> {
    private static final NumberContext EQUALS = NumberContext.of(12, 14);
    private transient MatrixDecomposition<N> myDecomposition = null;
    private final PhysicalStore.Factory<N, ?> myFactory;
    private transient int myHashCode = 0;
    private transient Boolean myHermitian = null;
    private transient Boolean mySPD = null;
    private MatrixStore<N> myStore;
    private final ElementsSupplier<N> mySupplier;
    private transient Boolean mySymmetric = null;

    public static <M extends BasicMatrix<?, M>> double calculateFrobeniusNorm(M matrix) {
        return matrix.norm();
    }

    public static <M extends BasicMatrix<?, M>> double calculateInfinityNorm(M matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countRows();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal = PrimitiveMath.MAX.invoke(retVal, NumberDefinition.doubleValue(matrix.aggregateRow(i, Aggregator.NORM1)));
        }
        return retVal;
    }

    public static <M extends BasicMatrix<?, M>> double calculateOneNorm(M matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countColumns();
        for (long j = 0L; j < tmpLimit; ++j) {
            retVal = PrimitiveMath.MAX.invoke(retVal, NumberDefinition.doubleValue(matrix.aggregateColumn(j, Aggregator.NORM1)));
        }
        return retVal;
    }

    BasicMatrix(PhysicalStore.Factory<N, ?> factory, ElementsSupplier<N> supplier) {
        this.myFactory = factory;
        this.mySupplier = supplier;
        this.myStore = supplier instanceof MatrixStore ? (MatrixStore)supplier : null;
    }

    @Override
    public M above(Access2D<N> ... above) {
        return this.newInstance(this.store().above(above));
    }

    @Override
    public M above(Access2D<N> above) {
        return this.newInstance(this.store().above(above));
    }

    @Override
    public M above(long numberOfRows) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().above(numberOfRows)));
    }

    @Override
    public M add(double scalarAddend) {
        return this.newInstance((ElementsSupplier<N>)this.store().add(scalarAddend));
    }

    @Override
    public M add(M addend) {
        ProgrammingError.throwIfNotEqualDimensions(this.store(), addend);
        return this.newInstance(this.store().add(((BasicMatrix)addend).store()));
    }

    @Override
    public M add(N scalarAddend) {
        return this.newInstance((ElementsSupplier<N>)this.store().add((Comparable)scalarAddend));
    }

    @Override
    public N aggregateColumn(long row, long col, Aggregator aggregator) {
        return this.store().aggregateColumn(row, col, aggregator);
    }

    @Override
    public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        return this.store().aggregateDiagonal(row, col, aggregator);
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        return this.store().aggregateRange(first, limit, aggregator);
    }

    @Override
    public N aggregateRow(long row, long col, Aggregator aggregator) {
        return this.store().aggregateRow(row, col, aggregator);
    }

    @Override
    public M below(Access2D<N> ... below) {
        return this.newInstance(this.store().below(below));
    }

    @Override
    public M below(Access2D<N> below) {
        return this.newInstance(this.store().below(below));
    }

    @Override
    public M below(long numberOfRows) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().below(numberOfRows)));
    }

    @Override
    public M bidiagonal(boolean upper) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().bidiagonal(upper)));
    }

    @Override
    public M column(int column) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().column(column)));
    }

    @Override
    public M column(long column) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().column(column)));
    }

    @Override
    public M columns(int ... columns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().columns(columns)));
    }

    @Override
    public M columns(long ... columns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().columns(columns)));
    }

    @Override
    public M conjugate() {
        return this.newInstance((ElementsSupplier<N>)this.store().conjugate());
    }

    public abstract Mutator2D<N, M, PhysicalStore<N>> copy();

    @Override
    public long count() {
        return this.mySupplier.count();
    }

    @Override
    public long countColumns() {
        return this.mySupplier.countColumns();
    }

    @Override
    public long countRows() {
        return this.mySupplier.countRows();
    }

    @Override
    public M diagonal() {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().diagonal()));
    }

    public M diagonally(Access2D<N> ... diagonally) {
        return this.newInstance(this.store().diagonally(diagonally));
    }

    @Override
    public M divide(double scalarDivisor) {
        return this.newInstance((ElementsSupplier<N>)this.store().divide(scalarDivisor));
    }

    @Override
    public M divide(N scalarDivisor) {
        return this.newInstance((ElementsSupplier<N>)this.store().divide((Comparable)scalarDivisor));
    }

    @Override
    public double doubleValue(long index) {
        return this.store().doubleValue(index);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.store().doubleValue(row, col);
    }

    @Override
    public M enforce(NumberContext context) {
        PhysicalStore<N> tmpCopy = this.store().copy();
        tmpCopy.modifyAll(this.store().physical().function().enforce(context));
        return this.newInstance(tmpCopy);
    }

    public boolean equals(Object other) {
        if (other instanceof Access2D) {
            return Access2D.equals(this.store(), (Access2D)other, EQUALS);
        }
        return super.equals(other);
    }

    @Deprecated
    public void flushCache() {
        this.myHashCode = 0;
        if (this.myDecomposition != null) {
            this.myDecomposition.reset();
            this.myDecomposition = null;
        }
        this.myHermitian = null;
        this.mySymmetric = null;
        this.mySPD = null;
    }

    @Deprecated
    public M get() {
        return (M)this;
    }

    @Override
    public N get(long index) {
        return this.store().get(index);
    }

    @Override
    public N get(long row, long col) {
        return this.store().get(row, col);
    }

    @Override
    public double getCondition() {
        return this.getConditionProvider().getCondition();
    }

    @Override
    public N getDeterminant() {
        return this.getDeterminantProvider().getDeterminant();
    }

    @Override
    public List<Eigenvalue.Eigenpair> getEigenpairs() {
        if (!this.isSquare()) {
            throw new ProgrammingError("Only defined for square matrices!");
        }
        return this.getEigenpairsProvider().getEigenpairs();
    }

    @Override
    public int getRank() {
        return this.getRankProvider().getRank();
    }

    @Override
    public N getTrace() {
        return this.aggregateDiagonal(Aggregator.SUM);
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            MatrixStore<N> access = this.store();
            int limit = access.size();
            int retVal = limit + 31;
            for (int ij = 0; ij < limit; ++ij) {
                retVal *= access.intValue(ij);
            }
            this.myHashCode = retVal;
        }
        return this.myHashCode;
    }

    @Override
    public M hermitian(boolean upper) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().hermitian(upper)));
    }

    @Override
    public M hessenberg(boolean upper) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().hessenberg(upper)));
    }

    @Override
    public long indexOfLargest() {
        return this.store().indexOfLargest();
    }

    @Override
    public M invert() {
        return this.newInstance(this.getInverseProvider(false).invert().orElseGet(() -> this.getInverseProvider(true).invert().get()));
    }

    @Override
    public boolean isHermitian() {
        if (this.myHermitian == null) {
            this.myHermitian = this.isSquare() && this.store().equals((MatrixStore<N>)this.store().conjugate(), EQUALS);
        }
        return this.myHermitian;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return this.store().isSmall(comparedTo);
    }

    @Override
    public boolean isSymmetric() {
        if (this.mySymmetric == null) {
            this.mySymmetric = this.isSquare() && this.store().equals((MatrixStore<N>)this.store().transpose(), EQUALS);
        }
        return this.mySymmetric;
    }

    @Override
    public M left(Access2D<N> ... left) {
        return this.newInstance(this.store().left(left));
    }

    @Override
    public M left(Access2D<N> left) {
        return this.newInstance(this.store().left(left));
    }

    @Override
    public M left(long numberOfColumns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().left(numberOfColumns)));
    }

    @Override
    public M limits(long rowLimit, long columnLimit) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().limits(rowLimit, columnLimit)));
    }

    @Deprecated
    public final M logical() {
        return (M)this;
    }

    @Override
    public M multiply(double scalarMultiplicand) {
        return this.newInstance((ElementsSupplier<N>)this.store().multiply(scalarMultiplicand));
    }

    @Override
    public M multiply(M multiplicand) {
        ProgrammingError.throwIfMultiplicationNotPossible(this.store(), multiplicand);
        return this.newInstance(this.store().multiply(((BasicMatrix)multiplicand).store()));
    }

    @Override
    public M multiply(N scalarMultiplicand) {
        return this.newInstance((ElementsSupplier<N>)this.store().multiply((Comparable)scalarMultiplicand));
    }

    @Override
    public M negate() {
        return this.newInstance((ElementsSupplier<N>)this.store().negate());
    }

    @Override
    public double norm() {
        return this.store().norm();
    }

    @Override
    public M offsets(long rowOffset, long columnOffset) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().offsets(rowOffset, columnOffset)));
    }

    @Override
    public M onAll(UnaryFunction<N> operator) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onAll((UnaryFunction)operator));
    }

    @Override
    public M onAny(Transformation2D<N> operator) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onAny((Transformation2D)operator));
    }

    @Override
    public M onColumns(BinaryFunction<N> operator, Access1D<N> right) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onColumns((BinaryFunction)operator, (Access1D)right));
    }

    @Override
    public M onMatching(Access2D<N> left, BinaryFunction<N> operator) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onMatching((Access2D)left, (BinaryFunction)operator));
    }

    @Override
    public M onMatching(BinaryFunction<N> operator, Access2D<N> right) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onMatching((BinaryFunction)operator, (Access2D)right));
    }

    @Override
    public M onRows(BinaryFunction<N> operator, Access1D<N> right) {
        return this.newInstance((ElementsSupplier<N>)this.supplier().onRows((BinaryFunction)operator, (Access1D)right));
    }

    @Override
    public M power(int power) {
        return this.newInstance((ElementsSupplier<N>)this.store().power(power));
    }

    @Override
    public M reduceColumns(Aggregator aggregator) {
        return this.newInstance((ElementsSupplier)this.store().reduceColumns(aggregator).collect(this.store().physical()));
    }

    @Override
    public M reduceRows(Aggregator aggregator) {
        return this.newInstance((ElementsSupplier)this.store().reduceRows(aggregator).collect(this.store().physical()));
    }

    @Override
    public M repeat(int rowsRepetitions, int columnsRepetitions) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().repeat(rowsRepetitions, columnsRepetitions)));
    }

    @Override
    public M right(Access2D<N> ... right) {
        return this.newInstance(this.store().right(right));
    }

    @Override
    public M right(Access2D<N> right) {
        return this.newInstance(this.store().right(right));
    }

    @Override
    public M right(long numberOfColumns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().right(numberOfColumns)));
    }

    @Override
    public M row(int row) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().row(row)));
    }

    @Override
    public M row(long row) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().row(row)));
    }

    @Override
    public M rows(int ... rows) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().rows(rows)));
    }

    @Override
    public M rows(long ... rows) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().rows(rows)));
    }

    public M select(int[] rows, int[] columns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().select(rows, columns)));
    }

    public M select(long[] rows, long[] columns) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().select(rows, columns)));
    }

    @Override
    public M signum() {
        return this.newInstance((ElementsSupplier<N>)this.store().signum());
    }

    @Override
    public M solve(Access2D<?> rhs) {
        return this.newInstance(this.getSolutionProvider(false, rhs).solve(rhs).orElseGet(() -> this.getSolutionProvider(true, rhs).solve(rhs).get()));
    }

    @Override
    public M subtract(double scalarSubtrahend) {
        return this.newInstance((ElementsSupplier<N>)this.store().subtract(scalarSubtrahend));
    }

    @Override
    public M subtract(M subtrahend) {
        ProgrammingError.throwIfNotEqualDimensions(this.store(), subtrahend);
        return this.newInstance(this.store().subtract(((BasicMatrix)subtrahend).store()));
    }

    @Override
    public M subtract(N scalarSubtrahend) {
        return this.newInstance((ElementsSupplier<N>)this.store().subtract((Comparable)scalarSubtrahend));
    }

    @Override
    public M superimpose(long row, long col, Access2D<N> matrix) {
        return this.newInstance(this.store().superimpose(row, col, matrix));
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        this.supplier().supplyTo(receiver);
    }

    @Override
    public M symmetric(boolean upper) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().symmetric(upper)));
    }

    @Deprecated
    public Scalar<N> toScalar(long row, long col) {
        return this.store().toScalar(row, col);
    }

    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public M transpose() {
        return this.newInstance(this.supplier().transpose());
    }

    @Override
    public M triangular(boolean upper, boolean assumeOne) {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().triangular(upper, assumeOne)));
    }

    @Override
    public M tridiagonal() {
        return this.newInstance((ElementsSupplier<N>)((Object)this.store().tridiagonal()));
    }

    private Provider2D.Condition getConditionProvider() {
        if (this.myDecomposition instanceof Provider2D.Condition) {
            return (Provider2D.Condition)((Object)this.myDecomposition);
        }
        SingularValue<N> provider = this.newSingularValue(this.supplier());
        provider.decompose(this.supplier());
        this.myDecomposition = provider;
        return provider;
    }

    private Provider2D.Determinant<N> getDeterminantProvider() {
        if (this.myDecomposition instanceof Provider2D.Determinant) {
            return (Provider2D.Determinant)((Object)this.myDecomposition);
        }
        DeterminantTask<N> task = this.newDeterminantTask(this.supplier());
        if (task instanceof MatrixDecomposition) {
            this.myDecomposition = (MatrixDecomposition)((Object)task);
        }
        return task.toDeterminantProvider(this.supplier(), this::store);
    }

    private Provider2D.Eigenpairs getEigenpairsProvider() {
        if (this.myDecomposition instanceof Provider2D.Eigenpairs) {
            return (Provider2D.Eigenpairs)((Object)this.myDecomposition);
        }
        Eigenvalue<N> provider = this.newEigenvalue(this.supplier());
        provider.decompose(this.supplier());
        this.myDecomposition = provider;
        return provider;
    }

    private Provider2D.Inverse<Optional<MatrixStore<N>>> getInverseProvider(boolean safe) {
        InverterTask<N> task;
        if (safe ? this.myDecomposition instanceof SingularValue : this.myDecomposition instanceof Provider2D.Inverse) {
            return (Provider2D.Inverse)((Object)this.myDecomposition);
        }
        InverterTask<N> inverterTask = task = safe ? this.newSingularValue(this.supplier()) : this.newInverterTask(this.supplier());
        if (task instanceof MatrixDecomposition) {
            this.myDecomposition = (MatrixDecomposition)((Object)task);
        }
        return task.toInverseProvider(this.supplier(), this::store);
    }

    private Provider2D.Rank getRankProvider() {
        if (!(this.myDecomposition instanceof Provider2D.Rank)) {
            this.myDecomposition = this.store().isTall() ? this.newQR(this.supplier()) : (this.store().isFat() ? this.newSingularValue(this.supplier()) : this.newLDU(this.supplier()));
            this.myDecomposition.decompose(this.supplier());
        }
        return (Provider2D.Rank)((Object)this.myDecomposition);
    }

    private Provider2D.Solution<Optional<MatrixStore<N>>> getSolutionProvider(boolean safe, Access2D<?> rhs) {
        SolverTask<N> task;
        if (safe ? this.myDecomposition instanceof SingularValue : this.myDecomposition instanceof Provider2D.Inverse) {
            return (Provider2D.Solution)((Object)this.myDecomposition);
        }
        SolverTask<N> solverTask = task = safe ? this.newSingularValue(this.supplier()) : this.newSolverTask(this.supplier(), rhs);
        if (task instanceof MatrixDecomposition) {
            this.myDecomposition = (MatrixDecomposition)((Object)task);
        }
        return task.toSolutionProvider(this.supplier(), this::store, rhs);
    }

    abstract Cholesky<N> newCholesky(Structure2D var1);

    abstract DeterminantTask<N> newDeterminantTask(Structure2D var1);

    abstract Eigenvalue<N> newEigenvalue(Structure2D var1);

    abstract M newInstance(ElementsSupplier<N> var1);

    abstract InverterTask<N> newInverterTask(Structure2D var1);

    abstract LDL<N> newLDL(Structure2D var1);

    final LDU<N> newLDU(Structure2D typical) {
        if (this.mySPD != null && this.mySPD.booleanValue()) {
            return this.newCholesky(typical);
        }
        if (this.myHermitian != null && this.myHermitian.booleanValue()) {
            return this.newLDL(typical);
        }
        return this.newLU(typical);
    }

    abstract LU<N> newLU(Structure2D var1);

    abstract QR<N> newQR(Structure2D var1);

    abstract SingularValue<N> newSingularValue(Structure2D var1);

    abstract SolverTask<N> newSolverTask(Structure2D var1, Structure2D var2);

    MatrixStore<N> store() {
        if (this.myStore == null) {
            this.myStore = (MatrixStore)this.mySupplier.collect(this.myFactory);
        }
        return this.myStore;
    }

    ElementsSupplier<N> supplier() {
        if (this.myStore != null) {
            return this.myStore;
        }
        return this.mySupplier;
    }
}

