/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access2D;

abstract class InPlaceDecomposition<N extends Comparable<N>>
extends GenericDecomposition<N> {
    private int myColDim;
    private DecompositionStore<N> myInPlace;
    private int myRowDim;

    protected InPlaceDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    public MatrixStore<N> getInverse() {
        return this.getInverse(this.allocate(this.getRowDim(), this.getRowDim()));
    }

    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    @Override
    public int getRowDim() {
        return this.myRowDim;
    }

    protected DecompositionStore<N> getInPlace() {
        return this.myInPlace;
    }

    DecompositionStore<N> setInPlace(Access2D.Collectable<N, ? super DecompositionStore<N>> matrix) {
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        if (this.myInPlace == null || this.myRowDim != tmpRowDim || this.myColDim != tmpColDim) {
            this.myInPlace = this.makeZero(tmpRowDim, tmpColDim);
            this.myRowDim = tmpRowDim;
            this.myColDim = tmpColDim;
        }
        matrix.supplyTo(this.myInPlace);
        this.computed(false);
        return this.myInPlace;
    }
}

