/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

abstract class LUDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements LU<N> {
    private final Pivot myPivot = new Pivot();

    protected LUDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public int countSignificant(double threshold) {
        DecompositionStore internal = this.getInPlace();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(Math.abs(internal.doubleValue(ij, ij)) > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.doDecompose(matrix, true);
    }

    @Override
    public boolean decomposeWithoutPivoting(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.doDecompose(matrix, false);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        if (this.myPivot.signum() == -1) {
            return (N)((Comparable)((Scalar)tmpAggrFunc.toScalar().negate()).get());
        }
        return (N)((Comparable)tmpAggrFunc.get());
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        if (this.myPivot.isModified()) {
            preallocated.fillAll((Comparable)this.scalar().zero().get());
            int[] pivotOrder = this.myPivot.getOrder();
            int numbRows = this.getRowDim();
            for (int i = 0; i < numbRows; ++i) {
                preallocated.set((long)i, (long)pivotOrder[i], PrimitiveMath.ONE);
            }
        }
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, true, false, !this.myPivot.isModified());
        preallocated.substituteBackwards(body, false, false, false);
        return preallocated;
    }

    @Override
    public MatrixStore<N> getL() {
        Structure2D.Logical logical = this.getInPlace().triangular(false, true);
        int nbRows = this.getRowDim();
        if (nbRows < this.getColDim()) {
            return logical.limits(nbRows, nbRows);
        }
        return logical;
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public double getRankThreshold() {
        Object largest = this.getInPlace().aggregateDiagonal(Aggregator.LARGEST);
        double epsilon = this.getDimensionalEpsilon();
        return epsilon * Math.max(Double.MIN_NORMAL, NumberDefinition.doubleValue(largest));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        preallocated.fillMatching(this.collect(rhs).rows(this.myPivot.getOrder()));
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, true, false, false);
        preallocated.substituteBackwards(body, false, false, false);
        return preallocated;
    }

    @Override
    public MatrixStore<N> getU() {
        Structure2D.Logical retVal = this.getInPlace().triangular(true, false);
        int nbCols = this.getColDim();
        if (this.getRowDim() > nbCols) {
            retVal = retVal.limits(nbCols, nbCols);
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isPivoted() {
        return this.myPivot.isModified();
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean pivoting) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        this.getColDim();
        int tmpMinDim = this.getMinDim();
        this.myPivot.reset(tmpRowDim);
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            int tmpPivotRow;
            if (pivoting && (tmpPivotRow = tmpInPlace.indexOfLargestInColumn(ij, ij)) != ij) {
                tmpInPlace.exchangeRows(tmpPivotRow, ij);
                this.myPivot.change(tmpPivotRow, ij);
            }
            if (NumberContext.compare(tmpInPlace.doubleValue(ij, ij), PrimitiveMath.ZERO) != 0) {
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyLU(ij, tmpMultipliers);
                continue;
            }
            tmpInPlace.set((long)ij, (long)ij, PrimitiveMath.ZERO);
        }
        return this.computed(true);
    }

    @Override
    protected boolean checkSolvability() {
        return this.isSquare() && this.isFullRank();
    }

    int[] getReducedPivots() {
        int[] retVal = new int[this.getRank()];
        int[] tmpFullPivots = this.getPivotOrder();
        DecompositionStore tmpInPlace = this.getInPlace();
        int tmpRedInd = 0;
        for (int ij = 0; ij < tmpFullPivots.length; ++ij) {
            if (tmpInPlace.isSmall(ij, ij, PrimitiveMath.ONE)) continue;
            retVal[tmpRedInd++] = tmpFullPivots[ij];
        }
        return retVal;
    }

    static final class Rational
    extends LUDecomposition<RationalNumber> {
        Rational() {
            super(GenericStore.RATIONAL);
        }
    }

    static final class Quat
    extends LUDecomposition<Quaternion> {
        Quat() {
            super(GenericStore.QUATERNION);
        }
    }

    static final class Primitive
    extends LUDecomposition<Double> {
        Primitive() {
            super(Primitive64Store.FACTORY);
        }
    }

    static final class Complex
    extends LUDecomposition<ComplexNumber> {
        Complex() {
            super(GenericStore.COMPLEX);
        }
    }
}

