/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.SWAP;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

final class RawLU
extends RawDecomposition
implements LU<Double> {
    private final Pivot myPivot = new Pivot();

    RawLU() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] data = this.reset(matrix, false);
        this.getInternalStore().fillMatching(matrix);
        this.doDecompose(data, true);
        return this.getDeterminant();
    }

    @Override
    public int countSignificant(double threshold) {
        RawStore internal = this.getInternalStore();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(Math.abs(internal.doubleValue(ij, ij)) > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] data = this.reset(matrix, false);
        matrix.supplyTo(this.getInternalStore());
        return this.doDecompose(data, true);
    }

    @Override
    public boolean decomposeWithoutPivoting(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] data = this.reset(matrix, false);
        matrix.supplyTo(this.getInternalStore());
        return this.doDecompose(data, false);
    }

    @Override
    public Double getDeterminant() {
        int n;
        int m = this.getRowDim();
        if (m != (n = this.getColDim())) {
            throw new IllegalArgumentException("RawStore must be square.");
        }
        double[][] LU2 = this.getInternalData();
        double d = this.myPivot.signum();
        for (int j = 0; j < n; ++j) {
            d *= LU2[j][j];
        }
        return d;
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse(preallocated);
    }

    @Override
    public MatrixStore<Double> getL() {
        Structure2D.Logical logical = this.getInternalStore().triangular(false, true);
        int nbRows = this.getRowDim();
        if (nbRows < this.getColDim()) {
            return logical.limits(nbRows, nbRows);
        }
        return logical;
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public double getRankThreshold() {
        double largest = (Double)this.getInternalStore().aggregateDiagonal(Aggregator.LARGEST);
        double epsilon = this.getDimensionalEpsilon();
        return epsilon * Math.max(Double.MIN_NORMAL, largest);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        Primitive64Store tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        this.collect(rhs).rows(this.myPivot.getOrder()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> getU() {
        Structure2D.Logical retVal = this.getInternalStore().triangular(true, false);
        int nbCols = this.getColDim();
        if (this.getRowDim() > nbCols) {
            retVal = retVal.limits(nbCols, nbCols);
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(original, false);
        this.getInternalStore().fillMatching(original);
        this.doDecompose(tmpData, true);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isPivoted() {
        return this.myPivot.isModified();
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(body, false);
        this.getInternalStore().fillMatching(body);
        this.doDecompose(tmpData, true);
        if (this.isSolvable()) {
            Primitive64Store.FACTORY.makeWrapper(rhs).rows(this.myPivot.getOrder()).supplyTo(preallocated);
            return this.doSolve(preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data, boolean pivoting) {
        int m = this.getRowDim();
        int n = this.getColDim();
        this.myPivot.reset(m);
        int limit = Math.min(m, n);
        for (int ij = 0; ij < limit; ++ij) {
            double[] rowP;
            double valI;
            double valP;
            if (pivoting) {
                int p = ij;
                valP = PrimitiveMath.ABS.invoke(data[p][ij]);
                for (int i = ij + 1; i < m; ++i) {
                    valI = PrimitiveMath.ABS.invoke(data[i][ij]);
                    if (!(valI > valP)) continue;
                    p = i;
                    valP = valI;
                }
                if (p != ij) {
                    SWAP.exchangeRows(data, ij, p);
                    this.myPivot.change(ij, p);
                }
            }
            if (NumberContext.compare(valP = (rowP = data[ij])[ij], PrimitiveMath.ZERO) == 0) continue;
            for (int i = ij + 1; i < m; ++i) {
                double[] rowI = data[i];
                valI = rowI[ij] / valP;
                if (NumberContext.compare(valI, PrimitiveMath.ZERO) == 0) continue;
                rowI[ij] = valI;
                AXPY.invoke(rowI, 0, -valI, rowP, 0, ij + 1, n);
            }
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(PhysicalStore<Double> preallocated) {
        int[] pivotOrder = this.myPivot.getOrder();
        int numbRows = this.getRowDim();
        for (int i = 0; i < numbRows; ++i) {
            preallocated.set((long)i, (long)pivotOrder[i], PrimitiveMath.ONE);
        }
        RawStore body = this.getInternalStore();
        preallocated.substituteForwards(body, true, false, !this.myPivot.isModified());
        preallocated.substituteBackwards(body, false, false, false);
        return preallocated;
    }

    private MatrixStore<Double> doSolve(PhysicalStore<Double> preallocated) {
        RawStore body = this.getInternalStore();
        preallocated.substituteForwards(body, true, false, false);
        preallocated.substituteBackwards(body, false, false, false);
        return preallocated;
    }

    @Override
    protected boolean checkSolvability() {
        return this.isSquare() && this.isFullRank();
    }
}

