/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class UpperTriangularStore<N extends Comparable<N>>
extends ShadingStore<N> {
    private final boolean myUnitDiagonal;

    UpperTriangularStore(MatrixStore<N> base, boolean unitDiagonal) {
        super(base);
        this.myUnitDiagonal = unitDiagonal;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row > col) {
            return PrimitiveMath.ZERO;
        }
        if (this.myUnitDiagonal && row == col) {
            return PrimitiveMath.ONE;
        }
        return this.base().doubleValue(row, col);
    }

    @Override
    public int firstInRow(int row) {
        return row;
    }

    @Override
    public N get(long row, long col) {
        if (row > col) {
            return (N)((Comparable)this.zero().get());
        }
        if (this.myUnitDiagonal && row == col) {
            return (N)((Comparable)this.one().get());
        }
        return this.base().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return Math.min(col + 1, this.getRowDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row > col) {
            return this.zero();
        }
        if (this.myUnitDiagonal && row == col) {
            return this.one();
        }
        return this.base().toScalar(row, col);
    }
}

