/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import org.ojalgo.matrix.ComplexMatrix;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public interface BasicLogger {
    public static final BasicLogger DEBUG = new BasicWriter(System.out);
    public static final BasicLogger ERROR = new BasicWriter(System.err);
    public static final BasicLogger NULL = new BasicLogger(){

        @Override
        public Optional<Writer> asWriter() {
            return Optional.empty();
        }

        @Override
        public void print(boolean value) {
        }

        @Override
        public void print(byte value) {
        }

        @Override
        public void print(char value) {
        }

        @Override
        public void print(double value) {
        }

        @Override
        public void print(float value) {
        }

        @Override
        public void print(int value) {
        }

        @Override
        public void print(long value) {
        }

        @Override
        public void print(Object object) {
        }

        @Override
        public void print(short value) {
        }

        @Override
        public void print(Throwable throwable) {
        }

        @Override
        public void printf(String format, Object ... args) {
        }

        @Override
        public void println() {
        }
    };

    public static void debug() {
        NotNull.println(DEBUG);
    }

    @Deprecated
    public static void debug(int width, Object ... columns) {
        BasicLogger.debugColumns(width, columns);
    }

    public static void debug(int tabs, String message, Object ... arguments) {
        NotNull.println(DEBUG, tabs, message, arguments);
    }

    public static void debug(Object message) {
        NotNull.println(DEBUG, message);
    }

    @Deprecated
    public static void debug(String message, Access2D<?> matrix) {
        BasicLogger.debugMatrix(message, matrix);
    }

    @Deprecated
    public static void debug(String message, Access2D<?> matrix, NumberContext context) {
        BasicLogger.debugMatrix(message, matrix, context);
    }

    public static void debug(String message, Object ... arguments) {
        NotNull.println(DEBUG, message, arguments);
    }

    public static void debug(Throwable throwable, String message, Object ... arguments) {
        NotNull.println(DEBUG, throwable, message, arguments);
    }

    public static void debugColumns(int width, Object ... columns) {
        NotNull.columns(DEBUG, width, columns);
    }

    public static void debugMatrix(String message, Access2D<?> matrix) {
        NotNull.printmtrx(DEBUG, message, matrix, PrivateDetails.MATRIX_ELEMENT_CONTEXT);
    }

    public static void debugMatrix(String message, Access2D<?> matrix, NumberContext context) {
        NotNull.printmtrx(DEBUG, message, matrix, context);
    }

    public static void error() {
        NotNull.println(ERROR);
    }

    @Deprecated
    public static void error(int width, Object ... columns) {
        BasicLogger.errorColumns(width, columns);
    }

    public static void error(int tabs, String message, Object ... arguments) {
        NotNull.println(ERROR, tabs, message, arguments);
    }

    public static void error(Object message) {
        NotNull.println(ERROR, message);
    }

    @Deprecated
    public static void error(String message, Access2D<?> matrix) {
        BasicLogger.errorMatrix(message, matrix);
    }

    @Deprecated
    public static void error(String message, Access2D<?> matrix, NumberContext context) {
        BasicLogger.errorMatrix(message, matrix, context);
    }

    public static void error(String message, Object ... arguments) {
        NotNull.println(ERROR, message, arguments);
    }

    public static void error(Throwable throwable, String message, Object ... arguments) {
        NotNull.println(ERROR, throwable, message, arguments);
    }

    public static void errorColumns(int width, Object ... columns) {
        NotNull.columns(ERROR, width, columns);
    }

    public static void errorMatrix(String message, Access2D<?> matrix) {
        NotNull.printmtrx(ERROR, message, matrix, PrivateDetails.MATRIX_ELEMENT_CONTEXT);
    }

    public static void errorMatrix(String message, Access2D<?> matrix, NumberContext context) {
        NotNull.printmtrx(ERROR, message, matrix, context);
    }

    public Optional<Writer> asWriter();

    default public void columns(int width, Object ... columns) {
        int i;
        char[] chars = new char[width];
        Arrays.fill(chars, ' ');
        String padder = new String(chars);
        String[] strings = new String[columns.length];
        for (i = 0; i < strings.length; ++i) {
            strings[i] = String.valueOf(columns[i]);
        }
        for (i = 0; i < strings.length; ++i) {
            strings[i] = strings[i] + padder;
        }
        for (i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].substring(0, width);
        }
        for (i = 0; i < strings.length; ++i) {
            this.print(strings[i]);
        }
        this.println();
    }

    public void print(boolean var1);

    public void print(byte var1);

    public void print(char var1);

    public void print(double var1);

    public void print(float var1);

    public void print(int var1);

    public void print(long var1);

    public void print(Object var1);

    public void print(short var1);

    public void print(Throwable var1);

    public void printf(String var1, Object ... var2);

    public void println();

    default public void println(int tabs, String message, Object ... args) {
        for (int i = 0; i < tabs; ++i) {
            this.print('\t');
        }
        this.print(TypeUtils.format(message, args));
        this.println();
    }

    default public void println(Object object) {
        this.print(object);
        this.println();
    }

    default public void println(String message, Object ... args) {
        this.print(TypeUtils.format(message, args));
        this.println();
    }

    default public void println(Throwable throwable, String message, Object ... args) {
        this.print(TypeUtils.format(message, args));
        this.println();
        this.print(throwable);
    }

    default public void printmtrx(String message, Access2D<?> matrix) {
        PrivateDetails.printmtrx(this, message, matrix, PrivateDetails.MATRIX_ELEMENT_CONTEXT);
    }

    default public void printmtrx(String message, Access2D<?> matrix, NumberContext context) {
        PrivateDetails.printmtrx(this, message, matrix, context);
    }

    public static class PrivateDetails {
        static final NumberContext MATRIX_ELEMENT_CONTEXT = NumberContext.ofScale(6);

        private static void printmtrx(BasicLogger appender, Access2D<?> matrix, NumberContext context, boolean plain) {
            String tmpElementString;
            int i;
            int tmpRowDim = (int)matrix.countRows();
            int tmpColDim = (int)matrix.countColumns();
            String[][] tmpElements = new String[tmpRowDim][tmpColDim];
            int tmpWidth = 0;
            for (int j = 0; j < tmpColDim; ++j) {
                for (i = 0; i < tmpRowDim; ++i) {
                    Object tmpElementNumber = matrix.get(i, j);
                    tmpElementString = PrivateDetails.toString(tmpElementNumber, context, plain);
                    tmpWidth = Math.max(tmpWidth, tmpElementString.length());
                    tmpElements[i][j] = tmpElementString;
                }
            }
            ++tmpWidth;
            for (i = 0; i < tmpRowDim; ++i) {
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpElementString = tmpElements[i][j];
                    int tmpPadding = tmpWidth - tmpElementString.length();
                    for (int p = 0; p < tmpPadding; ++p) {
                        appender.print(' ');
                    }
                    appender.print(tmpElementString);
                }
                appender.println();
            }
        }

        private static String toString(Comparable<?> number, NumberContext context, boolean plain) {
            if (plain) {
                if (number instanceof Scalar) {
                    return ((Scalar)number).toPlainString(context);
                }
                return context.enforce(BigDecimal.valueOf(NumberDefinition.doubleValue(number))).toPlainString();
            }
            if (number instanceof Scalar) {
                return ((Scalar)number).toString(context);
            }
            return context.enforce(BigDecimal.valueOf(NumberDefinition.doubleValue(number))).toString();
        }

        static void printmtrx(BasicLogger appender, String message, Access2D<?> matrix, NumberContext context) {
            appender.println(message);
            if (matrix.count() > 0L) {
                if (matrix instanceof ComplexMatrix || matrix.get(0L, 0L) instanceof ComplexNumber) {
                    PrivateDetails.printmtrx(appender, matrix, context, false);
                } else {
                    PrivateDetails.printmtrx(appender, matrix, context, true);
                }
            }
        }
    }

    public static interface Printable {
        public void print(BasicLogger var1);
    }

    public static class NotNull {
        static void columns(BasicLogger appender, int width, Object ... columns) {
            if (appender != null) {
                appender.columns(width, columns);
            }
        }

        static void println(BasicLogger appender) {
            if (appender != null) {
                appender.println();
            }
        }

        static void println(BasicLogger appender, int tabs, String messagePattern, Object ... arguments) {
            if (appender != null) {
                appender.println(tabs, messagePattern, arguments);
            }
        }

        static void println(BasicLogger appender, Object message) {
            if (appender != null) {
                appender.println(message);
            }
        }

        static void println(BasicLogger appender, String messagePattern, Object ... arguments) {
            if (appender != null) {
                appender.println(messagePattern, arguments);
            }
        }

        static void println(BasicLogger appender, Throwable throwable, String messagePattern, Object ... arguments) {
            if (appender != null) {
                appender.println(throwable, messagePattern, arguments);
            }
        }

        static void printmtrx(BasicLogger appender, String message, Access2D<?> matrix, NumberContext context) {
            if (message != null) {
                appender.printmtrx(message, matrix, context);
            }
        }
    }

    public static interface Buffer {
        public void clear();

        public void flush(Appendable var1);

        public void flush(BasicLogger var1);
    }

    public static final class BasicWriter
    extends Writer
    implements BasicLogger {
        private final PrintWriter myPrintWriter;

        public BasicWriter(OutputStream out) {
            this.myPrintWriter = new PrintWriter(out, true);
        }

        public BasicWriter(Writer out) {
            this.myPrintWriter = new PrintWriter(out, true);
        }

        @Override
        public Optional<Writer> asWriter() {
            return Optional.of(this);
        }

        @Override
        public void close() throws IOException {
            this.myPrintWriter.close();
        }

        @Override
        public void flush() throws IOException {
            this.myPrintWriter.flush();
        }

        @Override
        public void print(boolean value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(byte value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(char value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(double value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(float value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(int value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(long value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(Object object) {
            this.myPrintWriter.append(object.toString());
        }

        @Override
        public void print(short value) {
            this.myPrintWriter.print(value);
        }

        @Override
        public void print(Throwable throwable) {
            throwable.printStackTrace(this.myPrintWriter);
        }

        @Override
        public void printf(String format, Object ... args) {
            this.myPrintWriter.printf(format, args);
            this.myPrintWriter.println();
        }

        @Override
        public void println() {
            this.myPrintWriter.println();
        }

        @Override
        public void println(Object object) {
            this.myPrintWriter.println(object);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.myPrintWriter.write(cbuf, off, len);
        }
    }
}

