/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.netio.ToFileWriter;
import org.ojalgo.type.function.OperatorWithException;

public final class DataWriter<T>
implements ToFileWriter<T> {
    private final DataOutputStream myOutput;
    private final Serializer<T> mySerializer;

    public static <T> DataWriter<T> of(File file, Serializer<T> serializer) {
        return new DataWriter<T>(ToFileWriter.output(file), serializer);
    }

    public static <T> DataWriter<T> of(File file, Serializer<T> serializer, OperatorWithException<OutputStream> filter) {
        return new DataWriter<T>(filter.apply(ToFileWriter.output(file)), serializer);
    }

    public static <T> DataWriter<T> of(InMemoryFile file, Serializer<T> serializer) {
        return new DataWriter<T>(file.newOutputStream(), serializer);
    }

    public static <T> DataWriter<T> of(InMemoryFile file, Serializer<T> serializer, OperatorWithException<OutputStream> filter) {
        return new DataWriter<T>(filter.apply(file.newOutputStream()), serializer);
    }

    public DataWriter(OutputStream outputStream, Serializer<T> serializer) {
        this.myOutput = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.mySerializer = serializer;
    }

    @Override
    public void close() throws IOException {
        this.myOutput.close();
    }

    @Override
    public void write(T itemToWrite) {
        this.mySerializer.accept(itemToWrite, this.myOutput);
    }

    @FunctionalInterface
    public static interface Serializer<T>
    extends BiConsumer<T, DataOutput> {
        @Override
        default public void accept(T data, DataOutput output) {
            try {
                this.serialize(data, output);
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        public void serialize(T var1, DataOutput var2) throws IOException;
    }
}

