/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.function.Predicate;
import org.ojalgo.netio.FromFileReader;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.type.function.AutoSupplier;
import org.ojalgo.type.function.OperatorWithException;

public final class TextLineReader
implements FromFileReader<String> {
    private final BufferedReader myReader;

    public static boolean isLineOK(String line) {
        return line != null && line.length() > 0 && !line.startsWith("#");
    }

    public static TextLineReader of(File file) {
        return new TextLineReader(FromFileReader.input(file));
    }

    public static TextLineReader of(File file, OperatorWithException<InputStream> filter) {
        return new TextLineReader(filter.apply(FromFileReader.input(file)));
    }

    public static TextLineReader of(InMemoryFile file) {
        return new TextLineReader(file.newInputStream());
    }

    public static TextLineReader of(InMemoryFile file, OperatorWithException<InputStream> filter) {
        return new TextLineReader(filter.apply(file.newInputStream()));
    }

    public TextLineReader(InputStream inputStream) {
        try {
            this.myReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException cause) {
            throw new RuntimeException(cause);
        }
    }

    TextLineReader(Reader delegate) {
        this.myReader = new BufferedReader(delegate);
    }

    @Override
    public void close() throws IOException {
        this.myReader.close();
    }

    @Override
    public String read() {
        try {
            return this.myReader.readLine();
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    public <T> AutoSupplier<T> withFilteredParser(Parser<T> parser) {
        return AutoSupplier.mapped(this, TextLineReader::isLineOK, parser::parse);
    }

    public <T> AutoSupplier<T> withFilteredParser(Predicate<String> filter, Parser<T> parser) {
        return AutoSupplier.mapped(this, filter, parser::parse);
    }

    public <T> AutoSupplier<T> withParser(Parser<T> parser) {
        return AutoSupplier.mapped(this, parser::parse);
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(String var1);
    }
}

