/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.array.SparseArray;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.type.IndexSelector;
import org.ojalgo.type.context.NumberContext;

abstract class ActiveSetSolver
extends ConstrainedSolver {
    private static final NumberContext LAGRANGE = ACCURACY.withScale(6);
    private static final NumberContext SLACK = ACCURACY.withPrecision(6).withScale(10);
    private static final NumberContext SOLUTION = ACCURACY.withPrecision(6).withScale(4);
    private final IndexSelector myActivator;
    private int myConstraintToInclude = -1;
    private MatrixStore<Double> myInvQC;
    private final Primitive64Store myIterationX;
    private boolean myShrinkSwitch = true;
    private final Primitive64Store mySlackI;

    ActiveSetSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        int numberOfVariables = this.countVariables();
        int numberOfEqualityConstraints = this.countEqualityConstraints();
        int numberOfInequalityConstraints = this.countInequalityConstraints();
        this.myActivator = new IndexSelector(numberOfInequalityConstraints);
        this.myIterationX = (Primitive64Store)Primitive64Store.FACTORY.make((long)numberOfVariables, 1L);
        this.mySlackI = (Primitive64Store)Primitive64Store.FACTORY.make((long)numberOfInequalityConstraints, 1L);
    }

    private void handleIterationSolution(Primitive64Store iterX, int[] excluded) {
        PhysicalStore<Primitive64Store> includedChange;
        PhysicalStore<Double> soluX = this.getSolutionX();
        iterX.modifyMatching(PrimitiveMath.SUBTRACT, soluX);
        double normCurrX = (Double)soluX.aggregateAll(Aggregator.LARGEST);
        double normStepX = (Double)iterX.aggregateAll(Aggregator.LARGEST);
        if (this.isLogDebug()) {
            this.log("Current: {} - {}", normCurrX, soluX.asList());
            this.log("Step: {} - {}", normStepX, iterX.asList());
        }
        if (this.isLogDebug() && this.options.validate && (includedChange = this.getMatrixAI(this.getIncluded()).get().multiply(iterX).copy()).count() > 0L) {
            this.log("Included-change: {}", includedChange.asList());
            double introducedError = (Double)includedChange.aggregateAll(Aggregator.LARGEST);
            if (!this.options.feasibility.isZero(introducedError)) {
                this.log("Nonzero Included-change! {}", introducedError);
            }
        }
        if (!SOLUTION.isSmall(normCurrX, normStepX)) {
            double stepLength = PrimitiveMath.ONE;
            if (excluded.length > 0) {
                MatrixStore<Double> slack = this.getSlackI(excluded);
                if (this.isLogDebug()) {
                    MatrixStore<Primitive64Store> change = this.getMatrixAI(excluded).get().multiply(iterX);
                    if (slack.count() != change.count()) {
                        throw new IllegalStateException();
                    }
                    PhysicalStore<Double> steps = slack.copy();
                    steps.modifyMatching(PrimitiveMath.DIVIDE, change);
                    this.log("Numer/slack: {}", new Object[]{slack.toRawCopy1D()});
                    this.log("Denom/chang: {}", new Object[]{change.toRawCopy1D()});
                    this.log("Looking for the largest possible step length (smallest positive scalar) among these: {}).", new Object[]{steps.toRawCopy1D()});
                }
                for (int i = 0; i < excluded.length; ++i) {
                    SparseArray<Double> excludedInequalityRow = this.getMatrixAI(excluded[i]);
                    double currentSlack = slack.doubleValue(i);
                    double slackChange = excludedInequalityRow.dot(iterX);
                    double fraction = Math.abs(currentSlack) / slackChange;
                    if (slackChange > PrimitiveMath.ZERO && !SLACK.isZero(slackChange) && SLACK.isSmall(slackChange, currentSlack)) {
                        fraction = PrimitiveMath.ZERO;
                    } else if (slackChange <= PrimitiveMath.ZERO || SLACK.isZero(slackChange)) {
                        fraction = PrimitiveMath.ONE;
                    }
                    if (!(PrimitiveMath.ZERO <= fraction) || !(fraction < stepLength)) continue;
                    stepLength = fraction;
                    this.setConstraintToInclude(excluded[i]);
                    if (!this.isLogDebug()) continue;
                    this.log("\tBest so far: {} @ {} ({}) \u2013\u2013\u2013 {} / {}.", stepLength, i, excluded[i], currentSlack, slackChange);
                }
            }
            if (ACCURACY.isZero(stepLength) && this.getConstraintToInclude() == this.getLastExcluded()) {
                if (this.isLogProgress()) {
                    this.log("Break cycle on redundant constraints because step length {} on constraint {}", stepLength, this.getConstraintToInclude());
                }
                this.setConstraintToInclude(-1);
            } else if (stepLength > PrimitiveMath.ZERO) {
                if (this.isLogProgress()) {
                    this.log("Performing update with step length {} adding constraint {}", stepLength, this.getConstraintToInclude());
                }
                iterX.axpy(stepLength, soluX);
            } else if (this.isLogProgress()) {
                this.log("Do nothing because step length {} and size {} but add constraint {}", stepLength, normStepX, this.getConstraintToInclude());
            }
        } else {
            if (this.isLogDebug()) {
                this.log("Step too small!", new Object[0]);
            }
            this.setState(Optimisation.State.FEASIBLE);
        }
        if (this.isLogDebug()) {
            this.log("Post iteration", new Object[0]);
            this.log("\tSolution: {}", soluX.asList());
            this.log("\tL: {}", this.getSolutionL().asList());
        }
        if (this.isLogDebug() || this.options.validate) {
            this.checkFeasibility();
        }
    }

    private void shrink() {
        int toExclude = this.suggestConstraintToExclude();
        if (toExclude < 0) {
            toExclude = this.myShrinkSwitch ? this.suggestUsingLagrangeMagnitude() : this.suggestUsingVectorProjection();
            boolean bl = this.myShrinkSwitch = !this.myShrinkSwitch;
        }
        if (this.isLogDebug()) {
            this.log("Will remove {}", toExclude);
        }
        this.exclude(toExclude);
    }

    private int suggestUsingLagrangeMagnitude() {
        int[] incl = this.myActivator.getIncluded();
        Primitive64Store soluL = this.getSolutionL();
        int numbEqus = this.countEqualityConstraints();
        int toExclude = incl[0];
        double maxWeight = PrimitiveMath.ZERO;
        for (int i = 0; i < incl.length; ++i) {
            double value = soluL.doubleValue((long)(numbEqus + incl[i]));
            double weight = PrimitiveMath.ABS.invoke(value) * PrimitiveMath.MAX.invoke(-value, PrimitiveMath.ONE);
            if (!(weight > maxWeight)) continue;
            maxWeight = weight;
            toExclude = incl[i];
        }
        return toExclude;
    }

    private int suggestUsingVectorProjection() {
        int[] incl = this.myActivator.getIncluded();
        int lastIncluded = this.myActivator.getLastIncluded();
        AggregatorFunction<Double> aggregator = PrimitiveAggregator.getSet().norm2();
        SparseArray<Double> lastRow = this.getMatrixAI(lastIncluded);
        lastRow.visitAll(aggregator);
        double lastNorm = aggregator.doubleValue();
        int toExclude = lastIncluded;
        double maxWeight = PrimitiveMath.ZERO;
        for (int i = 0; i < incl.length; ++i) {
            aggregator.reset();
            SparseArray<Double> inclRow = this.getMatrixAI(incl[i]);
            inclRow.visitAll(aggregator);
            double inclNorm = aggregator.doubleValue();
            double weight = Math.abs(lastRow.dot(inclRow)) / lastNorm / inclNorm;
            if (!(weight > maxWeight)) continue;
            maxWeight = weight;
            toExclude = incl[i];
        }
        return toExclude;
    }

    protected int countExcluded() {
        return this.myActivator.countExcluded();
    }

    protected int countIncluded() {
        return this.myActivator.countIncluded();
    }

    protected void exclude(int anIndexToExclude) {
        this.myActivator.exclude(anIndexToExclude);
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return super.extractSolution();
    }

    protected int[] getExcluded() {
        return this.myActivator.getExcluded();
    }

    protected int[] getIncluded() {
        return this.myActivator.getIncluded();
    }

    protected int getLastExcluded() {
        return this.myActivator.getLastExcluded();
    }

    protected int getLastIncluded() {
        return this.myActivator.getLastIncluded();
    }

    protected void include(int anIndexToInclude) {
        this.myActivator.include(anIndexToInclude);
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        boolean usableKickStarter;
        boolean ok = super.initialise(kickStarter);
        this.myInvQC = this.getSolutionQ(this.getIterationC());
        Optimisation.State state = this.getState();
        boolean bl = usableKickStarter = kickStarter != null && kickStarter.getState().isApproximate();
        if (usableKickStarter) {
            this.getSolutionX().fillMatching(kickStarter);
            if (kickStarter.getState().isFeasible()) {
                state = kickStarter.getState();
            } else if (this.checkFeasibility()) {
                state = Optimisation.State.FEASIBLE;
            }
        }
        if (!state.isFeasible()) {
            Optimisation.Result resultLP = this.solveLP();
            this.getSolutionX().fillMatching(resultLP);
            this.getSolutionL().fillAll(PrimitiveMath.ZERO);
            if (resultLP.getState().isFeasible()) {
                state = resultLP.getState();
            } else if (this.checkFeasibility()) {
                state = Optimisation.State.FEASIBLE;
            }
        }
        if (state.isFeasible()) {
            this.resetActivator();
        } else {
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
        if (this.isLogDebug()) {
            this.checkFeasibility();
            this.log("Initial solution: {}", this.getSolutionX().copy().asList());
        }
        this.setState(state);
        return ok && state.isFeasible();
    }

    @Override
    protected boolean isIteratingPossible() {
        return !this.isZeroQ();
    }

    @Override
    protected boolean needsAnotherIteration() {
        if (this.isLogDebug()) {
            this.log("\nNeedsAnotherIteration?", new Object[0]);
        }
        int toInclude = -1;
        int toExclude = -1;
        toInclude = this.suggestConstraintToInclude();
        if (toInclude >= 0) {
            if (this.isLogDebug()) {
                this.log("Suggested to include: {}", toInclude);
            }
            this.myActivator.include(toInclude);
            return true;
        }
        toExclude = this.suggestConstraintToExclude();
        if (toExclude >= 0) {
            if (this.isLogDebug()) {
                this.log("Suggested to exclude: {}", toExclude);
            }
            this.exclude(toExclude);
            return true;
        }
        if (this.isLogDebug()) {
            this.log("Stop!", new Object[0]);
        }
        this.setState(Optimisation.State.OPTIMAL);
        return false;
    }

    protected int suggestConstraintToExclude() {
        double tmpVal;
        int retVal = -1;
        int[] included = this.myActivator.getIncluded();
        int lastIncluded = this.myActivator.getLastIncluded();
        int indexOfLastIncluded = -1;
        double tmpMin = PrimitiveMath.ZERO;
        int nbEqus = this.countEqualityConstraints();
        Primitive64Store soluL = this.getSolutionL();
        if (this.isLogDebug() && included.length > 0) {
            double[] multipliers = soluL.offsets(nbEqus, 0L).rows(included).toRawCopy1D();
            this.log("Looking for the largest negative lagrange multiplier among these: {}.", new Object[]{multipliers});
        }
        int limit = included.length;
        for (int i = 0; i < limit; ++i) {
            if (included[i] != lastIncluded) {
                tmpVal = soluL.doubleValue(nbEqus + included[i], 0L);
                if (!(tmpVal < tmpMin) || LAGRANGE.isZero(tmpVal)) continue;
                tmpMin = tmpVal;
                retVal = i;
                if (!this.isLogDebug()) continue;
                this.log("\tBest so far: {} @ {} ({}).", tmpMin, retVal, included[retVal]);
                continue;
            }
            indexOfLastIncluded = i;
        }
        if (retVal < 0 && indexOfLastIncluded >= 0 && (tmpVal = soluL.doubleValue(nbEqus + included[indexOfLastIncluded], 0L)) < tmpMin && !LAGRANGE.isZero(tmpVal)) {
            tmpMin = tmpVal;
            retVal = indexOfLastIncluded;
            if (this.isLogProgress()) {
                this.log("Only the last included needs to be excluded: {} @ {} ({}).", tmpMin, retVal, included[retVal]);
            }
        }
        if (this.isLogProgress()) {
            if (retVal < 0) {
                this.log("Nothing to exclude", new Object[0]);
            } else {
                this.log("Suggest to exclude: {} @ {} ({}).", tmpMin, retVal, included[retVal]);
            }
        }
        return retVal >= 0 ? included[retVal] : retVal;
    }

    protected int suggestConstraintToInclude() {
        return this.getConstraintToInclude();
    }

    protected String toActivatorString() {
        return this.myActivator.toString();
    }

    boolean checkFeasibility() {
        boolean retVal = true;
        PhysicalStore<Double> slackE = this.getSlackE();
        PhysicalStore<Double> slackI = this.getSlackI();
        if (retVal && slackE.count() > 0L) {
            double largestE;
            if (this.isLogDebug()) {
                this.log("E-slack: {}", slackE.asList());
            }
            if (!this.options.feasibility.isZero(largestE = ((Double)slackE.aggregateAll(Aggregator.LARGEST)).doubleValue())) {
                retVal = false;
                if (this.isLogDebug()) {
                    this.log("Nonzero E-slack! {}", largestE);
                }
            }
        }
        if (retVal && slackI.count() > 0L) {
            double minimumI;
            if (this.isLogDebug()) {
                this.log("I-slack: {}", slackI.asList());
            }
            if ((minimumI = ((Double)slackI.aggregateAll(Aggregator.MINIMUM)).doubleValue()) < PrimitiveMath.ZERO && !this.options.feasibility.isZero(minimumI)) {
                retVal = false;
                if (this.isLogDebug()) {
                    this.log("Negative I-slack! {}", minimumI);
                }
            }
        }
        return retVal;
    }

    @Override
    int countIterationConstraints() {
        return this.countEqualityConstraints() + this.countIncluded();
    }

    int getConstraintToInclude() {
        return this.myConstraintToInclude;
    }

    MatrixStore<Double> getInvQC() {
        return this.myInvQC;
    }

    @Override
    MatrixStore<Double> getIterationA() {
        int numbEqus = this.countEqualityConstraints();
        int numbVars = this.countVariables();
        int[] incl = this.myActivator.getIncluded();
        PhysicalStore retVal = (PhysicalStore)Primitive64Store.FACTORY.make(numbEqus + incl.length, numbVars);
        if (numbEqus > 0) {
            this.getMatrixAE().supplyTo(retVal.regionByLimits(numbEqus, numbVars));
        }
        for (int i = 0; i < incl.length; ++i) {
            this.getMatrixAI(incl[i]).supplyNonZerosTo(retVal.regionByRows(numbEqus + i));
        }
        return retVal;
    }

    @Override
    MatrixStore<Double> getIterationB() {
        int i;
        int numbEqus = this.countEqualityConstraints();
        int[] incl = this.myActivator.getIncluded();
        PhysicalStore retVal = (PhysicalStore)Primitive64Store.FACTORY.make(numbEqus + incl.length, 1);
        for (i = 0; i < numbEqus; ++i) {
            retVal.set((long)i, this.getMatrixBE().doubleValue(i));
        }
        for (i = 0; i < incl.length; ++i) {
            retVal.set((long)(numbEqus + i), this.getMatrixBI().doubleValue(incl[i]));
        }
        return retVal;
    }

    @Override
    MatrixStore<Double> getIterationC() {
        return this.getMatrixC();
    }

    Primitive64Store getIterationX() {
        return this.myIterationX;
    }

    PhysicalStore<Double> getSlackI() {
        MatrixStore<Double> mtrxBI = this.getMatrixBI();
        PhysicalStore<Double> mtrxX = this.getSolutionX();
        this.mySlackI.fillMatching(mtrxBI);
        int nbInequalities = mtrxBI.getRowDim();
        for (int i = 0; i < nbInequalities; ++i) {
            this.mySlackI.add((long)i, -this.getMatrixAI(i).dot(mtrxX));
        }
        return this.mySlackI;
    }

    MatrixStore<Double> getSlackI(int[] rows) {
        return this.getSlackI().rows(rows);
    }

    void handleIterationResults(boolean solved, Primitive64Store iterX, int[] included, int[] excluded) {
        this.incrementIterationsCount();
        if (solved) {
            this.handleIterationSolution(iterX, excluded);
        } else if (this.isIterationAllowed()) {
            if (this.isLogProgress()) {
                this.log("Constraints problem!", new Object[0]);
            }
            if (included.length >= 1) {
                this.shrink();
                this.performIteration();
            } else {
                this.setState(Optimisation.State.FAILED);
            }
        } else if (this.checkFeasibility()) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.FAILED);
        }
    }

    void resetActivator() {
        this.myActivator.excludeAll();
        int nbInes = this.countInequalityConstraints();
        int nbEqus = this.countEqualityConstraints();
        int nbVars = this.countVariables();
        int maxToInclude = nbVars - nbEqus;
        if (this.isLogDebug() && maxToInclude < 0) {
            this.log("Redundant contraints!", new Object[0]);
        }
        if (nbInes > 0 && maxToInclude > 0) {
            PhysicalStore<Double> ineqSlack = this.getSlackI();
            for (int i = 0; i < nbInes; ++i) {
                double slack = ineqSlack.doubleValue(i);
                if (!(slack >= PrimitiveMath.ZERO) || !ACCURACY.isZero(slack) || this.countIncluded() >= maxToInclude) continue;
                if (this.isLogDebug()) {
                    this.log("Will inlcude ineq {} with slack={}", i, slack);
                }
                this.include(i);
            }
        }
    }

    void setConstraintToInclude(int constraintToInclude) {
        this.myConstraintToInclude = constraintToInclude;
    }
}

