/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;

abstract class Primitive1D
implements Access1D<Double>,
Mutate1D {
    Primitive1D() {
    }

    static Primitive1D of(final double ... values) {
        return new Primitive1D(){

            @Override
            public int size() {
                return values.length;
            }

            @Override
            double doubleValue(int index) {
                return values[index];
            }

            @Override
            void set(int index, double value) {
                values[index] = value;
            }
        };
    }

    @Override
    public final long count() {
        return this.size();
    }

    @Override
    public final double doubleValue(long index) {
        return this.doubleValue(Math.toIntExact(index));
    }

    @Override
    public final Double get(long index) {
        return this.doubleValue(Math.toIntExact(index));
    }

    @Override
    public final void set(long index, Comparable<?> value) {
        this.set(Math.toIntExact(index), NumberDefinition.doubleValue(value));
    }

    @Override
    public final void set(long index, double value) {
        this.set(Math.toIntExact(index), value);
    }

    @Override
    public abstract int size();

    public final String toString() {
        return Access1D.toString(this);
    }

    abstract double doubleValue(int var1);

    abstract void set(int var1, double var2);
}

