/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.process.RandomProcess;

abstract class AbstractProcess<D extends Distribution>
implements RandomProcess<D> {
    AbstractProcess() {
    }

    public final double getExpected() {
        return this.getExpected(PrimitiveMath.ONE);
    }

    public final double getLowerConfidenceQuantile(double confidence) {
        return this.getLowerConfidenceQuantile(PrimitiveMath.ONE, confidence);
    }

    public final double getStandardDeviation() {
        return this.getStandardDeviation(PrimitiveMath.ONE);
    }

    public final double getUpperConfidenceQuantile(double confidence) {
        return this.getUpperConfidenceQuantile(PrimitiveMath.ONE, confidence);
    }

    public final double getVariance() {
        return this.getVariance(PrimitiveMath.ONE);
    }

    abstract double doStep(double var1, double var3);

    abstract double getCurrentValue();

    abstract double getExpected(double var1);

    abstract double getLowerConfidenceQuantile(double var1, double var3);

    abstract double getNormalisedRandomIncrement();

    abstract double getStandardDeviation(double var1);

    abstract double getUpperConfidenceQuantile(double var1, double var3);

    abstract double getVariance(double var1);

    abstract void setCurrentValue(double var1);

    final double step(double stepSize) {
        return this.doStep(stepSize, this.getNormalisedRandomIncrement());
    }
}

