/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.ojalgo.ProgrammingError;
import org.ojalgo.random.FrequencyMap;

public interface TwoStepMapper<T, R> {
    public void consume(T var1);

    public R getResults();

    default public void merge(R aggregate) {
        throw new ProgrammingError("Override to implement! " + aggregate);
    }

    public void reset();

    public static final class SimpleCache<K, V>
    implements TwoStepMapper<K, Map<K, V>> {
        private final Function<K, V> myFunction;
        private final Map<K, V> myCache = new ConcurrentHashMap();

        public SimpleCache(Function<K, V> function) {
            this.myFunction = function;
        }

        @Override
        public void consume(K item) {
            this.myCache.computeIfAbsent(item, k -> this.myFunction.apply(k));
        }

        @Override
        public Map<K, V> getResults() {
            return this.myCache;
        }

        @Override
        public void merge(Map<K, V> aggregate) {
            this.myCache.putAll(aggregate);
        }

        @Override
        public void reset() {
            this.myCache.clear();
        }
    }

    public static final class KeyCounter<T, G>
    implements TwoStepMapper<T, FrequencyMap<G>> {
        private final FrequencyMap<G> myCounter = new FrequencyMap();
        private final Function<T, G> myExtractor;
        private final FrequencyMap.FrequencyPredicate<G> myPredicate;

        public KeyCounter(Function<T, G> extractor) {
            this(extractor, (element, statistics, frequency) -> true);
        }

        public KeyCounter(Function<T, G> extractor, FrequencyMap.FrequencyPredicate<G> predicate) {
            this.myExtractor = extractor;
            this.myPredicate = predicate;
        }

        @Override
        public void consume(T item) {
            this.myCounter.increment(this.myExtractor.apply(item));
        }

        @Override
        public FrequencyMap<G> getResults() {
            return this.myCounter;
        }

        @Override
        public void merge(FrequencyMap<G> aggregate) {
            this.myCounter.merge(aggregate, this.myPredicate);
        }

        @Override
        public void reset() {
            this.myCounter.reset();
        }
    }
}

