/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.EntryPair;

public interface KeyValue<K, V> {
    public static <K> KeyValue<K, PrimitiveNumber> of(K key, byte value) {
        return EntryPair.of(key, value);
    }

    public static <K> KeyValue<K, PrimitiveNumber> of(K key, double value) {
        return EntryPair.of(key, value);
    }

    public static <K> KeyValue<K, PrimitiveNumber> of(K key, float value) {
        return EntryPair.of(key, value);
    }

    public static <K> KeyValue<K, PrimitiveNumber> of(K key, int value) {
        return EntryPair.of(key, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, byte value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, double value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, float value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, int value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, long value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<Dual<K>, PrimitiveNumber> of(K key1, K key2, short value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K, V> EntryPair<Dual<K>, V> of(K key1, K key2, V value) {
        return EntryPair.of(key1, key2, value);
    }

    public static <K> KeyValue<K, PrimitiveNumber> of(K key, long value) {
        return EntryPair.of(key, value);
    }

    public static <K> KeyValue<K, PrimitiveNumber> of(K key, short value) {
        return EntryPair.of(key, value);
    }

    public static <K, V> KeyValue<K, V> of(K key, V value) {
        return EntryPair.of(key, value);
    }

    public K getKey();

    public V getValue();

    public static final class Dual<T>
    implements KeyValue<T, T> {
        public final T first;
        public final T second;

        Dual(T obj1, T obj2) {
            this.first = obj1;
            this.second = obj2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Dual)) {
                return false;
            }
            Dual other = (Dual)obj;
            if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
                return false;
            }
            return !(this.second == null ? other.second != null : !this.second.equals(other.second));
        }

        @Override
        public T getKey() {
            return this.first;
        }

        @Override
        public T getValue() {
            return this.second;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
            return 31 * result + (this.second == null ? 0 : this.second.hashCode());
        }
    }
}

