/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionLocalUse {
    private final byte[] rawData;

    public Grib2SectionLocalUse(RandomAccessFile raf) throws IOException {
        int length = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 2) {
            raf.skipBytes(-5);
            this.rawData = null;
        } else {
            this.rawData = new byte[length - 5];
            raf.readFully(this.rawData);
        }
    }

    Grib2SectionLocalUse(byte[] rawData) {
        this.rawData = rawData;
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }
}

