/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.util.Arrays;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math4.legacy.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.EigenDecomposition;
import org.apache.commons.math4.legacy.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.SingularMatrixException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;

    public MultivariateNormalDistribution(double[] means, double[][] covariances) throws SingularMatrixException, DimensionMismatchException, NonPositiveDefiniteMatrixException {
        super(means.length);
        int dim = means.length;
        if (covariances.length != dim) {
            throw new DimensionMismatchException(covariances.length, dim);
        }
        for (int i = 0; i < dim; ++i) {
            if (dim == covariances[i].length) continue;
            throw new DimensionMismatchException(covariances[i].length, dim);
        }
        this.means = Arrays.copyOf(means, means.length);
        this.covarianceMatrix = new Array2DRowRealMatrix(covariances);
        EigenDecomposition covMatDec = new EigenDecomposition(this.covarianceMatrix);
        this.covarianceMatrixInverse = covMatDec.getSolver().getInverse();
        this.covarianceMatrixDeterminant = covMatDec.getDeterminant();
        double[] covMatEigenvalues = covMatDec.getRealEigenvalues();
        for (int i = 0; i < covMatEigenvalues.length; ++i) {
            if (!(covMatEigenvalues[i] < 0.0)) continue;
            throw new NonPositiveDefiniteMatrixException(covMatEigenvalues[i], i, 0.0);
        }
        Array2DRowRealMatrix covMatEigenvectors = new Array2DRowRealMatrix(dim, dim);
        for (int v = 0; v < dim; ++v) {
            double[] evec = covMatDec.getEigenvector(v).toArray();
            covMatEigenvectors.setColumn(v, evec);
        }
        RealMatrix tmpMatrix = covMatEigenvectors.transpose();
        for (int row = 0; row < dim; ++row) {
            double factor = JdkMath.sqrt((double)covMatEigenvalues[row]);
            for (int col = 0; col < dim; ++col) {
                tmpMatrix.multiplyEntry(row, col, factor);
            }
        }
        this.samplingMatrix = covMatEigenvectors.multiply(tmpMatrix);
    }

    public double[] getMeans() {
        return Arrays.copyOf(this.means, this.means.length);
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    @Override
    public double density(double[] vals) throws DimensionMismatchException {
        int dim = this.getDimension();
        if (vals.length != dim) {
            throw new DimensionMismatchException(vals.length, dim);
        }
        return JdkMath.pow((double)(2.0 * JdkMath.PI), (double)(-0.5 * (double)dim)) * JdkMath.pow((double)this.covarianceMatrixDeterminant, (double)-0.5) * this.getExponentTerm(vals);
    }

    public double[] getStandardDeviations() {
        int dim = this.getDimension();
        double[] std = new double[dim];
        double[][] s = this.covarianceMatrix.getData();
        for (int i = 0; i < dim; ++i) {
            std[i] = JdkMath.sqrt((double)s[i][i]);
        }
        return std;
    }

    @Override
    public MultivariateRealDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new MultivariateRealDistribution.Sampler(){
            private final ContinuousDistribution.Sampler gauss;
            {
                this.gauss = NormalDistribution.of((double)0.0, (double)1.0).createSampler(rng);
            }

            @Override
            public double[] sample() {
                int dim = MultivariateNormalDistribution.this.getDimension();
                double[] normalVals = new double[dim];
                for (int i = 0; i < dim; ++i) {
                    normalVals[i] = this.gauss.sample();
                }
                double[] vals = MultivariateNormalDistribution.this.samplingMatrix.operate(normalVals);
                for (int i = 0; i < dim; ++i) {
                    int n = i;
                    vals[n] = vals[n] + MultivariateNormalDistribution.this.means[i];
                }
                return vals;
            }
        };
    }

    private double getExponentTerm(double[] values) {
        double[] centered = new double[values.length];
        for (int i = 0; i < centered.length; ++i) {
            centered[i] = values[i] - this.means[i];
        }
        double[] preMultiplied = this.covarianceMatrixInverse.preMultiply(centered);
        double sum = 0.0;
        for (int i = 0; i < preMultiplied.length; ++i) {
            sum += preMultiplied[i] * centered[i];
        }
        return JdkMath.exp((double)(-0.5 * sum));
    }
}

