/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.genetics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.genetics.AbstractListChromosome;
import org.apache.commons.math4.legacy.genetics.Chromosome;
import org.apache.commons.math4.legacy.genetics.ChromosomePair;
import org.apache.commons.math4.legacy.genetics.CrossoverPolicy;
import org.apache.commons.math4.legacy.genetics.GeneticAlgorithm;
import org.apache.commons.rng.UniformRandomProvider;

public class OrderedCrossover<T>
implements CrossoverPolicy {
    @Override
    public ChromosomePair crossover(Chromosome first, Chromosome second) throws DimensionMismatchException, MathIllegalArgumentException {
        if (!(first instanceof AbstractListChromosome) || !(second instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)first, (AbstractListChromosome)second);
    }

    protected ChromosomePair mate(AbstractListChromosome<T> first, AbstractListChromosome<T> second) throws DimensionMismatchException {
        int b;
        int length = first.getLength();
        if (length != second.getLength()) {
            throw new DimensionMismatchException(second.getLength(), length);
        }
        List<T> parent1Rep = first.getRepresentation();
        List<T> parent2Rep = second.getRepresentation();
        ArrayList<T> child1 = new ArrayList<T>(length);
        ArrayList<T> child2 = new ArrayList<T>(length);
        HashSet<T> child1Set = new HashSet<T>(length);
        HashSet<T> child2Set = new HashSet<T>(length);
        UniformRandomProvider random = GeneticAlgorithm.getRandomGenerator();
        int a = random.nextInt(length);
        while (a == (b = random.nextInt(length))) {
        }
        int lb = JdkMath.min((int)a, (int)b);
        int ub = JdkMath.max((int)a, (int)b);
        child1.addAll(parent1Rep.subList(lb, ub + 1));
        child1Set.addAll(child1);
        child2.addAll(parent2Rep.subList(lb, ub + 1));
        child2Set.addAll(child2);
        for (int i = 1; i <= length; ++i) {
            int idx = (ub + i) % length;
            T item1 = parent1Rep.get(idx);
            T item2 = parent2Rep.get(idx);
            if (!child1Set.contains(item2)) {
                child1.add(item2);
                child1Set.add(item2);
            }
            if (child2Set.contains(item1)) continue;
            child2.add(item1);
            child2Set.add(item1);
        }
        Collections.rotate(child1, lb);
        Collections.rotate(child2, lb);
        return new ChromosomePair(first.newFixedLengthChromosome(child1), second.newFixedLengthChromosome(child2));
    }
}

