/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.linear;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.math4.legacy.core.IntegerSequence;
import org.apache.commons.math4.legacy.linear.IterationEvent;
import org.apache.commons.math4.legacy.linear.IterationListener;

public class IterationManager {
    private final Collection<IterationListener> listeners;
    private final int maxIterations;
    private final IntegerSequence.Incrementor.MaxCountExceededCallback callback;
    private IntegerSequence.Incrementor iterations;

    public IterationManager(int maxIterations) {
        this(maxIterations, null);
    }

    public IterationManager(int maxIterations, IntegerSequence.Incrementor.MaxCountExceededCallback callback) {
        this.maxIterations = maxIterations;
        this.callback = callback;
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
        this.resetCounter();
    }

    public void addIterationListener(IterationListener listener) {
        this.listeners.add(listener);
    }

    public void fireInitializationEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.initializationPerformed(e);
        }
    }

    public void fireIterationPerformedEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.iterationPerformed(e);
        }
    }

    public void fireIterationStartedEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.iterationStarted(e);
        }
    }

    public void fireTerminationEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.terminationPerformed(e);
        }
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public void incrementIterationCount() {
        this.iterations.increment();
    }

    public void removeIterationListener(IterationListener listener) {
        this.listeners.remove(listener);
    }

    public void resetIterationCount() {
        this.resetCounter();
    }

    private void resetCounter() {
        this.iterations = IntegerSequence.Incrementor.create().withMaximalCount(this.maxIterations);
        if (this.callback != null) {
            this.iterations = this.iterations.withCallback(this.callback);
        }
    }
}

