/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.commons.math4.legacy.ode.ContinuousOutputModel;
import org.apache.commons.math4.legacy.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince54Integrator;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math4.legacy.ode.sampling.StepHandler;
import org.apache.commons.math4.legacy.ode.sampling.StepInterpolator;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.IndexIterator;

public class IntegrateUtil {
    public static Array odeIntegrate(FirstOrderDifferentialEquations equations, Array y0, Array t) throws IOException, ClassNotFoundException {
        y0 = y0.copyIfView();
        t = t.copyIfView();
        int nt = (int)t.getSize();
        int ny0 = (int)y0.getSize();
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(1.0E-8, 100.0, 1.0E-10, 1.0E-10);
        double[] y0v = (double[])y0.getStorage();
        double[] yDot = new double[ny0];
        integrator.addStepHandler((StepHandler)new ContinuousOutputModel());
        integrator.integrate(equations, t.getDouble(0), y0v, t.getDouble(nt - 1), yDot);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        for (StepHandler handler : integrator.getStepHandlers()) {
            oos.writeObject(handler);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ContinuousOutputModel cm = (ContinuousOutputModel)ois.readObject();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nt, ny0});
        IndexIterator iter = r.getIndexIterator();
        for (int i = 0; i < nt; ++i) {
            double[] interpolatedY;
            cm.setInterpolatedTime(t.getDouble(i));
            for (double v : interpolatedY = cm.getInterpolatedState()) {
                iter.setDoubleNext(v);
            }
        }
        return r;
    }

    public static Array[] ode45(FirstOrderDifferentialEquations equations, Array y0, double t0, double t, Array tEval, Double minStep, Double maxStep, Double rtol, Double atol) throws IOException, ClassNotFoundException {
        y0 = y0.copyIfView();
        int ny0 = (int)y0.getSize();
        minStep = minStep == null ? 1.0E-6 : minStep;
        maxStep = maxStep == null ? 100.0 : maxStep;
        rtol = rtol == null ? 1.0E-6 : rtol;
        atol = atol == null ? 1.0E-6 : atol;
        DormandPrince54Integrator integrator = new DormandPrince54Integrator(minStep.doubleValue(), maxStep.doubleValue(), atol.doubleValue(), rtol.doubleValue());
        double[] y0v = (double[])y0.getStorage();
        double[] yDot = new double[ny0];
        final ArrayList<Double> tlist = new ArrayList<Double>();
        final ArrayList<double[]> ylist = new ArrayList<double[]>();
        if (tEval == null) {
            integrator.addStepHandler(new StepHandler(){

                public void init(double t0, double[] y0, double t) {
                    tlist.add(t0);
                    ylist.add(y0);
                }

                public void handleStep(StepInterpolator interpolator, boolean isLast) {
                    double t = interpolator.getCurrentTime();
                    tlist.add(t);
                    double[] y = interpolator.getInterpolatedState();
                    ylist.add((double[])y.clone());
                }
            });
            integrator.integrate(equations, t0, y0v, t, yDot);
        } else {
            ContinuousOutputModel solution = new ContinuousOutputModel();
            integrator.addStepHandler((StepHandler)solution);
            integrator.integrate(equations, t0, y0v, t, yDot);
            int i = 0;
            while ((long)i < tEval.getSize()) {
                tlist.add(tEval.getDouble(i));
                solution.setInterpolatedTime(tEval.getDouble(i));
                ylist.add(solution.getInterpolatedState());
                ++i;
            }
        }
        int nt = tlist.size();
        Array rt = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nt});
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny0, nt});
        Index2D index = (Index2D)r.getIndex();
        for (int i = 0; i < nt; ++i) {
            rt.setDouble(i, ((Double)tlist.get(i)).doubleValue());
            double[] interpolatedY = (double[])ylist.get(i);
            index.set1(i);
            for (int j = 0; j < ny0; ++j) {
                index.set0(j);
                r.setDouble((Index)index, interpolatedY[j]);
            }
        }
        return new Array[]{rt, r};
    }
}

