/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.MathEx;
import org.meteoinfo.math.interpolate.Interpolation2D;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public class KrigingInterpolation2DJ
implements Interpolation2D {
    private final double[] x1;
    private final double[] x2;
    private final double[] yvi;
    private final double alpha;
    private final double beta;

    public KrigingInterpolation2DJ(double[] x1, double[] x2, double[] y) {
        this(x1, x2, y, 1.5);
    }

    public KrigingInterpolation2DJ(double[] x1, double[] x2, double[] y, double beta) {
        if (beta < 1.0 || beta >= 2.0) {
            throw new IllegalArgumentException("Invalid beta: " + beta);
        }
        if (x1.length != x2.length) {
            throw new IllegalArgumentException("x1.length != x2.length");
        }
        if (x1.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        this.x1 = x1;
        this.x2 = x2;
        this.beta = beta;
        this.alpha = this.pow(x1, x2, y);
        int n = x1.length;
        double[] yv = new double[n + 1];
        double[][] value = new double[n + 1][n + 1];
        for (int i = 0; i < n; ++i) {
            yv[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var;
                double d1 = x1[i] - x1[j];
                double d2 = x2[i] - x2[j];
                double d = d1 * d1 + d2 * d2;
                value[i][j] = var = this.variogram(d);
                value[j][i] = var;
            }
            value[n][i] = 1.0;
            value[i][n] = 1.0;
        }
        yv[n] = 0.0;
        value[n][n] = 0.0;
        Primitive64Matrix v = (Primitive64Matrix)Primitive64Matrix.FACTORY.rows(value);
        SingularValue tmpSVD = SingularValue.PRIMITIVE.make((Structure2D)v);
        tmpSVD.decompose((Access2D.Collectable)v);
        MatrixStore solution = tmpSVD.getSolution((Access2D.Collectable)Primitive64Store.FACTORY.column(yv));
        this.yvi = solution.toRawCopy1D();
    }

    @Override
    public double interpolate(double x1, double x2) {
        int n = this.x1.length;
        double y = this.yvi[n];
        for (int i = 0; i < n; ++i) {
            double d1 = x1 - this.x1[i];
            double d2 = x2 - this.x2[i];
            double d = d1 * d1 + d2 * d2;
            y += this.yvi[i] * this.variogram(d);
        }
        return y;
    }

    private double pow(double[] x1, double[] x2, double[] y) {
        int n = x1.length;
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d1 = x1[i] - x1[j];
                double d2 = x2[i] - x2[j];
                double d = d1 * d1 + d2 * d2;
                double rb = Math.pow(d, this.beta / 2.0);
                num += rb * 0.5 * MathEx.pow2(y[i] - y[j]);
                denom += rb * rb;
            }
        }
        return num / denom;
    }

    private double variogram(double r) {
        return this.alpha * Math.pow(r, this.beta / 2.0);
    }

    public String toString() {
        return "Kriging Interpolation";
    }
}

