/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.matrix;

import java.io.Serializable;

public abstract class IMatrix<T>
implements Cloneable,
Serializable {
    private String[] rowNames;
    private String[] colNames;

    public abstract int nrows();

    public abstract int ncols();

    public abstract long size();

    public String[] rowNames() {
        return this.rowNames;
    }

    public void rowNames(String[] names) {
        if (names != null && names.length != this.nrows()) {
            throw new IllegalArgumentException(String.format("Invalid row names length: %d != %d", names.length, this.nrows()));
        }
        this.rowNames = names;
    }

    public String rowName(int i) {
        return this.rowNames[i];
    }

    public String[] colNames() {
        return this.colNames;
    }

    public void colNames(String[] names) {
        if (names != null && names.length != this.ncols()) {
            throw new IllegalArgumentException(String.format("Invalid column names length: %d != %d", names.length, this.ncols()));
        }
        this.colNames = names;
    }

    public String colName(int i) {
        return this.colNames[i];
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrows(), this.ncols()) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        String newline;
        StringBuilder sb = new StringBuilder(this.nrows() + " x " + this.ncols() + "\n");
        m = Math.min(m, this.nrows());
        String string = newline = (n = Math.min(n, this.ncols())) < this.ncols() ? "  ...\n" : "\n";
        if (this.colNames != null) {
            sb.append(this.rowNames == null ? "   " : "            ");
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(" %12.12s", this.colNames[j]));
            }
            sb.append(newline);
        }
        for (int i = 0; i < m; ++i) {
            sb.append(this.rowNames == null ? "   " : String.format("%-12.12s", this.rowNames[i]));
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(" %12.12s", this.str(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }

    abstract String str(int var1, int var2);

    public abstract T mv(T var1);

    public abstract void mv(T var1, T var2);

    public abstract void mv(T var1, int var2, int var3);

    public abstract T tv(T var1);

    public abstract void tv(T var1, T var2);

    public abstract void tv(T var1, int var2, int var3);
}

