/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.matrix;

import org.apache.commons.math4.core.jdkmath.AccurateMath;
import org.meteoinfo.math.blas.UPLO;
import org.meteoinfo.math.matrix.DMatrix;
import org.meteoinfo.math.matrix.Matrix;
import org.meteoinfo.math.matrix.SymmMatrix;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class MatrixUtil {
    private static final long EXPONENT_OFFSET = 1023L;
    public static final double EPSILON = Double.longBitsToDouble(4368491638549381120L);

    public static Array matrixToArray(DMatrix a) {
        int nRows = a.nrows();
        int nCols = a.ncols();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nRows, nCols});
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                r.setDouble(i * nCols + j, a.get(i, j));
            }
        }
        return r;
    }

    public static Array matrixToArray(DMatrix a, UPLO uplo) {
        int nRows = a.nrows();
        int nCols = a.ncols();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nRows, nCols});
        if (uplo == UPLO.LOWER) {
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    if (j > i) continue;
                    r.setDouble(i * nCols + j, a.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    if (i > j) continue;
                    r.setDouble(i * nCols + j, a.get(i, j));
                }
            }
        }
        return r;
    }

    public static Array matrixToArray(DMatrix a, UPLO uplo, double diagonalValue) {
        int nRows = a.nrows();
        int nCols = a.ncols();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nRows, nCols});
        if (uplo == UPLO.LOWER) {
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    if (j < i) {
                        r.setDouble(i * nCols + j, a.get(i, j));
                        continue;
                    }
                    if (j != i) continue;
                    r.setDouble(i * nCols + j, diagonalValue);
                }
            }
        } else {
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    if (i < j) {
                        r.setDouble(i * nCols + j, a.get(i, j));
                        continue;
                    }
                    if (i != j) continue;
                    r.setDouble(i * nCols + j, diagonalValue);
                }
            }
        }
        return r;
    }

    public static Array toArray(double[] real, double[] image) {
        Array a = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{real.length});
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setComplex(i, new Complex(real[i], image[i]));
            ++i;
        }
        return a;
    }

    public static Matrix arrayToMatrix(Array a) {
        Matrix ma = a.getRank() == 2 ? new Matrix((double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a)) : new Matrix((double[])ArrayUtil.copyToNDJavaArray_Double((Array)a));
        return ma;
    }

    public static SymmMatrix arrayToSymmMatrix(Array a) {
        SymmMatrix ma = new SymmMatrix(UPLO.LOWER, (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a));
        return ma;
    }

    public static boolean isSymmetric(Matrix matrix) {
        int rows = matrix.m;
        if (rows != matrix.n) {
            return false;
        }
        double relativeTolerance = (double)(10 * matrix.m * matrix.n) * EPSILON;
        for (int i = 0; i < rows; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                double mji;
                double mij = matrix.get(i, j);
                if (!(AccurateMath.abs((double)(mij - (mji = matrix.get(j, i)))) > AccurateMath.max((double)AccurateMath.abs((double)mij), (double)AccurateMath.abs((double)mji)) * relativeTolerance)) continue;
                return false;
            }
        }
        return true;
    }
}

