/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import org.locationtech.proj4j.BasicCoordinateTransform;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.ProjCoordinate;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.Transform;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;

public class GeoTransform
extends Transform {
    protected CoordinateTransform coordinateTransform;
    protected ProjectionInfo sourceProj;
    protected ProjectionInfo targetProj;

    public GeoTransform(ProjectionInfo source, ProjectionInfo target) {
        this.sourceProj = source;
        this.targetProj = target;
        this.coordinateTransform = new BasicCoordinateTransform(source.getCoordinateReferenceSystem(), target.getCoordinateReferenceSystem());
    }

    public ProjectionInfo getSourceProj() {
        return this.sourceProj;
    }

    public ProjectionInfo getTargetProj() {
        return this.targetProj;
    }

    public boolean isValid() {
        return !this.sourceProj.equals(this.targetProj);
    }

    public PointD transform(double x, double y) {
        ProjCoordinate s = new ProjCoordinate(x, y);
        ProjCoordinate t = new ProjCoordinate();
        this.coordinateTransform.transform(s, t);
        return new PointD(t.x, t.y);
    }

    public Graphic transform(Graphic graphic) {
        return ProjectionUtil.projectClipGraphic(graphic, this.sourceProj, this.targetProj);
    }

    public Transform inverted() {
        return new GeoTransform(this.targetProj, this.sourceProj);
    }
}

