/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.GLChartPanel;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.geo.MapPlot;
import org.meteoinfo.chart.jogl.GLPlot;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.common.PointF;

public class GLChart
implements GLEventListener {
    protected List<Plot> plots;
    private int currentPlot = -1;
    private int rowNum = 1;
    private int columnNum = 1;
    private ChartText title;
    private ChartText subTitle;
    private ChartText xLabel;
    private ChartText yLabel;
    private List<ChartText> texts;
    private ChartLegend legend;
    private Color background;
    private boolean drawLegend = false;
    private Rectangle2D plotArea;
    protected boolean sampleBuffers = true;
    private boolean antialias = false;
    private boolean symbolAntialias = true;
    private GLChartPanel parent;
    protected boolean doScreenShot = false;
    protected BufferedImage screenImage;
    protected GLAutoDrawable drawable;
    protected GL2 gl;
    protected GLU glu;
    protected final GLUT glut = new GLUT();
    protected GLPlot.TessCallback tessCallback;
    protected int width;
    protected int height;

    public GLChart() {
        this.background = Color.white;
        this.plots = new ArrayList<Plot>();
        this.texts = new ArrayList<ChartText>();
    }

    public GLChart(GLChartPanel parent) {
        this();
        this.parent = parent;
    }

    public GLChart(Plot plot, GLChartPanel parent) {
        this(parent);
        this.plots.add(plot);
    }

    public GLChart(Plot plot) {
        this(plot, null);
    }

    public GLChart(String title, Plot plot, GLChartPanel parent) {
        this(plot, parent);
        this.title = title == null ? null : new ChartText(title);
    }

    public GLChart(String title, Plot plot) {
        this(title, plot, null);
    }

    public void setParent(GLChartPanel value) {
        this.parent = value;
        for (Plot plot : this.plots) {
            if (!(plot instanceof MapPlot)) continue;
            ((MapPlot)plot).setParent(value);
        }
    }

    public List<Plot> getPlots() {
        return this.plots;
    }

    public Plot getCurrentPlot() {
        if (this.plots.isEmpty()) {
            return null;
        }
        if (this.currentPlot < 0 || this.currentPlot >= this.plots.size()) {
            this.currentPlot = this.plots.size() - 1;
        }
        return this.plots.get(this.currentPlot);
    }

    public void setCurrentPlot(Plot value) {
        if (this.plots.isEmpty()) {
            this.addPlot(value);
        } else if (this.currentPlot == -1) {
            this.plots.add(value);
        } else {
            if (this.currentPlot >= this.plots.size()) {
                this.currentPlot = this.plots.size() - 1;
            }
            Plot plot = this.plots.get(this.currentPlot);
            value.isSubPlot = plot.isSubPlot;
            value.columnIndex = plot.columnIndex;
            value.rowIndex = plot.rowIndex;
            this.plots.set(this.currentPlot, value);
        }
    }

    public void setCurrentPlot(int value) {
        this.currentPlot = value;
    }

    public Plot getPlot() {
        if (this.plots.isEmpty()) {
            return null;
        }
        return this.plots.get(0);
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int value) {
        this.rowNum = value;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public void setColumnNum(int value) {
        this.columnNum = value;
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public ChartText getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(ChartText value) {
        this.subTitle = value;
    }

    public ChartText getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(ChartText value) {
        this.xLabel = value;
    }

    public ChartText getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(ChartText value) {
        this.yLabel = value;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    public ChartLegend getLegend() {
        return this.legend;
    }

    public boolean isDrawLegend() {
        return this.drawLegend;
    }

    public void setDrawLegend(boolean value) {
        this.drawLegend = value;
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    public boolean isSymbolAntialias() {
        return this.symbolAntialias;
    }

    public void setSymbolAntialias(boolean value) {
        this.symbolAntialias = value;
    }

    public boolean isSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setSampleBuffers(boolean value) {
        this.sampleBuffers = value;
    }

    public boolean isDoScreenShot() {
        return this.doScreenShot;
    }

    public void setDoScreenShot(boolean value) {
        this.doScreenShot = value;
    }

    public BufferedImage getScreenImage() {
        return this.screenImage;
    }

    public void setDpiScale(float value) {
        List<GLPlot> glPlots = this.getGLPlots();
        for (GLPlot glPlot : glPlots) {
            glPlot.setDpiScale(value);
        }
    }

    public void setAlwaysUpdateBuffers(boolean value) {
        List<GLPlot> glPlots = this.getGLPlots();
        for (GLPlot glPlot : glPlots) {
            glPlot.setAlwaysUpdateBuffers(value);
        }
    }

    public boolean containsGLPlot() {
        for (Plot plot : this.plots) {
            if (!(plot instanceof GLPlot)) continue;
            return true;
        }
        return false;
    }

    public void draw(Graphics2D g, Rectangle2D area) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        AffineTransform oldMatrix = g.getTransform();
        Rectangle oldRegion = g.getClipBounds();
        g.setClip(area);
        g.translate(area.getX(), area.getY());
        if (this.background != null && !this.containsGLPlot()) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Double(0.0, 0.0, area.getWidth(), area.getHeight()));
        }
        this.plotArea = this.getPlotArea(g, area);
        float y = 5.0f;
        if (this.title != null) {
            float x = (float)area.getWidth() / 2.0f;
            this.title.draw(g, x, y += (float)this.title.getDimension((Graphics2D)g).height);
            y += 5.0f;
        }
        if (this.xLabel != null) {
            this.xLabel.draw(g, (int)(this.plotArea.getX() + this.plotArea.getWidth() / 2.0), (int)(this.plotArea.getMaxY() + 5.0));
        }
        if (this.yLabel != null) {
            this.yLabel.draw(g, (int)(this.plotArea.getX() - 5.0), (int)(this.plotArea.getY() + this.plotArea.getHeight() / 2.0));
        }
        if (this.plotArea.getWidth() < 20.0 || this.plotArea.getHeight() < 20.0) {
            g.setTransform(oldMatrix);
            g.setClip(oldRegion);
            return;
        }
        if (this.plots.size() > 0) {
            Margin shrink = this.getPlotsShrink(g, this.plotArea);
            for (Plot plot : this.plots) {
                plot.setAntiAlias(this.antialias);
                plot.setSymbolAntiAlias(this.symbolAntialias);
                if (plot.isOuterPosActive()) {
                    if (plot.isSubPlot || plot.isSameShrink()) {
                        plot.setPlotShrink(shrink);
                    } else {
                        plot.setPlotShrink(this.getPlotShrink(g, this.plotArea, plot));
                    }
                }
                if (plot instanceof AbstractPlot2D) {
                    ((AbstractPlot2D)plot).setAntiAlias(this.antialias);
                }
                if (plot instanceof GLPlot) {
                    Rectangle2D graphArea = plot.getPositionArea();
                    plot.setGraphArea(graphArea);
                    continue;
                }
                plot.draw(g, area);
            }
        }
        this.drawText(g, area);
        if (this.drawLegend) {
            Dimension dim = this.legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
            float x = 0.0f;
            switch (this.legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    x = (float)area.getWidth() / 2.0f - (float)(dim.width / 2);
                    y += 5.0f;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    x = (float)area.getWidth() / 2.0f - (float)(dim.width / 2);
                    y = (float)((double)y + (this.plotArea.getHeight() + 5.0));
                    break;
                }
                case LEFT_OUTSIDE: {
                    x = 10.0f;
                    y = (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                    break;
                }
                case RIGHT_OUTSIDE: {
                    x = (float)this.plotArea.getWidth() + 10.0f;
                    y = (float)area.getHeight() / 2.0f - (float)(dim.height / 2);
                }
            }
            this.legend.draw(g, new PointF(x, y));
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    void drawText(Graphics2D g, Rectangle2D area) {
        for (ChartText text : this.texts) {
            float x = (float)(area.getWidth() * text.getX());
            float y = (float)(area.getHeight() * (1.0 - text.getY()));
            text.draw(g, x, y);
        }
    }

    private Rectangle2D getPlotArea(Graphics2D g, Rectangle2D area) {
        int edge;
        Rectangle2D.Double pArea = new Rectangle2D.Double();
        int top = edge = 0;
        int left = edge;
        int right = edge;
        int bottom = edge;
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 12;
        }
        if (this.xLabel != null) {
            bottom += this.xLabel.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (this.yLabel != null) {
            left += this.yLabel.getTrueDimension((Graphics2D)g).width + 10;
        }
        ((Rectangle2D)pArea).setRect(left, top, area.getWidth() - (double)left - (double)right, area.getHeight() - (double)top - (double)bottom);
        return pArea;
    }

    private Rectangle2D getPlotArea_bak(Graphics2D g, Rectangle2D area) {
        int edge;
        Rectangle2D.Double pArea = new Rectangle2D.Double();
        int top = edge = 2;
        int left = edge;
        int right = edge;
        int bottom = edge;
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (this.drawLegend) {
            Dimension dim = this.legend.getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
            switch (this.legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        ((Rectangle2D)pArea).setRect(left, top, area.getWidth() - (double)left - (double)right, area.getHeight() - (double)top - (double)bottom);
        return pArea;
    }

    private Margin getPlotShrink(Graphics2D g, Rectangle2D area, Plot plot) {
        Margin shrink;
        if (plot.isSubPlot) {
            double rowHeight = area.getHeight() / (double)this.rowNum;
            double colWidth = area.getWidth() / (double)this.columnNum;
            double x = area.getX() + (double)plot.columnIndex * colWidth;
            double y = area.getY() + (double)plot.rowIndex * rowHeight;
            Rectangle2D.Double subPlotArea = new Rectangle2D.Double(x, y, colWidth, rowHeight);
            plot.setOuterPositionArea(subPlotArea);
            plot.updatePosition(area, subPlotArea);
            Rectangle2D positionArea = plot.getPositionArea(area);
            plot.setPositionArea(positionArea);
            Margin tightInset = plot.getTightInset(g, positionArea);
            plot.setTightInset(tightInset);
            shrink = plot.getPlotShrink();
        } else {
            plot.setOuterPositionArea(area);
            Rectangle2D positionArea = plot.getPositionArea(area);
            plot.setPositionArea(positionArea);
            Margin tightInset = plot.getTightInset(g, positionArea);
            plot.setTightInset(tightInset);
            shrink = plot.getPlotShrink();
        }
        return shrink;
    }

    private Margin getPlotsShrink(Graphics2D g, Rectangle2D area) {
        Margin pshrink = null;
        for (Plot plot : this.plots) {
            plot.setOuterPositionArea(plot.getOuterPositionArea(area));
            Rectangle2D positionArea = plot.getPositionArea(area);
            plot.setPositionArea(positionArea);
            Margin tightInset = plot.getTightInset(g, positionArea);
            plot.setTightInset(tightInset);
            Margin shrink = plot.getPlotShrink();
            if (pshrink == null) {
                pshrink = shrink;
                continue;
            }
            pshrink = pshrink.extend(shrink);
        }
        return pshrink;
    }

    private Margin getPlotsShrink_bak(Graphics2D g, Rectangle2D area) {
        Margin pshrink = null;
        for (int i = 0; i < this.plots.size(); ++i) {
            Margin shrink;
            Plot plot = this.plots.get(i);
            if (plot.isSubPlot) {
                double rowHeight = area.getHeight() / (double)this.rowNum;
                double colWidth = area.getWidth() / (double)this.columnNum;
                double x = area.getX() + (double)plot.columnIndex * colWidth;
                double y = area.getY() + (double)plot.rowIndex * rowHeight;
                Rectangle2D.Double subPlotArea = new Rectangle2D.Double(x, y, colWidth, rowHeight);
                plot.setOuterPositionArea(subPlotArea);
                plot.updatePosition(area, subPlotArea);
                Rectangle2D positionArea = plot.getPositionArea(area);
                plot.setPositionArea(positionArea);
                Margin tightInset = plot.getTightInset(g, positionArea);
                plot.setTightInset(tightInset);
                shrink = plot.getPlotShrink();
            } else {
                plot.setOuterPositionArea(area);
                Rectangle2D positionArea = plot.getPositionArea(area);
                plot.setPositionArea(positionArea);
                Margin tightInset = plot.getTightInset(g, positionArea);
                plot.setTightInset(tightInset);
                shrink = plot.getPlotShrink();
            }
            if (i == 0) {
                pshrink = shrink;
                continue;
            }
            if (pshrink == null) continue;
            pshrink = pshrink.extend(shrink);
        }
        return pshrink;
    }

    private Margin getPlotsTightInset(Graphics2D g, Rectangle2D area) {
        int i = 0;
        Margin pti = null;
        for (Plot plot : this.plots) {
            Margin tightInset;
            if (plot.isSubPlot) {
                double rowHeight = area.getHeight() / (double)this.rowNum;
                double colWidth = area.getWidth() / (double)this.columnNum;
                double x = area.getX() + (double)plot.columnIndex * colWidth;
                double y = area.getY() + (double)plot.rowIndex * rowHeight;
                Rectangle2D.Double subPlotArea = new Rectangle2D.Double(x, y, colWidth, rowHeight);
                plot.setOuterPositionArea(subPlotArea);
                plot.updatePosition(area, subPlotArea);
                Rectangle2D positionArea = plot.getPositionArea();
                plot.setPositionArea(positionArea);
                tightInset = plot.getTightInset(g, positionArea);
            } else {
                plot.setOuterPositionArea(area);
                Rectangle2D positionArea = plot.getPositionArea();
                plot.setPositionArea(positionArea);
                tightInset = plot.getTightInset(g, positionArea);
            }
            if (i == 0) {
                pti = tightInset;
            } else if (pti != null) {
                pti = pti.extend(tightInset);
            }
            ++i;
        }
        return pti;
    }

    private double getPositionAreaZoom(Graphics2D g, Rectangle2D area) {
        double zoom = 1.0;
        for (Plot plot : this.plots) {
            if (plot.isSubPlot) {
                double rowHeight = area.getHeight() / (double)this.rowNum;
                double colWidth = area.getWidth() / (double)this.columnNum;
                double x = area.getX() + (double)plot.columnIndex * colWidth;
                double y = area.getY() + (double)plot.rowIndex * rowHeight;
                Rectangle2D.Double subPlotArea = new Rectangle2D.Double(x, y, colWidth, rowHeight);
                plot.setOuterPositionArea(subPlotArea);
                plot.updatePosition(area, subPlotArea);
                Rectangle2D positionArea = plot.getPositionArea();
                plot.setPositionArea(positionArea);
                Margin tightInset = plot.getTightInset(g, positionArea);
                plot.setTightInset(tightInset);
                double zoom1 = plot.getPositionAreaZoom();
                if (!(zoom1 < zoom)) continue;
                zoom = zoom1;
                continue;
            }
            plot.setOuterPositionArea(area);
            Rectangle2D positionArea = plot.getPositionArea();
            plot.setPositionArea(positionArea);
            Margin tightInset = plot.getTightInset(g, positionArea);
            plot.setTightInset(tightInset);
            double zoom1 = plot.getPositionAreaZoom();
            if (!(zoom1 < zoom)) continue;
            zoom = zoom1;
        }
        return zoom;
    }

    private Rectangle2D getSubPlotArea(Graphics2D g, Plot plot, Rectangle2D area) {
        if (plot.isSubPlot) {
            double rowHeight = area.getHeight() / (double)this.rowNum;
            double colWidth = area.getWidth() / (double)this.columnNum;
            double x = area.getX() + (double)plot.columnIndex * colWidth;
            double y = area.getY() + (double)plot.rowIndex * rowHeight;
            Rectangle2D.Double subPlotArea = new Rectangle2D.Double(x, y, colWidth, rowHeight);
            plot.setOuterPositionArea(subPlotArea);
            plot.updatePosition(area, subPlotArea);
            Rectangle2D positionArea = plot.getPositionArea();
            plot.setPositionArea(positionArea);
            Margin tightInset = plot.getTightInset(g, positionArea);
            plot.setTightInset(tightInset);
            double zoom = plot.getPositionAreaZoom();
            plot.setPositionAreaZoom(zoom);
            return subPlotArea;
        }
        plot.setOuterPositionArea(area);
        Rectangle2D positionArea = plot.getPositionArea();
        plot.setPositionArea(positionArea);
        Margin tightInset = plot.getTightInset(g, positionArea);
        plot.setTightInset(tightInset);
        double zoom = plot.getPositionAreaZoom();
        plot.setPositionAreaZoom(zoom);
        return area;
    }

    public Rectangle2D getGraphArea() {
        Rectangle2D rect = this.plots.get(0).getPositionArea();
        double left = rect.getX() + this.plotArea.getX();
        double top = rect.getY() + this.plotArea.getY();
        return new Rectangle2D.Double(left, top, rect.getWidth(), rect.getHeight());
    }

    public Plot findPlot(int x, int y) {
        for (Plot plot : this.plots) {
            Rectangle2D area = plot.getPositionArea();
            if (!area.contains(x, y)) continue;
            return plot;
        }
        return null;
    }

    public void clearPlots() {
        this.plots.clear();
    }

    public void clearTexts() {
        this.texts.clear();
    }

    public void clearAll() {
        this.title = null;
        this.xLabel = null;
        this.yLabel = null;
        this.clearTexts();
        this.clearPlots();
    }

    public void removePlot(Plot plot) {
        this.plots.remove((Object)plot);
    }

    public void addPlot(Plot plot) {
        if (plot instanceof MapPlot) {
            ((MapPlot)plot).setParent(this.parent);
        }
        this.plots.add(plot);
    }

    public void setPlot(Plot plot) {
        this.clearPlots();
        this.addPlot(plot);
    }

    public Plot getPlot(int plotIdx) {
        for (Plot plot : this.plots) {
            int pIdx = plot.rowIndex * this.columnNum + plot.columnIndex + 1;
            if (pIdx != plotIdx) continue;
            return plot;
        }
        if (plotIdx > 0 && plotIdx <= this.plots.size()) {
            return this.plots.get(plotIdx - 1);
        }
        return null;
    }

    public int getPlotIndex(Plot plot) {
        return this.plots.indexOf((Object)plot);
    }

    public boolean hasWebMap() {
        for (Plot plot : this.plots) {
            MapPlot mp;
            if (!(plot instanceof MapPlot) || !(mp = (MapPlot)plot).hasWebMapLayer()) continue;
            return true;
        }
        return false;
    }

    public void addText(ChartText text) {
        this.texts.add(text);
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl;
        this.drawable = drawable;
        drawable.getGL().setSwapInterval(1);
        this.gl = gl = drawable.getGL().getGL2();
        this.glu = GLU.createGLU((GL)gl);
        gl.glEnable(2832);
        gl.glEnable(2929);
        gl.glShadeModel(7425);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        this.tessCallback = new GLPlot.TessCallback(gl, this.glu);
    }

    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        Program.destroyAllPrograms(gl);
        this.setAlwaysUpdateBuffers(true);
    }

    public void display(GLAutoDrawable drawable) {
        if (this.containsGLPlot()) {
            float[] rgba = this.background.getRGBComponents(null);
            this.gl.glClearColor(rgba[0], rgba[1], rgba[2], rgba[3]);
            this.gl.glClear(17664);
            this.gl.glShadeModel(7425);
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 771);
            if (this.antialias) {
                if (this.sampleBuffers) {
                    this.gl.glEnable(32925);
                } else {
                    this.gl.glEnable(2848);
                    this.gl.glHint(3154, 4354);
                    this.gl.glEnable(2832);
                    this.gl.glHint(3153, 4354);
                }
            } else if (this.sampleBuffers) {
                this.gl.glDisable(32925);
            } else {
                this.gl.glDisable(2848);
                this.gl.glHint(3154, 4353);
                this.gl.glDisable(2832);
                this.gl.glHint(3153, 4353);
            }
            List<GLPlot> glPlots = this.getGLPlots();
            for (GLPlot glPlot : glPlots) {
                glPlot.reshape(drawable, 0, 0, this.width, this.height);
                glPlot.display(drawable);
            }
            if (this.doScreenShot) {
                AWTGLReadBufferUtil glReadBufferUtil = new AWTGLReadBufferUtil(drawable.getGLProfile(), false);
                this.screenImage = glReadBufferUtil.readPixelsToBufferedImage(drawable.getGL(), true);
                this.doScreenShot = false;
            }
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
    }

    public List<GLPlot> getGLPlots() {
        ArrayList<GLPlot> glPlots = new ArrayList<GLPlot>();
        for (Plot plot : this.plots) {
            if (!(plot instanceof GLPlot)) continue;
            glPlots.add((GLPlot)plot);
        }
        return glPlots;
    }
}

