/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.imaging.ImageFormats;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.meteoinfo.chart.GLChart;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.IPointSelectedListener;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.PointSelectedEvent;
import org.meteoinfo.chart.geo.MapPlot;
import org.meteoinfo.chart.jogl.EarthGLPlot;
import org.meteoinfo.chart.jogl.GLPlot;
import org.meteoinfo.chart.jogl.JOGLUtil;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.Plot3D;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.chart.plot3d.Projector;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.image.ImageUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GLChartPanel
extends GLJPanel
implements IChartPanel {
    private final EventListenerList listeners = new EventListenerList();
    private BufferedImage mapBitmap = new BufferedImage(10, 10, 2);
    private BufferedImage tempImage = null;
    private boolean newPaint = false;
    private boolean doubleBuffer = true;
    private GLChart chart;
    private Plot currentPlot;
    private Dimension chartSize;
    private Point mouseDownPoint = new Point(0, 0);
    private Point mouseLastPos = new Point(0, 0);
    private boolean dragMode = false;
    private JPopupMenu popupMenu;
    private MouseMode mouseMode;
    private List<int[]> selectedPoints;
    private int xShift = 0;
    private int yShift = 0;
    private double paintScale = 1.0;
    private LocalDateTime lastMouseWheelTime;
    private Timer mouseWheelDetctionTimer;
    private boolean loading = false;
    private boolean zoomXY = false;

    public GLChartPanel() {
        this(new GLChart());
    }

    public GLChartPanel(GLChart chart) {
        super((GLCapabilitiesImmutable)GLChartPanel.createCapabilities(true, true, 4));
        this.setBackground(Color.lightGray);
        this.setSize(200, 200);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GLChartPanel.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GLChartPanel.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GLChartPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GLChartPanel.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GLChartPanel.this.onMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                GLChartPanel.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GLChartPanel.this.onMouseWheelMoved(e);
            }
        });
        this.mouseWheelDetctionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime now = LocalDateTime.now();
                if (Duration.between(GLChartPanel.this.lastMouseWheelTime, now).toMillis() > 200L) {
                    GLChartPanel.this.xShift = 0;
                    GLChartPanel.this.yShift = 0;
                    GLChartPanel.this.paintScale = 1.0;
                    GLChartPanel.this.repaintNew();
                    GLChartPanel.this.mouseWheelDetctionTimer.stop();
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem undoZoom = new JMenuItem("Undo zoom");
        undoZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLChartPanel.this.onUndoZoomClick();
            }
        });
        this.popupMenu.add(undoZoom);
        this.popupMenu.addSeparator();
        JMenuItem saveFigure = new JMenuItem("Save figure");
        saveFigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLChartPanel.this.onSaveFigureClick(e);
            }
        });
        this.popupMenu.add(saveFigure);
        this.mouseMode = MouseMode.DEFAULT;
        this.chart = chart;
        if (this.chart != null) {
            this.chart.setParent(this);
            this.addGLEventListener(chart);
        }
    }

    public GLChartPanel(GLChart chart, int width, int height) {
        this(chart);
        this.chartSize = new Dimension(width, height);
        this.setPreferredSize(this.chartSize);
    }

    public static GLCapabilities createCapabilities(boolean doubleBuffered, boolean sampleBuffers, int numSamples) {
        GLProfile profile = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(profile);
        cap.setDoubleBuffered(doubleBuffered);
        cap.setSampleBuffers(sampleBuffers);
        cap.setNumSamples(numSamples);
        return cap;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public GLChart getChart() {
        return this.chart;
    }

    public void setChart(GLChart value) {
        this.chart = value;
        if (this.chart != null) {
            this.chart.setParent(this);
        }
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean value) {
        this.doubleBuffer = value;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    @Override
    public void setMouseMode(MouseMode value) {
        this.mouseMode = value;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (this.mouseMode) {
            case SELECT: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case ZOOM_IN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case ZOOM_OUT: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case PAN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case IDENTIFIER: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case ROTATE: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/rotate.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
            }
        }
        this.setCursor(customCursor);
    }

    public List<int[]> getSelectedPoints() {
        return this.selectedPoints;
    }

    public boolean isZoomXY() {
        return this.zoomXY;
    }

    public void setZoomXY(boolean value) {
        this.zoomXY = value;
    }

    public void addPointSelectedListener(IPointSelectedListener listener) {
        this.listeners.add(IPointSelectedListener.class, listener);
    }

    public void removePointSelectedListener(IPointSelectedListener listener) {
        this.listeners.remove(IPointSelectedListener.class, listener);
    }

    public void firePointSelectedEvent() {
        this.firePointSelectedEvent(new PointSelectedEvent(this));
    }

    private void firePointSelectedEvent(PointSelectedEvent event) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IPointSelectedListener.class) continue;
            ((IPointSelectedListener)listeners[i + 1]).pointSelectedEvent(event);
        }
    }

    public int getFigureWidth() {
        int width = this.chartSize != null ? this.chartSize.width : this.getWidth();
        return width;
    }

    public int getFigureHeight() {
        int height = this.chartSize != null ? this.chartSize.height : this.getHeight();
        return height;
    }

    public Plot selPlot(int x, int y) {
        if (this.chart == null) {
            return null;
        }
        int n = this.chart.getPlots().size();
        for (int i = n - 1; i >= 0; --i) {
            Plot plot = this.chart.getPlots().get(i);
            Rectangle2D rect = plot instanceof GLPlot ? plot.getPositionArea(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight())) : plot.getGraphArea();
            if (!rect.contains(x, y)) continue;
            return plot;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.newPaint) {
            this.paintGraphics(g2);
        } else {
            AffineTransform mx = new AffineTransform();
            AffineTransformOp aop = new AffineTransformOp(mx, 3);
            g2.drawImage(this.mapBitmap, aop, 0, 0);
        }
        if (this.dragMode) {
            switch (this.mouseMode) {
                case SELECT: 
                case ZOOM_IN: {
                    int aWidth = Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x);
                    int aHeight = Math.abs(this.mouseLastPos.y - this.mouseDownPoint.y);
                    int aX = Math.min(this.mouseLastPos.x, this.mouseDownPoint.x);
                    int aY = Math.min(this.mouseLastPos.y, this.mouseDownPoint.y);
                    g2.setColor(this.getForeground());
                    float[] dash1 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(new java.awt.Rectangle(aX, aY, aWidth, aHeight));
                }
            }
        }
        g2.dispose();
    }

    public void repaintNew() {
        if (this.doubleBuffer) {
            this.paintGraphics();
        } else {
            this.newPaint = true;
            this.repaint();
            this.updateViewImage();
        }
    }

    private void repaintOld() {
        if (this.doubleBuffer) {
            this.repaint();
        } else {
            this.newPaint = false;
            this.repaint();
        }
    }

    private void updateViewImage() {
        int width;
        int height;
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.mapBitmap = new BufferedImage(width, height, 2);
        Graphics2D g = this.mapBitmap.createGraphics();
        this.print(g);
        g.dispose();
    }

    @Override
    public void paintGraphics() {
        int width;
        int height;
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.mapBitmap = new BufferedImage(width, height, 2);
        if (this.chart != null) {
            Graphics2D g = this.mapBitmap.createGraphics();
            Rectangle2D.Double chartArea = this.chartSize == null ? new Rectangle2D.Double(0.0, 0.0, this.mapBitmap.getWidth(), this.mapBitmap.getHeight()) : new Rectangle2D.Double(0.0, 0.0, this.chartSize.width, this.chartSize.height);
            this.chart.draw(g, chartArea);
        }
        this.repaint();
    }

    public void paintGraphics(Graphics2D g) {
        if (this.chart != null) {
            Rectangle2D.Double chartArea = this.chartSize == null ? new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()) : new Rectangle2D.Double(0.0, 0.0, this.chartSize.width, this.chartSize.height);
            this.chart.draw(g, chartArea);
        }
    }

    @Override
    public void paintGraphics(Graphics2D g, int width, int height) {
        if (this.chart != null) {
            Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.chart.draw(g, chartArea);
        }
    }

    void onComponentResized(ComponentEvent e) {
        if (!this.loading && this.getWidth() > 0 && this.getHeight() > 0 && this.chart != null) {
            this.chart.setAlwaysUpdateBuffers(true);
            this.repaintNew();
        }
    }

    void onMousePressed(MouseEvent e) {
        this.mouseDownPoint.x = e.getX();
        this.mouseDownPoint.y = e.getY();
        this.mouseLastPos = (Point)this.mouseDownPoint.clone();
        switch (this.mouseMode) {
            case PAN: {
                Plot plot = this.selPlot(e.getX(), e.getY());
                if (plot == null) break;
                Rectangle2D mapRect = plot.getGraphArea();
                this.tempImage = new BufferedImage((int)mapRect.getWidth() - 2, (int)mapRect.getHeight() - 2, 2);
                Graphics2D tg = this.tempImage.createGraphics();
                tg.setColor(Color.white);
                tg.fill(mapRect);
                tg.drawImage((Image)this.mapBitmap, -((int)mapRect.getX()) - 1, -((int)mapRect.getY()) - 1, (ImageObserver)((Object)this));
                tg.dispose();
            }
        }
    }

    void onMouseMoved(MouseEvent e) {
        this.dragMode = false;
    }

    void onMouseReleased(MouseEvent e) {
        Plot plot;
        this.dragMode = false;
        this.currentPlot = plot = this.selPlot(this.mouseDownPoint.x, this.mouseDownPoint.y);
        switch (this.mouseMode) {
            case ZOOM_IN: {
                Extent drawExtent;
                if (Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x) <= 5 || !(plot instanceof AbstractPlot2D)) break;
                AbstractPlot2D xyplot = (AbstractPlot2D)plot;
                if (xyplot instanceof MapPlot) {
                    MapPlot mapPlot = (MapPlot)xyplot;
                    Rectangle2D graphArea = plot.getGraphArea();
                    double[] xy1 = mapPlot.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                    double[] xy2 = mapPlot.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                    Extent extent = new Extent();
                    extent.minX = Math.min(xy1[0], xy2[0]);
                    extent.maxX = Math.max(xy1[0], xy2[0]);
                    extent.minY = Math.min(xy1[1], xy2[1]);
                    extent.maxY = Math.max(xy1[1], xy2[1]);
                    mapPlot.setDrawExtent(extent);
                    this.repaintNew();
                    break;
                }
                Rectangle2D graphArea = xyplot.getGraphArea();
                double[] xy1 = xyplot.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                double[] xy2 = xyplot.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                Extent extent = new Extent();
                extent.minX = Math.min(xy1[0], xy2[0]);
                extent.maxX = Math.max(xy1[0], xy2[0]);
                extent.minY = Math.min(xy1[1], xy2[1]);
                extent.maxY = Math.max(xy1[1], xy2[1]);
                if (xyplot.getXAxis().isInverse()) {
                    drawExtent = xyplot.getDrawExtent();
                    double minx = drawExtent.getWidth() - (extent.maxX - drawExtent.minX) + drawExtent.minX;
                    double maxx = drawExtent.getWidth() - (extent.minX - drawExtent.minX) + drawExtent.minX;
                    extent.minX = minx;
                    extent.maxX = maxx;
                }
                if (xyplot.getYAxis().isInverse()) {
                    drawExtent = xyplot.getDrawExtent();
                    double miny = drawExtent.getHeight() - (extent.maxY - drawExtent.minY) + drawExtent.minY;
                    double maxy = drawExtent.getHeight() - (extent.minY - drawExtent.minY) + drawExtent.minY;
                    extent.minY = miny;
                    extent.maxY = maxy;
                }
                xyplot.setDrawExtent(extent);
                this.repaintNew();
                break;
            }
            case ZOOM_OUT: {
                if (e.getButton() != 1 || !(plot instanceof AbstractPlot2D)) break;
                AbstractPlot2D xyplot = (AbstractPlot2D)plot;
                double zoom = 1.5;
                Extent extent = xyplot.getDrawExtent();
                double owidth = extent.getWidth();
                double oheight = extent.getHeight();
                double width = owidth * zoom;
                double height = oheight * zoom;
                double xshift = (owidth - width) * 0.5;
                double yshift = (oheight - height) * 0.5;
                extent.minX += xshift;
                extent.maxX -= xshift;
                extent.minY += yshift;
                extent.maxY -= yshift;
                xyplot.setDrawExtent(extent);
                this.repaintNew();
                break;
            }
            case SELECT: {
                XY1DPlot plt;
                Rectangle2D graphArea;
                AbstractPlot2D xyplot;
                if (Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x) <= 5 || !(plot instanceof AbstractPlot2D) || !((xyplot = (AbstractPlot2D)plot) instanceof XY1DPlot) || !(graphArea = (plt = (XY1DPlot)xyplot).getGraphArea()).contains(this.mouseDownPoint.x, this.mouseDownPoint.y) && !graphArea.contains(this.mouseLastPos.x, this.mouseLastPos.y)) break;
                double[] xy1 = plt.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                double[] xy2 = plt.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                Extent extent = new Extent();
                extent.minX = Math.min(xy1[0], xy2[0]);
                extent.maxX = Math.max(xy1[0], xy2[0]);
                extent.minY = Math.min(xy1[1], xy2[1]);
                extent.maxY = Math.max(xy1[1], xy2[1]);
                this.selectedPoints = plt.getDataset().selectPoints(extent);
                this.firePointSelectedEvent();
                this.repaintNew();
                break;
            }
            case PAN: {
                if (e.getButton() != 1 || !(plot instanceof AbstractPlot2D)) break;
                AbstractPlot2D xyplot = (AbstractPlot2D)plot;
                double[] xy1 = xyplot.screenToProj(this.mouseDownPoint.x, this.mouseDownPoint.y);
                double[] xy2 = xyplot.screenToProj(e.getX(), e.getY());
                Extent extent = xyplot.getDrawExtent();
                extent = extent.shift(xy1[0] - xy2[0], xy1[1] - xy2[1]);
                xyplot.setDrawExtent(extent);
                this.repaintNew();
            }
        }
    }

    void onMouseDragged(MouseEvent e) {
        this.dragMode = true;
        int x = e.getX();
        int y = e.getY();
        Plot plot = this.selPlot(this.mouseDownPoint.x, this.mouseDownPoint.y);
        switch (this.mouseMode) {
            case SELECT: 
            case ZOOM_IN: {
                if (plot instanceof GLPlot) {
                    this.repaint();
                    break;
                }
                this.repaintOld();
                break;
            }
            case PAN: {
                if (plot == null) break;
                if (plot instanceof GLPlot) {
                    GLPlot glPlot = (GLPlot)plot;
                    Dimension size = e.getComponent().getSize();
                    float dx = (float)(x - this.mouseLastPos.x) / (float)size.width;
                    float dy = (float)(this.mouseLastPos.y - y) / (float)size.height;
                    Extent3D extent = glPlot.getDrawExtent();
                    float rotation = glPlot.getAngleY();
                    if (rotation < 90.0f || rotation > 270.0f) {
                        dx = -dx;
                        dy = -dy;
                    }
                    extent = extent.shift(extent.getWidth() * (double)dx, extent.getHeight() * (double)dy, 0.0);
                    glPlot.setDrawExtent((Extent)extent);
                    this.repaint();
                    break;
                }
                Graphics2D g = (Graphics2D)this.getGraphics();
                Rectangle2D mapRect = plot.getGraphArea();
                g.setClip(mapRect);
                g.setColor(Color.white);
                int aX = e.getX() - this.mouseDownPoint.x;
                int aY = e.getY() - this.mouseDownPoint.y;
                if (aX > 0) {
                    if (mapRect.getX() >= 0.0) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), aX, (int)mapRect.getHeight());
                    } else {
                        g.fillRect(0, (int)mapRect.getY(), aX, (int)mapRect.getHeight());
                    }
                } else if (mapRect.getX() <= (double)this.getWidth()) {
                    g.fillRect((int)(mapRect.getX() + mapRect.getWidth() + (double)aX), (int)mapRect.getY(), Math.abs(aX), (int)mapRect.getHeight());
                } else {
                    g.fillRect(this.getWidth() + aX, (int)mapRect.getY(), Math.abs(aX), (int)mapRect.getHeight());
                }
                if (aY > 0) {
                    if (mapRect.getY() >= 0.0) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)mapRect.getWidth(), aY);
                    } else {
                        g.fillRect((int)mapRect.getX(), 0, (int)mapRect.getWidth(), aY);
                    }
                } else if (mapRect.getY() + mapRect.getHeight() <= (double)(this.getX() + this.getHeight())) {
                    g.fillRect((int)mapRect.getX(), (int)mapRect.getY() + (int)mapRect.getHeight() + aY, (int)mapRect.getWidth(), Math.abs(aY));
                } else {
                    g.fillRect((int)mapRect.getX(), this.getY() + this.getHeight() + aY, (int)mapRect.getWidth(), Math.abs(aY));
                }
                int startX = (int)mapRect.getX() + aX;
                int startY = (int)mapRect.getY() + aY;
                g.drawImage((Image)this.tempImage, startX, startY, (ImageObserver)((Object)this));
                g.setColor(this.getForeground());
                g.draw(mapRect);
                break;
            }
            case ROTATE: {
                float head;
                if (plot == null) break;
                if (plot instanceof Plot3D) {
                    Plot3D plot3d = (Plot3D)plot;
                    Projector projector = plot3d.getProjector();
                    float new_value = 0.0f;
                    if (e.isControlDown()) {
                        projector.set2D_xTranslation(projector.get2D_xTranslation() + (x - this.mouseLastPos.x));
                        projector.set2D_yTranslation(projector.get2D_yTranslation() + (y - this.mouseLastPos.y));
                    } else if (e.isShiftDown()) {
                        new_value = projector.getY2DScaling() + (float)(y - this.mouseLastPos.y) * 0.5f;
                        if (new_value > 60.0f) {
                            new_value = 60.0f;
                        }
                        if (new_value < 2.0f) {
                            new_value = 2.0f;
                        }
                        projector.set2DScaling(new_value);
                    } else {
                        for (new_value = projector.getRotationAngle() + (float)(x - this.mouseLastPos.x); new_value > 360.0f; new_value -= 360.0f) {
                        }
                        while (new_value < 0.0f) {
                            new_value += 360.0f;
                        }
                        projector.setRotationAngle(new_value);
                        new_value = projector.getElevationAngle() + (float)(y - this.mouseLastPos.y);
                        if (new_value > 90.0f) {
                            new_value = 90.0f;
                        } else if (new_value < 0.0f) {
                            new_value = 0.0f;
                        }
                        projector.setElevationAngle(new_value);
                    }
                    this.repaintNew();
                    break;
                }
                if (!(plot instanceof GLPlot)) break;
                GLPlot glPlot = (GLPlot)plot;
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isShiftDown()) {
                        Dimension size = e.getComponent().getSize();
                        float dx = (float)(x - this.mouseLastPos.x) / (float)size.width;
                        float dy = (float)(this.mouseLastPos.y - y) / (float)size.height;
                        Extent3D extent = glPlot.getDrawExtent();
                        float rotation = glPlot.getAngleY();
                        if (rotation < 90.0f || rotation > 270.0f) {
                            dx = -dx;
                            dy = -dy;
                        }
                        extent = extent.shift(extent.getWidth() * (double)dx, extent.getHeight() * (double)dy, 0.0);
                        glPlot.setDrawExtent((Extent)extent);
                    } else {
                        float elevation;
                        Dimension size = e.getComponent().getSize();
                        float thetaY = 360.0f * ((float)(x - this.mouseLastPos.x) / (float)size.width);
                        float thetaX = 180.0f * ((float)(this.mouseLastPos.y - y) / (float)size.height);
                        if (glPlot instanceof EarthGLPlot) {
                            float scale = glPlot.getScale();
                            thetaY /= scale;
                            thetaX /= scale;
                        }
                        if ((elevation = glPlot.getAngleX() - thetaX) > 0.0f) {
                            elevation = 0.0f;
                        }
                        if (elevation < -180.0f) {
                            elevation = -180.0f;
                        }
                        glPlot.setAngleX(elevation);
                        float rotation = glPlot.getAngleY() + thetaY;
                        if (rotation >= 360.0f) {
                            rotation -= 360.0f;
                        }
                        if (rotation < 0.0f) {
                            rotation += 360.0f;
                        }
                        glPlot.setAngleY(rotation);
                    }
                    this.repaint();
                    break;
                }
                if (!SwingUtilities.isRightMouseButton(e)) break;
                Dimension size = e.getComponent().getSize();
                float shift = 360.0f * ((float)(this.mouseLastPos.x - x) / (float)size.width);
                if (glPlot instanceof EarthGLPlot) {
                    float scale = glPlot.getScale();
                    shift /= -scale;
                }
                if ((head = glPlot.getHeadAngle() - shift) >= 360.0f) {
                    head -= 360.0f;
                } else if (head < 0.0f) {
                    head += 360.0f;
                }
                if (head < 1.0f) {
                    head = 0.0f;
                } else if (head > 359.0f) {
                    head = 0.0f;
                }
                glPlot.setHeadAngle(head);
                if (glPlot instanceof EarthGLPlot) {
                    shift = 180.0f * ((float)(this.mouseLastPos.y - y) / (float)size.height);
                    float pitch = glPlot.getPitchAngle() + shift;
                    if (pitch > 0.0f) {
                        pitch = 0.0f;
                    }
                    if (pitch < -90.0f) {
                        pitch = -90.0f;
                    }
                    glPlot.setPitchAngle(pitch);
                }
                this.repaint();
            }
        }
        this.mouseLastPos.x = x;
        this.mouseLastPos.y = y;
    }

    void onMouseClicked(MouseEvent e) {
        int clickTimes = e.getClickCount();
        if (clickTimes == 1) {
            if (e.getButton() == 1) {
                switch (this.mouseMode) {
                    case IDENTIFIER: {
                        Plot plot = this.selPlot(e.getX(), e.getY());
                        if (plot == null) {
                            return;
                        }
                        if (plot instanceof MapPlot) break;
                        return;
                    }
                }
            } else if (e.getButton() == 3) {
                this.popupMenu.show((Component)((Object)this), e.getX(), e.getY());
            }
        }
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        Plot plot = this.selPlot(e.getX(), e.getY());
        if (plot instanceof AbstractPlot2D) {
            Extent drawExtent = ((AbstractPlot2D)plot).getDrawExtent();
            double lonRan = drawExtent.maxX - drawExtent.minX;
            double latRan = drawExtent.maxY - drawExtent.minY;
            double mouseLon = drawExtent.minX + lonRan / 2.0;
            double mouseLat = drawExtent.minY + latRan / 2.0;
            double zoomF = 1.0f + (float)e.getWheelRotation() / 10.0f;
            double minX = mouseLon - lonRan / 2.0 * zoomF;
            double maxX = mouseLon + lonRan / 2.0 * zoomF;
            double minY = mouseLat - latRan / 2.0 * zoomF;
            double maxY = mouseLat + latRan / 2.0 * zoomF;
            switch (this.mouseMode) {
                case PAN: {
                    if (plot instanceof MapPlot) {
                        MapPlot mplt = (MapPlot)plot;
                        Graphics2D g = (Graphics2D)this.getGraphics();
                        Rectangle2D mapRect = mplt.getGraphArea();
                        this.lastMouseWheelTime = LocalDateTime.now();
                        if (!this.mouseWheelDetctionTimer.isRunning()) {
                            this.mouseWheelDetctionTimer.start();
                            this.tempImage = new BufferedImage((int)mapRect.getWidth() - 2, (int)mapRect.getHeight() - 2, 2);
                            Graphics2D tg = this.tempImage.createGraphics();
                            tg.setColor(Color.white);
                            tg.fill(mapRect);
                            tg.drawImage((Image)this.mapBitmap, -((int)mapRect.getX()) - 1, -((int)mapRect.getY()) - 1, (ImageObserver)((Object)this));
                            tg.dispose();
                        }
                        g.setClip(mapRect);
                        g.setColor(Color.white);
                        this.paintScale /= zoomF;
                        float nWidth = (float)mapRect.getWidth() * (float)this.paintScale;
                        float nHeight = (float)mapRect.getHeight() * (float)this.paintScale;
                        float nx = ((float)mapRect.getWidth() - nWidth) / 2.0f;
                        float ny = ((float)mapRect.getHeight() - nHeight) / 2.0f;
                        if (nx > 0.0f) {
                            g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)nx, (int)mapRect.getHeight());
                            g.fillRect((int)(mapRect.getMaxX() - (double)nx), (int)mapRect.getY(), (int)nx, (int)mapRect.getHeight());
                        }
                        if (ny > 0.0f) {
                            g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)mapRect.getWidth(), (int)ny);
                            g.fillRect((int)mapRect.getX(), (int)(mapRect.getMaxY() - (double)ny), (int)mapRect.getWidth(), (int)ny);
                        }
                        g.drawImage(this.tempImage, (int)(mapRect.getX() + (double)nx), (int)(mapRect.getY() + (double)ny), (int)nWidth, (int)nHeight, null);
                        g.setColor(this.getForeground());
                        g.draw(mapRect);
                        mplt.setDrawExtent(new Extent(minX, maxX, minY, maxY));
                        break;
                    }
                    ((AbstractPlot2D)plot).setDrawExtent(new Extent(minX, maxX, minY, maxY));
                    this.repaintNew();
                }
            }
        } else if (plot instanceof GLPlot) {
            GLPlot glPlot = (GLPlot)plot;
            Extent3D extent = glPlot.getDrawExtent();
            float zoomF = (float)e.getWheelRotation() / 10.0f;
            double dx = extent.getWidth() * (double)zoomF;
            double dy = extent.getHeight() * (double)zoomF;
            if (glPlot instanceof EarthGLPlot) {
                double dz = extent.getZLength() * (double)zoomF;
                extent = extent.extend(dx, dy, dz);
            } else if (this.zoomXY) {
                if (e.isShiftDown()) {
                    double dz = extent.getZLength() * (double)zoomF;
                    extent = extent.extend(dx, dy, dz);
                } else {
                    extent = extent.extend(dx, dy, 0.0);
                }
            } else if (e.isShiftDown()) {
                extent = extent.extend(dx, dy, 0.0);
            } else {
                double dz = extent.getZLength() * (double)zoomF;
                extent = extent.extend(dx, dy, dz);
            }
            glPlot.setDrawExtent((Extent)extent);
            this.repaint();
        }
    }

    @Override
    public void onUndoZoomClick() {
        Plot plot = this.currentPlot == null ? this.chart.getPlots().get(0) : this.currentPlot;
        plot.setDrawExtent((Extent)plot.getExtent().clone());
        this.repaintNew();
    }

    private void onSaveFigureClick(ActionEvent e) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"png"};
        GenericFileFilter pngFileFilter = new GenericFileFilter(fileExts, "Png Image (*.png)");
        aDlg.addChoosableFileFilter((FileFilter)pngFileFilter);
        fileExts = new String[]{"gif"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif Image (*.gif)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"jpg"};
        mapFileFilter = new GenericFileFilter(fileExts, "Jpeg Image (*.jpg)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"eps"};
        mapFileFilter = new GenericFileFilter(fileExts, "EPS file (*.eps)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"pdf"};
        mapFileFilter = new GenericFileFilter(fileExts, "PDF file (*.pdf)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"emf"};
        mapFileFilter = new GenericFileFilter(fileExts, "EMF file (*.emf)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        aDlg.setFileFilter((FileFilter)pngFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (0 == aDlg.showSaveDialog((Component)((Object)this))) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = aFile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            if (new File(fileName).exists()) {
                int overwrite = JOptionPane.showConfirmDialog((Component)((Object)this), "File exists! Overwrite it?");
                if (overwrite == 0) {
                    this.saveImage(fileName);
                }
            } else {
                this.saveImage(fileName);
            }
        }
    }

    @Override
    public void saveImage(String aFile) {
        try {
            this.saveImageSleep(aFile, null);
        }
        catch (IOException | InterruptedException | PrintException ex) {
            Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveImageSleep(String aFile, Integer sleep) throws FileNotFoundException, PrintException, IOException, InterruptedException {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        this.saveImage(aFile, w, h, sleep);
    }

    public void saveImage(String aFile, int width, int height, Integer sleep) throws FileNotFoundException, PrintException, IOException, InterruptedException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(GLChartPanel.this.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(GLChartPanel.this.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        GLChartPanel.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                if (sleep != null) {
                    Thread.sleep(sleep * 1000);
                }
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            try {
                Document document = new Document(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(aFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate pdfTemp = cb.createTemplate((float)width, (float)height);
                PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)pdfTemp, (float)width, (float)height, true);
                this.paintGraphics((Graphics2D)g2, width, height);
                if (sleep != null) {
                    Thread.sleep(sleep * 1000);
                }
                g2.dispose();
                cb.addTemplate(pdfTemp, 0.0f, 0.0f);
                document.close();
            }
            catch (DocumentException | FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (aFile.endsWith(".emf")) {
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            g.endExport();
            g.dispose();
        } else {
            TileLoadListener tileLoadListener;
            MapPlot mapPlot;
            ImageFormats imageFormat = ImageUtil.getImageFormat((String)aFile);
            int imageType = imageFormat == ImageFormats.JPEG ? 1 : 2;
            BufferedImage image = this.chart.containsGLPlot() ? JOGLUtil.paintViewImage(this.chart, width, height) : new BufferedImage(width, height, imageType);
            Graphics2D g = image.createGraphics();
            if (this.hasWebMap()) {
                for (Plot plot : this.chart.getPlots()) {
                    if (!(plot instanceof MapPlot) || !(mapPlot = (MapPlot)plot).hasWebMapLayer()) continue;
                    tileLoadListener = mapPlot.getTileLoadListener();
                    tileLoadListener.setGraphics2D(g);
                    tileLoadListener.setTransform(new AffineTransform());
                    tileLoadListener.setWidth(width);
                    tileLoadListener.setHeight(height);
                }
            }
            this.paintGraphics(g, width, height);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            ImageUtil.imageSave((BufferedImage)image, (String)aFile);
            if (this.hasWebMap()) {
                for (Plot plot : this.chart.getPlots()) {
                    if (!(plot instanceof MapPlot) || !(mapPlot = (MapPlot)plot).hasWebMapLayer()) continue;
                    tileLoadListener = mapPlot.getTileLoadListener();
                    tileLoadListener.setGraphics2D(null);
                    tileLoadListener.setTransform(null);
                    tileLoadListener.setWidth(this.getWidth());
                    tileLoadListener.setHeight(this.getHeight());
                }
            }
        }
    }

    private Node getAttributeByName(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            if (!n.getNodeName().equals(attributeName)) continue;
            return n;
        }
        return null;
    }

    public boolean saveImage_Jpeg(String file, int dpi) {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.saveImage_Jpeg(file, w, h, dpi);
    }

    public boolean saveImage_Jpeg(String file, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = this.chart.containsGLPlot() ? JOGLUtil.paintViewImage(this.chart, width, height, dpi) : new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
        Graphics2D g = bufferedImage.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g, width, height);
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(0.85f);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (Exception e) {
            return false;
        }
        g.dispose();
        return true;
    }

    public void saveImage(String fileName, int dpi) throws IOException, InterruptedException {
        this.saveImage(fileName, dpi, null);
    }

    public void saveImage(String fileName, int dpi, Integer sleep) throws IOException, InterruptedException {
        int width;
        int height;
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.saveImage(fileName, dpi, width, height, sleep);
    }

    public void saveImage(String fileName, int dpi, int width, int height, Integer sleep) throws IOException, InterruptedException {
        TileLoadListener tileLoadListener;
        MapPlot mapPlot;
        File output = new File(fileName);
        output.delete();
        ImageFormats imageFormat = ImageUtil.getImageFormat((String)fileName);
        double scaleFactor = (double)dpi / 72.0;
        int imageType = imageFormat == ImageFormats.JPEG ? 1 : 2;
        BufferedImage image = this.chart.containsGLPlot() ? JOGLUtil.paintViewImage(this.chart, width, height, dpi) : new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), imageType);
        Graphics2D g = image.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        if (this.hasWebMap()) {
            for (Plot plot : this.chart.getPlots()) {
                if (!(plot instanceof MapPlot) || !(mapPlot = (MapPlot)plot).hasWebMapLayer()) continue;
                tileLoadListener = mapPlot.getTileLoadListener();
                tileLoadListener.setGraphics2D(g);
                tileLoadListener.setTransform(at);
                tileLoadListener.setWidth(width);
                tileLoadListener.setHeight(height);
            }
        }
        this.paintGraphics(g, width, height);
        if (sleep != null) {
            Thread.sleep(sleep * 1000);
        }
        ImageUtil.imageSave((BufferedImage)image, (String)fileName, (int)dpi);
        if (this.hasWebMap()) {
            for (Plot plot : this.chart.getPlots()) {
                if (!(plot instanceof MapPlot) || !(mapPlot = (MapPlot)plot).hasWebMapLayer()) continue;
                tileLoadListener = mapPlot.getTileLoadListener();
                tileLoadListener.setGraphics2D(null);
                tileLoadListener.setTransform(null);
                tileLoadListener.setWidth(this.getWidth());
                tileLoadListener.setHeight(this.getHeight());
            }
        }
    }

    public BufferedImage getViewImage() {
        return this.mapBitmap;
    }

    public BufferedImage paintViewImage() {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.paintViewImage(w, h);
    }

    public BufferedImage paintViewImage(int width, int height) {
        BufferedImage image = this.chart.containsGLPlot() ? JOGLUtil.paintViewImage(this.chart, width, height) : new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        this.paintGraphics(g, width, height);
        return image;
    }

    public BufferedImage paintViewImage(int dpi) {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.paintViewImage(w, h, dpi);
    }

    public BufferedImage paintViewImage(int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage image = this.chart.containsGLPlot() ? JOGLUtil.paintViewImage(this.chart, width, height, dpi) : new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 2);
        Graphics2D g = image.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g, width, height);
        return image;
    }

    public boolean hasWebMap() {
        if (this.chart != null) {
            return this.chart.hasWebMap();
        }
        return false;
    }
}

