/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.chart.geo.MapGridLine;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;

public class MapGridLine3D
extends MapGridLine {
    public MapGridLine3D() {
        this.extent = new Extent3D(-100.0, 100.0, -100.0, 100.0, 0.0, 100.0);
    }

    public MapGridLine3D(ProjectionInfo projInfo, Extent3D extent) {
        super(true);
        this.projInfo = projInfo;
        this.setExtent((Extent)extent);
    }

    @Override
    protected void updateLongitudeLines() {
        this.longitudeLines = new GraphicCollection3D();
        ((GraphicCollection3D)this.longitudeLines).setUsingLight(false);
        double latMin = this.lonLatExtent.minY;
        double latMax = this.lonLatExtent.maxY;
        double delta = this.lonLatExtent.getHeight() / (double)(this.nPoints - 1);
        double z = ((Extent3D)this.extent).minZ;
        Iterator iterator = this.longitudeLocations.iterator();
        while (iterator.hasNext()) {
            double lon = (Double)iterator.next();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            for (double lat = latMin; lat <= latMax; lat += delta) {
                points.add(new PointZ(lon, lat, z));
            }
            PolylineZShape line = new PolylineZShape();
            line.setPoints(points);
            Graphic graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            graphic = ProjectionUtil.projectClipGraphic((Graphic)graphic, (ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo);
            graphic.getShape().setValue(lon);
            this.longitudeLines.add(graphic);
        }
    }

    @Override
    protected void updateLatitudeLines() {
        this.latitudeLines = new GraphicCollection3D();
        ((GraphicCollection3D)this.latitudeLines).setUsingLight(false);
        double lonMin = this.lonLatExtent.minX;
        double lonMax = this.lonLatExtent.maxX;
        if (lonMin < -170.0) {
            lonMin = -180.0;
        }
        if (lonMax > 170.0) {
            lonMax = 180.0;
        }
        double delta = (lonMax - lonMin) / (double)(this.nPoints - 1);
        double z = ((Extent3D)this.extent).minZ;
        Iterator iterator = this.latitudeLocations.iterator();
        while (iterator.hasNext()) {
            double lat = (Double)iterator.next();
            List points = new ArrayList<PointZ>();
            for (double lon = lonMin; lon <= lonMax; lon += delta) {
                points.add(new PointZ(lon, lat, z));
            }
            PolylineZShape line = new PolylineZShape();
            line.setPoints(points);
            Graphic graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            graphic = ProjectionUtil.projectClipGraphic((Graphic)graphic, (ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo);
            if (graphic.getShape().getPartNum() > 1) {
                points = ((Polyline)((PolylineZShape)graphic.getShape()).getPolylines().get(0)).getPointList();
                List points1 = ((Polyline)((PolylineZShape)graphic.getShape()).getPolylines().get(1)).getPointList();
                Collections.reverse(points1);
                points.addAll(points1);
                line = new PolylineZShape();
                line.setPoints(points);
                graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            }
            graphic.getShape().setValue(lat);
            this.latitudeLines.add(graphic);
        }
    }
}

