/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.geo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.ChartNorthArrow;
import org.meteoinfo.chart.ChartScaleBar;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.axis.LonLatAxis;
import org.meteoinfo.chart.axis.ProjLonLatAxis;
import org.meteoinfo.chart.geo.MapGridLine;
import org.meteoinfo.chart.graphic.GeoGraphicCollection;
import org.meteoinfo.chart.graphic.GraphicProjectionUtil;
import org.meteoinfo.chart.graphic.WebMapImage;
import org.meteoinfo.chart.plot.Plot2D;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.GeoUtil;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.ShapeUtil;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.render.java2d.Draw;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MapPlot
extends Plot2D
implements IWebMapPanel {
    private ProjectionInfo projInfo;
    protected TileLoadListener tileLoadListener = new TileLoadListener((IWebMapPanel)this);
    private IChartPanel parent;
    private float[] lonLim;
    private float[] latLim;
    private Graphic boundary;
    private ChartScaleBar scaleBar;
    private ChartNorthArrow northArrow;
    private boolean degreeSpace = false;

    public MapPlot() {
        this(KnownCoordinateSystems.geographic.world.WGS1984);
    }

    public MapPlot(ProjectionInfo projInfo) {
        this.projInfo = projInfo;
        this.aspectType = AspectType.EQUAL;
        this.gridLine = new MapGridLine(projInfo);
        this.gridLine.setTop(true);
        if (this.projInfo.isLonLat()) {
            this.setXAxis(new LonLatAxis("Longitude", true));
            this.setYAxis(new LonLatAxis("Latitude", false));
        } else {
            this.setXAxis(new ProjLonLatAxis("Longitude", true, (MapGridLine)this.gridLine));
            this.setYAxis(new ProjLonLatAxis("Latitude", false, (MapGridLine)this.gridLine));
        }
        this.getAxis(Location.TOP).setVisible(false);
        this.getAxis(Location.RIGHT).setVisible(false);
        this.setDrawNeatLine(true);
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
        PolygonShape bvs = this.projInfo.getBoundary();
        if (bvs != null) {
            this.setBoundary(bvs);
        }
    }

    public TileLoadListener getTileLoadListener() {
        return this.tileLoadListener;
    }

    public void setParent(IChartPanel value) {
        this.parent = value;
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XY2D;
    }

    public ProjectionInfo getProjInfo() {
        return this.projInfo;
    }

    public void setProjInfo(ProjectionInfo proj) {
        this.projInfo = proj;
        ((MapGridLine)this.gridLine).setProjInfo(proj);
        if (proj.isLonLat()) {
            if (this.getXAxis() instanceof ProjLonLatAxis) {
                for (Location loc : this.axis.keySet()) {
                    Axis axis = (Axis)this.axis.get((Object)loc);
                    axis = new LonLatAxis(axis);
                    this.axis.put(loc, axis);
                }
            }
        } else if (!(this.getXAxis() instanceof ProjLonLatAxis)) {
            for (Location loc : this.axis.keySet()) {
                Axis axis = (Axis)this.axis.get((Object)loc);
                axis = new ProjLonLatAxis((LonLatAxis)axis, (MapGridLine)this.gridLine);
                this.axis.put(loc, axis);
            }
        }
        if (proj.getBoundary() != null) {
            this.setBoundary(proj.getBoundary());
        }
    }

    public boolean isLonLatMap() {
        return this.projInfo.isLonLat();
    }

    public float[] getLonLim() {
        return this.lonLim;
    }

    public void setLonLim(float[] value) {
        this.lonLim = value;
    }

    public void setLonLim(float lon1, float lon2) {
        this.lonLim = new float[]{lon1, lon2};
    }

    public float[] getLatLim() {
        return this.latLim;
    }

    public void setLatLim(float[] value) {
        this.latLim = value;
    }

    public void setLatLim(float lat1, float lat2) {
        this.latLim = new float[]{lat1, lat2};
    }

    public Graphic getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Graphic value) {
        this.boundary = value;
    }

    public void setBoundary(PolygonShape value) {
        PolygonBreak pb = new PolygonBreak();
        pb.setOutlineSize(1.5f);
        pb.setDrawFill(false);
        this.boundary = new Graphic((org.meteoinfo.geometry.shape.Shape)value, (ColorBreak)pb);
    }

    public void setBoundaryProp(PolygonBreak pb) {
        if (this.boundary != null) {
            this.boundary = new Graphic(this.boundary.getShape(), (ColorBreak)pb);
        }
    }

    public ChartScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public void setScaleBar(ChartScaleBar value) {
        this.scaleBar = value;
    }

    public ChartNorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public void setNorthArrow(ChartNorthArrow value) {
        this.northArrow = value;
    }

    public boolean isDegreeSpace() {
        return this.degreeSpace;
    }

    public void setDegreeSpace(boolean value) {
        this.degreeSpace = value;
    }

    public boolean hasWebMapLayer() {
        for (Graphic g : this.graphics.getGraphics()) {
            if (!(g instanceof WebMapImage)) continue;
            return true;
        }
        return false;
    }

    public WebMapImage getWebMapImage() {
        for (Graphic g : this.graphics.getGraphics()) {
            if (!(g instanceof WebMapImage)) continue;
            return (WebMapImage)g;
        }
        return null;
    }

    public int getWebMapZoom() {
        WebMapImage webMapImage = this.getWebMapImage();
        return webMapImage == null ? 0 : webMapImage.getZoom();
    }

    public PointD getGeoCenter() {
        PointD viewCenter = this.getViewCenter();
        return Reproject.reprojectPoint((PointD)viewCenter, (ProjectionInfo)this.projInfo, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984);
    }

    public PointD getViewCenter() {
        return this.drawExtent.getCenterPoint();
    }

    public void setViewCenter(PointD center) {
        Extent extent;
        PointD oldCenter = this.getViewCenter();
        double dx = center.X - oldCenter.X;
        double dy = center.Y - oldCenter.Y;
        this.drawExtent = extent = this.drawExtent.shift(dx, dy);
    }

    public void reDraw() {
        if (this.parent != null) {
            this.parent.paintGraphics();
        }
    }

    public void reDraw(Graphics2D graphics2D, int width, int height) {
        if (this.parent != null) {
            this.parent.paintGraphics(graphics2D, width, height);
        }
    }

    @Override
    public void draw(Graphics2D g, Rectangle2D area) {
        float y;
        float x;
        super.draw(g, area);
        if (this.scaleBar != null) {
            x = (float)(area.getWidth() * (double)this.scaleBar.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.scaleBar.getY()));
            this.scaleBar.draw(g, x, y);
        }
        if (this.northArrow != null) {
            x = (float)(area.getWidth() * (double)this.northArrow.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.northArrow.getY()));
            this.northArrow.draw(g, x, y);
        }
    }

    @Override
    protected void drawGraph(Graphics2D g, Rectangle2D area) {
        PolygonBreak pb;
        Shape oldRegion = g.getClip();
        if (this.clip) {
            g.setClip(area);
        }
        AffineTransform oldMatrix = g.getTransform();
        g.translate(area.getX(), area.getY());
        if (this.boundary != null && (pb = (PolygonBreak)this.boundary.getLegend().clone()).isDrawFill()) {
            pb.setDrawOutline(false);
            this.drawGraphic(g, this.boundary, (ColorBreak)pb, area);
        }
        g.setTransform(oldMatrix);
        g.translate(area.getX(), area.getY());
        this.plotGraphics(g, area);
        if (this.boundary != null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pb = (PolygonBreak)this.boundary.getLegend().clone();
            pb.setDrawFill(false);
            this.drawGraphic(g, this.boundary, (ColorBreak)pb, area);
            if (!this.antiAlias) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        g.setTransform(oldMatrix);
        if (this.clip) {
            g.setClip(oldRegion);
        }
    }

    @Override
    protected void plotGraphics(Graphics2D g, Rectangle2D area) {
        int barIdx = 0;
        block4: for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            Graphic graphic = this.graphics.get(m);
            if (!graphic.isVisible()) continue;
            if (graphic instanceof WebMapImage) {
                this.updateXYScale(area.getWidth(), area.getHeight());
                this.updateWebMapScale(area.getWidth(), area.getHeight());
                this.drawWebMapImage(g, (WebMapImage)graphic, area);
                continue;
            }
            ColorBreak cb = graphic.getLegend();
            ShapeTypes shapeType = graphic.getGraphicN(0).getShape().getShapeType();
            switch (shapeType) {
                case BAR: {
                    this.drawBars(g, (GraphicCollection)graphic, barIdx, area);
                    ++barIdx;
                    continue block4;
                }
                case STATION_MODEL: {
                    this.drawStationModel(g, (GraphicCollection)graphic, area);
                    continue block4;
                }
                default: {
                    if (graphic.getExtent().intersects(this.drawExtent)) {
                        this.drawGraphics(g, graphic, area);
                    }
                    if (!this.isLonLatMap() || !(graphic instanceof GeoGraphicCollection) || !(this.drawExtent.maxX > 180.0)) continue block4;
                    this.drawGraphics(g, (Graphic)((GeoGraphicCollection)graphic).xShiftCopy(360.0), area);
                }
            }
        }
    }

    void drawStationModel(Graphics2D g, GraphicCollection graphics, Rectangle2D area) {
        PointF pointF = new PointF();
        LegendScheme ls = graphics.getLegendScheme();
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        PointBreak pointBreak = (PointBreak)ls.getLegendBreak(0);
        for (Graphic graphic : graphics.getGraphics()) {
            StationModelShape shape = (StationModelShape)graphic.getShape();
            PointD p = shape.getPoint();
            if (p.X < this.drawExtent.minX || p.X > this.drawExtent.maxX || p.Y < this.drawExtent.minY || p.Y > this.drawExtent.maxY || !pointBreak.isDrawShape()) continue;
            double[] screenXY = this.projToScreen(p.X, p.Y, area);
            pointF.X = (float)screenXY[0];
            pointF.Y = (float)screenXY[1];
            boolean isDraw = true;
            if (graphics.isAvoidCollision()) {
                float aSize = pointBreak.getSize();
                Extent aExtent = new Extent();
                aExtent.minX = pointF.X - aSize;
                aExtent.maxX = pointF.X + aSize;
                aExtent.minY = pointF.Y - aSize;
                aExtent.maxY = pointF.Y + aSize;
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (Extent extent : extentList) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)extent).booleanValue()) continue;
                        isDraw = false;
                        break;
                    }
                    if (isDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    }
                }
            }
            if (!isDraw) continue;
            Draw.drawStationModel((Color)pointBreak.getColor(), (Color)pointBreak.getOutlineColor(), (PointF)pointF, (StationModelShape)shape, (Graphics2D)g, (float)pointBreak.getSize(), (float)(pointBreak.getSize() / 8.0f * 3.0f));
        }
    }

    private double getWebMapScale(WebMapImage graphic, int zoom, double width, double height) {
        Point2D center = graphic.getCenter();
        double minx = center.getX() - width / 2.0;
        double miny = center.getY() - height / 2.0;
        double maxx = center.getX() + width / 2.0;
        double maxy = center.getY() + height / 2.0;
        GeoPosition pos1 = GeoUtil.getPosition((Point2D)new Point2D.Double(minx, miny), (int)zoom, (TileFactoryInfo)graphic.getTileFactory().getInfo());
        GeoPosition pos2 = GeoUtil.getPosition((Point2D)new Point2D.Double(maxx, maxy), (int)zoom, (TileFactoryInfo)graphic.getTileFactory().getInfo());
        PointD p1 = Reproject.reprojectPoint((PointD)new PointD(pos1.getLongitude(), pos1.getLatitude()), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
        PointD p2 = Reproject.reprojectPoint((PointD)new PointD(pos2.getLongitude(), pos2.getLatitude()), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
        if (pos2.getLongitude() - pos1.getLongitude() < 360.0 && pos2.getLongitude() <= 180.0) {
            double xlen = Math.abs(p2.X - p1.X);
            return width / xlen;
        }
        double ylen = Math.abs(p2.Y - p1.Y);
        return height / ylen;
    }

    private void setScale(double scale, double width, double height) {
        this.xScale = scale;
        this.yScale = scale;
        PointD center = (PointD)this.drawExtent.getCenterPoint().clone();
        double xlen = width / scale * 0.5;
        double ylen = height / scale * 0.5;
        this.drawExtent.minX = center.X - xlen;
        this.drawExtent.maxX = center.X + xlen;
        this.drawExtent.minY = center.Y - ylen;
        this.drawExtent.maxY = center.Y + ylen;
    }

    private void updateXYScale(double width, double height) {
        this.updateXYScale(this.drawExtent, width, height);
        this.updateDrawExtent();
    }

    private void updateXYScale(Extent aExtent, double width, double height) {
        this.xScale = width / (aExtent.maxX - aExtent.minX);
        this.yScale = height / (aExtent.maxY - aExtent.minY);
        if (this.xScale > this.yScale) {
            this.xScale = this.yScale;
            double temp = aExtent.minX;
            aExtent.minX = aExtent.maxX - width / this.xScale;
            double lonRan = (aExtent.minX - temp) / 2.0;
            aExtent.minX -= lonRan;
            aExtent.maxX -= lonRan;
        } else if (this.xScale < this.yScale) {
            this.yScale = this.xScale;
            double temp = aExtent.minY;
            aExtent.minY = aExtent.maxY - height / this.yScale;
            double latRan = (aExtent.minY - temp) / 2.0;
            aExtent.minY -= latRan;
            aExtent.maxY -= latRan;
        }
    }

    private void updateWebMapScale(double width, double height) {
        this.updateWebMapScale(this.getWebMapImage(), width, height);
    }

    private void updateWebMapScale(WebMapImage layer, double width, double height) {
        double webMapScale = layer.getWebMapScale();
        if (!MIMath.doubleEquals((double)this.xScale, (double)webMapScale)) {
            int minZoom = layer.getTileFactory().getInfo().getMinimumZoomLevel();
            int maxZoom = layer.getTileFactory().getInfo().getMaximumZoomLevel();
            int newZoom = minZoom;
            double scale = webMapScale;
            for (int i = maxZoom; i >= minZoom; --i) {
                layer.setZoom(i);
                scale = this.getWebMapScale(layer, i, width, height);
                if (!(this.xScale < scale)) continue;
                newZoom = i;
                if (!(this.xScale < webMapScale) || i >= maxZoom) break;
                newZoom = i + 1;
                scale = this.getWebMapScale(layer, newZoom, width, height);
                break;
            }
            this.setScale(scale, width, height);
            layer.setWebMapScale(scale);
            layer.setZoom(newZoom);
        }
    }

    void drawWebMapImage(Graphics2D g, WebMapImage graphic, Rectangle2D area) {
        PointD geoCenter = this.getGeoCenter();
        graphic.setAddressLocation(new GeoPosition(geoCenter.Y, geoCenter.X));
        double webMapScale = graphic.getWebMapScale();
        if (!MIMath.doubleEquals((double)this.xScale, (double)webMapScale)) {
            int minZoom = graphic.getTileFactory().getInfo().getMinimumZoomLevel();
            int maxZoom = graphic.getTileFactory().getInfo().getMaximumZoomLevel();
            int newZoom = minZoom;
            double scale = webMapScale;
            double width = area.getWidth();
            double height = area.getHeight();
            for (int i = maxZoom; i >= minZoom; --i) {
                graphic.setZoom(i);
                scale = this.getWebMapScale(graphic, i, width, height);
                if (!(this.xScale < scale)) continue;
                newZoom = i;
                if (!(this.xScale < webMapScale) || i >= maxZoom) break;
                newZoom = i + 1;
                scale = this.getWebMapScale(graphic, newZoom, width, height);
                break;
            }
            this.setScale(scale, width, height);
            graphic.setWebMapScale(scale);
            graphic.setZoom(newZoom);
        }
        graphic.draw(g, area, this.tileLoadListener);
    }

    @Override
    public Graphic addGraphic(Graphic graphic) {
        graphic.doTransform();
        return super.addGraphic(graphic);
    }

    @Override
    public Graphic addGraphic(int idx, Graphic graphic) {
        graphic.doTransform();
        return super.addGraphic(idx, graphic);
    }

    public Graphic addGraphic(Graphic graphic, ProjectionInfo proj) {
        ProjectionInfo toProj = this.getProjInfo();
        if (proj.equals(toProj)) {
            super.addGraphic(graphic);
            return graphic;
        }
        Graphic nGraphic = GraphicProjectionUtil.projectClipGraphic(graphic, proj, toProj);
        if (nGraphic != null) {
            super.addGraphic(nGraphic);
        }
        return nGraphic;
    }

    public Graphic addGraphic(int index, Graphic graphic, ProjectionInfo proj) {
        ProjectionInfo toProj = this.getProjInfo();
        if (proj.equals(toProj)) {
            this.addGraphic(index, graphic);
            return graphic;
        }
        Graphic nGraphic = GraphicProjectionUtil.projectClipGraphic(graphic, proj, toProj);
        this.addGraphic(index, nGraphic);
        return nGraphic;
    }

    @Override
    public void addText(ChartText text) {
        this.addText(text, true);
    }

    public void addText(ChartText text, boolean isLonLat) {
        if (isLonLat && !this.projInfo.isLonLat()) {
            PointD xyp = Reproject.reprojectPoint((double)text.getX(), (double)text.getY(), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
            text.setX(xyp.X);
            text.setY(xyp.Y);
        }
        super.addText(text);
    }

    public Extent getFullExtent() {
        Extent ext = this.getExtent();
        if (this.boundary != null) {
            ext = ext.union(this.boundary.getExtent().extend(0.015));
        }
        return ext;
    }

    public void zoomToExtentLonLatEx(Extent aExtent) {
        if (!this.projInfo.isLonLat()) {
            aExtent = this.projInfo.getProjectionName() == ProjectionNames.Mercator ? ProjectionUtil.getProjectionExtent((ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo, (Extent)aExtent) : ProjectionUtil.getProjectionExtent((ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo, (Extent)aExtent, (int)10);
        }
        this.setDrawExtent(aExtent);
    }

    public void setLonLatExtent(Extent extent) {
        if (this.projInfo.isLonLat()) {
            super.setDrawExtent(extent);
        } else {
            this.zoomToExtentLonLatEx(extent);
            super.setDrawExtent1(this.getDrawExtent());
            this.setAxisExtent(extent);
        }
    }

    public void setAxisExtent(Extent extent) {
        this.getAxis(Location.BOTTOM).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.TOP).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.LEFT).setMinMaxValue(extent.minY, extent.maxY);
        this.getAxis(Location.RIGHT).setMinMaxValue(extent.minY, extent.maxY);
    }

    @Override
    public void setDrawExtent(Extent extent) {
        super.setDrawExtent(extent);
        if (!this.isLonLatMap()) {
            ((MapGridLine)this.gridLine).setExtent(extent);
        }
    }

    @Override
    public void updateDrawExtent() {
        super.updateDrawExtent();
        if (!this.isLonLatMap()) {
            ((MapGridLine)this.gridLine).setExtent(this.extent);
        }
    }

    public void addPoint(double lat, double lon, PointBreak pb) {
        PointShape ps = new PointShape();
        PointD lonlatp = new PointD(lon, lat);
        if (this.isLonLatMap()) {
            ps.setPoint(lonlatp);
        } else {
            PointD xyp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getProjInfo());
            ps.setPoint(xyp);
        }
        Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)ps, (ColorBreak)pb);
        this.addGraphic(aGraphic);
    }

    public Graphic addPoint(List<Number> lat, List<Number> lon, PointBreak pb) {
        int i = 0;
        if (i < lat.size()) {
            PointShape ps = new PointShape();
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            PointD lonlatp = new PointD(x, y);
            if (this.isLonLatMap()) {
                ps.setPoint(lonlatp);
            } else {
                PointD xyp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getProjInfo());
                ps.setPoint(xyp);
            }
            Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)ps, (ColorBreak)pb);
            this.addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pls, (ColorBreak)plb);
                    this.addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pls, (ColorBreak)plb);
            this.addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb, boolean iscurve) {
        Object pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pls, (ColorBreak)plb);
                    this.addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.projInfo.isLonLat()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = iscurve ? new CurveLineShape() : new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pls, (ColorBreak)plb);
            this.addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolygon(List<Number> lat, List<Number> lon, PolygonBreak pgb) {
        PolygonShape pgs;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() > 2) {
                    pgs = new PolygonShape();
                    pgs.setPoints(points);
                    Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pgs, (ColorBreak)pgb);
                    this.addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.projInfo.isLonLat()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.projInfo);
            }
            points.add(lonlatp);
        }
        if (points.size() > 2) {
            pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic aGraphic = new Graphic((org.meteoinfo.geometry.shape.Shape)pgs, (ColorBreak)pgb);
            this.addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addCircle(float x, float y, float radius, PolygonBreak pgb) {
        CircleShape aPGS = ShapeUtil.createCircleShape((float)x, (float)y, (float)radius);
        Graphic graphic = new Graphic((org.meteoinfo.geometry.shape.Shape)aPGS, (ColorBreak)pgb);
        this.addGraphic(graphic);
        return graphic;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void drawGridLine(Graphics2D g, Rectangle2D area) {
        block51: {
            block50: {
                if (!this.projInfo.isLonLat()) break block50;
                super.drawGridLine(g, area);
                break block51;
            }
            if (this.antiAlias) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            }
            oldMatrix = g.getTransform();
            oldRegion = g.getClip();
            if (this.clip) {
                g.setClip(area);
            }
            g.translate(area.getX(), area.getY());
            mapGridLine = (MapGridLine)this.gridLine;
            if (mapGridLine.isDrawXLine() && mapGridLine.getLongitudeLines() != null) {
                this.drawGraphics(g, (Graphic)mapGridLine.getLongitudeLines(), area);
            }
            if (mapGridLine.isDrawYLine() && mapGridLine.getLatitudeLines() != null) {
                this.drawGraphics(g, (Graphic)mapGridLine.getLatitudeLines(), area);
            }
            g.setTransform(oldMatrix);
            if (this.clip) {
                g.setClip(oldRegion);
            }
            if (!mapGridLine.isLabelVisible()) break block51;
            xMin = area.getX();
            xMax = area.getX() + area.getWidth();
            yMin = area.getY();
            yMax = area.getY() + area.getHeight();
            shift = 5.0f;
            extentList = new ArrayList<Extent>();
            maxExtent = new Extent();
            g.setColor(mapGridLine.getColor());
            g.setStroke(new BasicStroke(mapGridLine.getSize()));
            sP = new PointF(0.0f, 0.0f);
            eP = new PointF(0.0f, 0.0f);
            axis = this.getXAxis();
            font = mapGridLine.labelFont;
            g.setFont(font);
            len = axis.getTickLength();
            space = axis.getTickSpace();
            xAlign = XAlign.CENTER;
            yAlign = YAlign.CENTER;
            block27: for (i = 0; i < mapGridLine.getGridLabels().size(); ++i) {
                aGL = mapGridLine.getGridLabels().get(i);
                switch (1.$SwitchMap$org$meteoinfo$chart$plot$GridLabelPosition[mapGridLine.getLabelPosition().ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 2: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl71
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 3: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl71
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 2: 
                            case 4: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl71
                    }
                    case 4: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 3: 
                            case 4: {
                                continue block27;
                            }
                        }
                    }
lbl71:
                    // 5 sources

                    default: {
                        labX = aGL.getCoord().X;
                        labY = aGL.getCoord().Y;
                        xy = this.projToScreen(labX, labY, area);
                        labX = xy[0] + xMin;
                        labY = xy[1] + yMin;
                        sP.X = (float)labX;
                        sP.Y = (float)labY;
                        if (aGL.isBorder()) {
                            switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: {
                                    sP.Y = (float)area.getMaxY();
                                }
                            }
                        }
                        drawStr = aGL.getLabString();
                        aSF = Draw.getStringDimension((String)drawStr, (Graphics2D)g);
                        ifDraw = true;
                        aExtent = new Extent();
                        aExtent.minX = labX;
                        aExtent.maxX = labX + (double)aSF.width;
                        aExtent.minY = labY - (double)aSF.height;
                        aExtent.maxY = labY;
                        if (extentList.isEmpty()) {
                            maxExtent = (Extent)aExtent.clone();
                            extentList.add((Extent)aExtent.clone());
                        } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                            extentList.add((Extent)aExtent.clone());
                            maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                        } else {
                            for (j = 0; j < extentList.size(); ++j) {
                                if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(j))).booleanValue()) continue;
                                ifDraw = false;
                                break;
                            }
                            if (ifDraw) {
                                extentList.add(aExtent);
                                maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                            }
                        }
                        if (!ifDraw) continue block27;
                        if (aGL.isBorder()) {
                            switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: {
                                    eP.X = sP.X;
                                    if (axis.isInsideTick()) {
                                        eP.Y = sP.Y - len;
                                        labY = sP.Y + (float)space;
                                    } else {
                                        eP.Y = sP.Y + len;
                                        labY = eP.Y + (float)space;
                                    }
                                    xAlign = XAlign.CENTER;
                                    yAlign = YAlign.TOP;
                                    break;
                                }
                                case 4: {
                                    eP.Y = sP.Y;
                                    if (axis.isInsideTick()) {
                                        eP.X = sP.X + len;
                                        labX = sP.X - (float)space;
                                    } else {
                                        eP.X = sP.X - len;
                                        labX = eP.X - (float)space;
                                    }
                                    xAlign = XAlign.RIGHT;
                                    yAlign = YAlign.CENTER;
                                    break;
                                }
                                case 2: {
                                    eP.X = sP.X;
                                    if (axis.isInsideTick()) {
                                        eP.Y = sP.Y + len;
                                        labY = sP.Y - (float)space;
                                    } else {
                                        eP.Y = sP.Y - len;
                                        labY = eP.Y - (float)space;
                                    }
                                    xAlign = XAlign.CENTER;
                                    yAlign = YAlign.BOTTOM;
                                    break;
                                }
                                case 1: {
                                    eP.Y = sP.Y;
                                    if (axis.isInsideTick()) {
                                        eP.X = sP.X - len;
                                        labX = sP.X + (float)space;
                                    } else {
                                        eP.X = sP.X + len;
                                        labX = eP.X + (float)space;
                                    }
                                    xAlign = XAlign.LEFT;
                                    yAlign = YAlign.CENTER;
                                }
                            }
                            g.setColor(axis.getLineColor());
                            g.setStroke(new BasicStroke(axis.getLineWidth()));
                            g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                            g.setColor(this.getXAxis().getTickLabelColor());
                            Draw.drawString((Graphics2D)g, (double)labX, (double)labY, (String)drawStr, (XAlign)xAlign, (YAlign)yAlign, (boolean)false);
                            continue block27;
                        }
                        g.setColor(this.getXAxis().getTickLabelColor());
                        objs = this.getProjInfo().checkGridLabel(aGL, 5.0f);
                        xShift = ((Float)objs[0]).floatValue();
                        yShift = ((Float)objs[1]).floatValue();
                        xAlign = (XAlign)objs[2];
                        yAlign = (YAlign)objs[3];
                        Draw.drawString((Graphics2D)g, (double)(labX + (double)xShift), (double)(labY + (double)yShift), (String)drawStr, (XAlign)xAlign, (YAlign)yAlign, (boolean)false);
                    }
                }
            }
        }
    }

    public void loadMIProjectFile(String fn, int mfidx) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(fn);
        String userDir = System.getProperty("user.dir");
        System.setProperty("user.dir", file.getParent());
        String pPath = file.getParent();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(fn));
        Element root = doc.getDocumentElement();
        Element mapFrames = (Element)root.getElementsByTagName("MapFrames").item(0);
        System.setProperty("user.dir", userDir);
    }

    public void loadMIProjectFile(String fn) throws SAXException, IOException, ParserConfigurationException {
        this.loadMIProjectFile(fn, 0);
    }
}

