/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.util.List;
import org.joml.Math;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.render.jogl.RayCastingType;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.OpacityTransferFunction;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;

public class VolumeGraphic
extends GraphicCollection3D {
    final int width;
    final int height;
    final int depth;
    private Array data;
    final byte[] byteData;
    private byte[] normals;
    final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    private byte[] colors;
    private byte[] originalColors;
    private TransferFunction transferFunction = new TransferFunction();
    private float[] opacityLevels = new float[]{0.0f, 1.0f};
    private float[] opacityNodes = new float[]{0.0f, 1.0f};
    private float[] colorRange = new float[]{0.0f, 1.0f};
    private float[] aabbMin = new float[]{-1.0f, -1.0f, -1.0f};
    private float[] aabbMax = new float[]{1.0f, 1.0f, 1.0f};
    private RayCastingType rayCastingType = RayCastingType.MAX_VALUE;
    private float brightness = 1.0f;
    boolean hasChanges = true;
    private float[] vertexBufferData = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f};

    public VolumeGraphic(byte[] data, int width, int height, int depth, byte[] colors) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.byteData = data;
        this.colors = colors;
        Extent3D extent = new Extent3D();
        extent.maxX = width;
        extent.maxY = height;
        extent.maxZ = depth;
        this.setExtent((Extent)extent);
    }

    public VolumeGraphic(Array value, ColorMap colorMap, double vMin, double vMax) {
        this.transferFunction.setColorMap(colorMap);
        this.data = value = value.copyIfView();
        int[] shape = value.getShape();
        this.depth = shape[0];
        this.height = shape[1];
        this.width = shape[2];
        this.byteData = new byte[this.width * this.height * this.depth];
        double range = vMax - vMin;
        int i = 0;
        while ((long)i < value.getSize()) {
            this.byteData[i] = Double.isNaN(value.getDouble(i)) ? (byte)0 : (byte)((value.getDouble(i) - vMin) / range * 255.0);
            ++i;
        }
        Color[] oColors = colorMap.getColors();
        int n = oColors.length;
        this.originalColors = new byte[n * 3];
        for (int i2 = 0; i2 < n; ++i2) {
            int color = oColors[i2].getRGB();
            this.originalColors[i2 * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i2 * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i2 * 3 + 2] = (byte)(color & 0xFF);
        }
        double[] values = MIMath.getIntervalValues((double)vMin, (double)vMax, (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme((double[])values, (Color[])oColors, (ShapeTypes)ShapeTypes.POLYGON, (double)vMin, (double)vMax);
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public VolumeGraphic(Array value, ColorMap colorMap, Normalize norm) {
        this.data = value = value.copyIfView();
        int[] shape = value.getShape();
        this.depth = shape[0];
        this.height = shape[1];
        this.width = shape[2];
        this.byteData = new byte[this.width * this.height * this.depth];
        int i = 0;
        while ((long)i < value.getSize()) {
            this.byteData[i] = Double.isNaN(value.getDouble(i)) ? (byte)0 : (byte)(norm.apply((Number)value.getDouble(i)).floatValue() * 255.0f);
            ++i;
        }
        this.setColorMap(colorMap, norm);
    }

    public VolumeGraphic(Array value, LegendScheme ls) {
        this.data = value = value.copyIfView();
        int[] shape = value.getShape();
        this.depth = shape[0];
        this.height = shape[1];
        this.width = shape[2];
        this.byteData = new byte[this.width * this.height * this.depth];
        List oColors = ls.getColors();
        int n = oColors.size();
        int i = 0;
        while ((long)i < value.getSize()) {
            this.byteData[i] = Double.isNaN(value.getDouble(i)) ? (byte)0 : (byte)((double)ls.legendBreakIndex(value.getDouble(i)) * 255.0 / (double)n);
            ++i;
        }
        this.originalColors = new byte[n * 3];
        for (i = 0; i < n; ++i) {
            int color = ((Color)oColors.get(i)).getRGB();
            this.originalColors[i * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i * 3 + 2] = (byte)(color & 0xFF);
        }
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public void setExtent(Extent value) {
        super.setExtent(value);
        Extent3D extent = (Extent3D)this.getExtent();
        float xMin = (float)extent.minX;
        float xMax = (float)extent.maxX;
        float yMin = (float)extent.minY;
        float yMax = (float)extent.maxY;
        float zMin = (float)extent.minZ;
        float zMax = (float)extent.maxZ;
        float[] p0 = new float[]{xMin, yMin, zMin};
        float[] p1 = new float[]{xMax, yMin, zMin};
        float[] p2 = new float[]{xMax, yMax, zMin};
        float[] p3 = new float[]{xMin, yMax, zMin};
        float[] p4 = new float[]{xMin, yMin, zMax};
        float[] p5 = new float[]{xMax, yMin, zMax};
        float[] p6 = new float[]{xMax, yMax, zMax};
        float[] p7 = new float[]{xMin, yMax, zMax};
        this.aabbMin = p0;
        this.aabbMax = p6;
        this.vertexBufferData = new float[]{p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p4[0], p4[1], p4[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p1[0], p1[1], p1[2], p1[0], p1[1], p1[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p4[0], p4[1], p4[2], p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p2[0], p2[1], p2[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p6[0], p6[1], p6[2]};
    }

    public void setColorMap(ColorMap colorMap) {
        this.setColorMap(colorMap, this.transferFunction.getNormalize());
    }

    public void setColorMap(ColorMap colorMap, Normalize norm) {
        this.transferFunction.setColorMap(colorMap);
        this.transferFunction.setNormalize(norm);
        Color[] oColors = colorMap.getColors();
        int n = oColors.length;
        this.originalColors = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            int color = oColors[i].getRGB();
            this.originalColors[i * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i * 3 + 2] = (byte)(color & 0xFF);
        }
        double[] values = MIMath.getIntervalValues((double)norm.getMinValue(), (double)norm.getMaxValue(), (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme((double[])values, (Color[])oColors, (ShapeTypes)ShapeTypes.POLYGON, (double)norm.getMinValue(), (double)norm.getMaxValue());
        ls.setColorMap(colorMap);
        ls.setNormalize(norm);
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public void updateColors() {
        float cRange = this.colorRange[1] - this.colorRange[0];
        float min = this.opacityLevels[0] * this.opacityLevels[0];
        float max = this.opacityLevels[1] * this.opacityLevels[1];
        float opacityNodeRange = this.opacityNodes[1] - this.opacityNodes[0];
        int n = this.originalColors.length / 3;
        this.colors = new byte[n * 4];
        for (int i = 0; i < n; ++i) {
            float px = (float)i / (float)n;
            float a = this.transferFunction.getOpacityTransferFunction().getOpacity(px);
            int colorI = 0;
            if (px > this.colorRange[1] * 255.0f) {
                colorI = 255;
            } else if (px > this.colorRange[0]) {
                colorI = Math.clamp((int)0, (int)255, (int)java.lang.Math.round(((float)i / 255.0f - this.colorRange[0]) * (1.0f / cRange) * 255.0f));
            }
            float r = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 0]) / 255.0f;
            float g = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 1]) / 255.0f;
            float b = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 2]) / 255.0f;
            r = r * r * a;
            g = g * g * a;
            b = b * b * a;
            this.colors[i * 4 + 0] = (byte)java.lang.Math.round(r * 255.0f);
            this.colors[i * 4 + 1] = (byte)java.lang.Math.round(g * 255.0f);
            this.colors[i * 4 + 2] = (byte)java.lang.Math.round(b * 255.0f);
            this.colors[i * 4 + 3] = (byte)java.lang.Math.round(a * 255.0f);
            Color color = this.legendScheme.getLegendBreak(i).getColor();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(a * 255.0f));
            this.legendScheme.getLegendBreak(i).setColor(color);
        }
    }

    public Array getData() {
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    public byte[] getNormals() {
        if (this.normals == null) {
            this.calculateNormals();
        }
        return this.normals;
    }

    public byte[] getColors() {
        return this.colors;
    }

    public void setAlphaMin(float value) {
        this.opacityNodes[0] = value;
    }

    public void setAlphaMax(float value) {
        this.opacityNodes[1] = value;
    }

    public void setOpacityTransferFunction(OpacityTransferFunction value) {
        this.transferFunction.setOpacityTransferFunction(value);
    }

    public void setOpacityTransferFunction(List<Number> opacityNodes, List<Number> opacityLevels) {
        this.transferFunction.setOpacityTransferFunction(new OpacityTransferFunction(opacityNodes, opacityLevels));
    }

    public TransferFunction getTransferFunction() {
        return this.transferFunction;
    }

    public void setTransferFunction(TransferFunction value) {
        this.transferFunction = value;
        ColorMap colorMap = this.transferFunction.getColorMap();
        Color[] oColors = colorMap.getColors();
        int n = oColors.length;
        this.originalColors = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            int color = oColors[i].getRGB();
            this.originalColors[i * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i * 3 + 2] = (byte)(color & 0xFF);
        }
        Normalize norm = this.transferFunction.getNormalize();
        double[] values = MIMath.getIntervalValues((double)norm.getMinValue(), (double)norm.getMaxValue(), (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme((double[])values, (Color[])oColors, (ShapeTypes)ShapeTypes.POLYGON, (double)norm.getMinValue(), (double)norm.getMaxValue());
        ls.setColorMap(colorMap);
        ls.setNormalize(norm);
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public float[] getScale() {
        return this.scale;
    }

    public float getScale(int i) {
        return this.scale[i];
    }

    public int getColorNum() {
        return this.colors.length / 4;
    }

    public float[] getAabbMin() {
        return this.aabbMin;
    }

    public float[] getAabbMax() {
        return this.aabbMax;
    }

    public RayCastingType getRayCastingType() {
        return this.rayCastingType;
    }

    public void setRayCastingType(RayCastingType value) {
        this.rayCastingType = value;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float value) {
        this.brightness = value;
    }

    public void setRayCastingType(String value) {
        this.rayCastingType = RayCastingType.valueOf(value.toUpperCase());
    }

    public float[] getVertexBufferData() {
        return this.vertexBufferData;
    }

    public float[] getVertexBufferData(Transform transform) {
        Extent3D extent = (Extent3D)this.getExtent();
        float xMin = (float)extent.minX;
        float xMax = (float)extent.maxX;
        float yMin = (float)extent.minY;
        float yMax = (float)extent.maxY;
        float zMin = (float)extent.minZ;
        float zMax = (float)extent.maxZ;
        float[] p0 = transform.transformArray(xMin, yMin, zMin);
        float[] p1 = transform.transformArray(xMax, yMin, zMin);
        float[] p2 = transform.transformArray(xMax, yMax, zMin);
        float[] p3 = transform.transformArray(xMin, yMax, zMin);
        float[] p4 = transform.transformArray(xMin, yMin, zMax);
        float[] p5 = transform.transformArray(xMax, yMin, zMax);
        float[] p6 = transform.transformArray(xMax, yMax, zMax);
        float[] p7 = transform.transformArray(xMin, yMax, zMax);
        this.aabbMin = p0;
        this.aabbMax = p6;
        return new float[]{p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p4[0], p4[1], p4[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p1[0], p1[1], p1[2], p1[0], p1[1], p1[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p4[0], p4[1], p4[2], p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p2[0], p2[1], p2[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p6[0], p6[1], p6[2]};
    }

    public int getVertexNumber() {
        return this.vertexBufferData.length / 3;
    }

    public void calculateNormals() {
        this.normals = new byte[this.byteData.length * 3];
        int n = this.byteData.length;
        for (int i = 0; i < n; ++i) {
            int i1 = i - 1;
            int i2 = i + 1;
            int xn = i1 < 0 || i2 >= n ? 0 : this.byteData[i1] - this.byteData[i2];
            this.normals[i * 3] = (byte)(xn + 128);
            i1 = i - this.width;
            i2 = i + this.width;
            int yn = i1 < 0 || i2 >= n ? 0 : this.byteData[i1] - this.byteData[i2];
            this.normals[i * 3 + 1] = (byte)(yn + 128);
            i1 = i - this.width * this.height;
            i2 = i + this.width * this.height;
            int zn = i1 < 0 || i2 >= n ? 0 : this.byteData[i1] - this.byteData[i2];
            this.normals[i * 3 + 2] = (byte)(zn + 128);
        }
    }
}

