/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic.pipe;

import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Line {
    private Vector3f direction;
    private Vector3f point;

    public Line() {
        this.direction = new Vector3f();
        this.point = new Vector3f();
    }

    public Line(float slope, float intercept) {
        this.set(slope, intercept);
    }

    public Line(Vector3f direction, Vector3f point) {
        this.set(direction, point);
    }

    void set(Vector3f v, Vector3f p) {
        this.direction = v;
        this.point = p;
    }

    void set(Vector2f v, Vector2f p) {
        this.direction = new Vector3f(v.x, v.y, 0.0f);
        this.point = new Vector3f(p.x, p.y, 0.0f);
    }

    void set(float slope, float intercept) {
        this.direction = new Vector3f(1.0f, slope, 0.0f);
        this.point = new Vector3f(0.0f, intercept, 0.0f);
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Vector3f getPoint() {
        return this.point;
    }

    public Vector3f intersect(Line line) {
        Vector3f v2 = line.getDirection();
        Vector3f p2 = line.getPoint();
        Vector3f result = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
        Vector3f v3 = p2.sub((Vector3fc)this.point, new Vector3f()).cross((Vector3fc)v2, new Vector3f());
        Vector3f v4 = this.direction.cross((Vector3fc)v2, new Vector3f());
        float dot = v4.dot((Vector3fc)v4);
        if (dot == 0.0f) {
            return result;
        }
        float alpha = v3.dot((Vector3fc)v4) / dot;
        result = this.point.add((Vector3fc)this.direction.mul(alpha, new Vector3f()));
        return result;
    }

    public boolean isIntersected(Line line) {
        Vector3f v = this.direction.cross((Vector3fc)line.getDirection(), new Vector3f());
        return v.x != 0.0f || v.y != 0.0f || v.z != 0.0f;
    }
}

