/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.ChartColorBar;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartText3D;
import org.meteoinfo.chart.GLChartPanel;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.graphic.IsosurfaceGraphics;
import org.meteoinfo.chart.graphic.MeshGraphic;
import org.meteoinfo.chart.graphic.Model;
import org.meteoinfo.chart.graphic.ParticleGraphics;
import org.meteoinfo.chart.graphic.TriMeshGraphic;
import org.meteoinfo.chart.graphic.VolumeGraphic;
import org.meteoinfo.chart.graphic.pipe.Pipe;
import org.meteoinfo.chart.graphic.pipe.PipeShape;
import org.meteoinfo.chart.jogl.JOGLUtil;
import org.meteoinfo.chart.jogl.Lighting;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.jogl.ZAxisOption;
import org.meteoinfo.chart.jogl.tessellator.Primitive;
import org.meteoinfo.chart.jogl.tessellator.TessPolygon;
import org.meteoinfo.chart.plot.GridLine;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.chart.render.jogl.LineRender;
import org.meteoinfo.chart.render.jogl.MeshRender;
import org.meteoinfo.chart.render.jogl.ModelRender;
import org.meteoinfo.chart.render.jogl.PipeRender;
import org.meteoinfo.chart.render.jogl.PointRender;
import org.meteoinfo.chart.render.jogl.QuiverRender;
import org.meteoinfo.chart.render.jogl.TriMeshRender;
import org.meteoinfo.chart.render.jogl.VolumeRender;
import org.meteoinfo.chart.shape.TextureShape;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.geometry.colors.BoundaryNorm;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.BarBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.CubicShape;
import org.meteoinfo.geometry.shape.CylinderShape;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonZ;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.render.java2d.Draw;
import org.meteoinfo.render.java2d.StringType;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class GLPlot
extends Plot {
    protected ProjectionInfo projInfo = null;
    protected boolean sampleBuffers = false;
    protected Color background = Color.white;
    protected boolean doScreenShot = false;
    protected BufferedImage screenImage;
    protected GL2 gl;
    protected GLU glu = new GLU();
    protected final GLUT glut = new GLUT();
    protected int startList = 2;
    protected GraphicCollection3D graphics;
    protected Extent3D graphicExtent;
    protected Extent3D drawExtent;
    protected Extent3D axesExtent;
    protected boolean fixExtent;
    protected TextRenderer textRenderer;
    protected ChartText title;
    protected GridLine gridLine;
    protected List<ChartLegend> legends;
    protected final Axis xAxis;
    protected final Axis yAxis;
    protected final Axis zAxis;
    protected List<ZAxisOption> zAxisLocations;
    protected Transform transform = new Transform();
    protected boolean clipPlane = true;
    protected boolean axesZoom = false;
    protected Color boxColor = Color.lightGray;
    protected boolean boxed;
    protected boolean mesh;
    protected boolean scaleBox;
    protected boolean displayXY;
    protected boolean displayZ;
    protected boolean drawBoundingBox;
    protected boolean hideOnDrag;
    protected boolean drawBase;
    protected int[] viewport = new int[4];
    protected float[] mvmatrix = new float[16];
    protected float[] projmatrix = new float[16];
    protected Matrix4f modelViewMatrix = new Matrix4f();
    protected Matrix4f projectionMatrix = new Matrix4f();
    protected Matrix4f viewProjMatrix = new Matrix4f();
    protected Matrix4f modelViewMatrixR = new Matrix4f();
    protected float angleX;
    protected float angleY;
    protected float headAngle;
    protected float pitchAngle;
    protected AspectType aspectType = AspectType.AUTO;
    protected TessCallback tessCallback;
    protected int width;
    protected int height;
    protected float tickSpace = 5.0f;
    protected final float lenScale = 0.01f;
    protected Lighting lighting = new Lighting();
    protected boolean antialias;
    protected float dpiScale;
    protected boolean orthographic;
    protected float distance;
    protected float fieldOfView;
    protected GLAutoDrawable drawable;
    protected Map<Graphic, JOGLGraphicRender> renderMap = new HashMap<Graphic, JOGLGraphicRender>();
    protected boolean alwaysUpdateBuffers = false;

    public GLPlot() {
        this.legends = new ArrayList<ChartLegend>();
        this.xAxis = new Axis();
        this.xAxis.setTickLength(8.0f);
        this.yAxis = new Axis();
        this.yAxis.setTickLength(8.0f);
        this.zAxis = new Axis();
        this.zAxis.setTickLength(8.0f);
        this.zAxisLocations = new ArrayList<ZAxisOption>();
        this.fixExtent = false;
        this.graphics = new GraphicCollection3D();
        this.hideOnDrag = false;
        this.boxed = true;
        this.gridLine = new GridLine(true);
        this.drawBase = true;
        this.displayXY = true;
        this.displayZ = true;
        this.drawBoundingBox = false;
        this.antialias = false;
        this.dpiScale = 1.0f;
        this.orthographic = true;
        this.distance = 5.0f;
        this.fieldOfView = 45.0f;
        this.initAngles();
        this.graphicExtent = new Extent3D();
        Extent3D extent3D = new Extent3D(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        this.drawExtent = (Extent3D)extent3D.clone();
        this.transform.setExtent(this.drawExtent);
        this.setAxesExtent((Extent3D)this.drawExtent.clone());
    }

    public void initAngles() {
        this.angleX = -45.0f;
        this.angleY = 45.0f;
        this.headAngle = 0.0f;
        this.pitchAngle = 0.0f;
    }

    public ProjectionInfo getProjInfo() {
        return this.projInfo;
    }

    public void setProjInfo(ProjectionInfo value) {
        this.projInfo = value;
    }

    public boolean isSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setSampleBuffers(boolean value) {
        this.sampleBuffers = value;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
        if (this.background == Color.black) {
            this.setForeground(Color.white);
        }
    }

    public void setForeground(Color value) {
        this.boxColor = value;
        this.gridLine.setColor(value);
        this.xAxis.setColor_All(value);
        this.yAxis.setColor_All(value);
        this.zAxis.setColor_All(value);
    }

    public GraphicCollection3D getGraphics() {
        return this.graphics;
    }

    public void setGraphics(GraphicCollection3D value) {
        this.graphics = value;
    }

    public int getGraphicNumber() {
        return this.graphics.size();
    }

    public boolean isDoScreenShot() {
        return this.doScreenShot;
    }

    public void setDoScreenShot(boolean value) {
        this.doScreenShot = value;
    }

    public BufferedImage getScreenImage() {
        return this.screenImage;
    }

    public Extent3D getGraphicExtent() {
        return this.graphicExtent;
    }

    @Override
    public Extent getExtent() {
        return this.graphicExtent;
    }

    public Extent3D getDrawExtent() {
        return this.drawExtent;
    }

    @Override
    public void setDrawExtent(Extent extent) {
        this.drawExtent = (Extent3D)extent;
        this.transform.setExtent(this.drawExtent);
        if (!this.axesZoom) {
            this.setAxesExtent((Extent3D)this.drawExtent.clone());
        }
    }

    public Extent3D getAxesExtent() {
        return this.axesExtent;
    }

    public void setAxesExtent(Extent3D value) {
        this.axesExtent = value;
        this.xAxis.setMinMaxValue(this.axesExtent.minX, this.axesExtent.maxX);
        this.yAxis.setMinMaxValue(this.axesExtent.minY, this.axesExtent.maxY);
        this.zAxis.setMinMaxValue(this.axesExtent.minZ, this.axesExtent.maxZ);
    }

    public boolean isFixExtent() {
        return this.fixExtent;
    }

    public void setFixExtent(boolean value) {
        this.fixExtent = value;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isClipPlane() {
        return this.clipPlane;
    }

    public void setClipPlane(boolean value) {
        this.clipPlane = value;
    }

    public boolean isAxesZoom() {
        return this.axesZoom;
    }

    public void setAxesZoom(boolean value) {
        this.axesZoom = value;
        if (this.axesZoom) {
            this.clipPlane = false;
        }
    }

    public float getAspectRatio() {
        return (float)this.width / (float)this.height;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setBoxColor(Color value) {
        this.boxColor = value;
    }

    public boolean isDrawBase() {
        return this.drawBase;
    }

    public void setDrawBase(boolean value) {
        this.drawBase = value;
    }

    public boolean isDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public void setDrawBoundingBox(boolean value) {
        this.drawBoundingBox = value;
    }

    public void setDisplayXY(boolean value) {
        this.displayXY = value;
    }

    public void setDisplayZ(boolean value) {
        this.displayZ = value;
    }

    public GridLine getGridLine() {
        return this.gridLine;
    }

    public void setBoxed(boolean value) {
        this.boxed = value;
    }

    public float getAngleX() {
        return this.angleX;
    }

    public void setAngleX(float value) {
        this.angleX = value;
    }

    public float getAngleY() {
        return this.angleY;
    }

    public void setAngleY(float value) {
        this.angleY = value;
    }

    public float getHeadAngle() {
        return this.headAngle;
    }

    public void setHeadAngle(float value) {
        this.headAngle = value;
    }

    public float getPitchAngle() {
        return this.pitchAngle;
    }

    public void setPitchAngle(float value) {
        this.pitchAngle = value;
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public void setTitle(String text) {
        if (this.title == null) {
            this.title = new ChartText(text);
        } else {
            this.title.setText(text);
        }
    }

    public List<ChartLegend> getLegends() {
        return this.legends;
    }

    public ChartLegend getLegend(int idx) {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(idx);
    }

    public ChartLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(this.legends.size() - 1);
    }

    public void setLegend(ChartLegend value) {
        this.legends.clear();
        this.legends.add(value);
    }

    public void setLegends(List<ChartLegend> value) {
        this.legends = value;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public Axis getZAxis() {
        return this.zAxis;
    }

    public AspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(AspectType value) {
        this.aspectType = value;
        this.transform.setAspectType(this.aspectType);
    }

    public float getZScale() {
        return this.transform.getZScale();
    }

    public void setZScale(float value) {
        this.transform.zScale = value;
    }

    public float getXMin() {
        return (float)this.drawExtent.minX;
    }

    public void setXMin(float value) {
        this.drawExtent.minX = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.drawExtent.minX, this.drawExtent.maxX);
    }

    public float getXMax() {
        return (float)this.drawExtent.maxX;
    }

    public void setXMax(float value) {
        this.drawExtent.maxX = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.drawExtent.minX, this.drawExtent.maxX);
    }

    public void setXMinMax(float min, float max) {
        this.drawExtent.minX = min;
        this.drawExtent.maxX = max;
        this.updateExtent();
        this.xAxis.setMinMaxValue(min, max);
        this.fixExtent = true;
    }

    public float getYMin() {
        return (float)this.drawExtent.minY;
    }

    public void setYMin(float value) {
        this.drawExtent.minY = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.drawExtent.minY, this.drawExtent.maxY);
    }

    public float getYMax() {
        return (float)this.drawExtent.maxY;
    }

    public void setYMax(float value) {
        this.drawExtent.maxY = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.drawExtent.minY, this.drawExtent.maxY);
    }

    public void setYMinMax(float min, float max) {
        this.drawExtent.minY = min;
        this.drawExtent.maxY = max;
        this.updateExtent();
        this.yAxis.setMinMaxValue(min, max);
        this.fixExtent = true;
    }

    public float getZMin() {
        return (float)this.drawExtent.minZ;
    }

    public void setZMin(float value) {
        this.drawExtent.minZ = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.drawExtent.minZ, this.drawExtent.maxZ);
    }

    public float getZMax() {
        return (float)this.drawExtent.maxZ;
    }

    public void setZMax(float value) {
        this.drawExtent.maxZ = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.drawExtent.minZ, this.drawExtent.maxZ);
    }

    public void setZMinMax(float min, float max) {
        this.drawExtent.minZ = min;
        this.drawExtent.maxZ = max;
        this.updateExtent();
        this.zAxis.setMinMaxValue(min, max);
        this.fixExtent = true;
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public void setLighting(Lighting value) {
        this.lighting = value;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    public float getDpiScale() {
        return this.dpiScale;
    }

    public void setDpiScale(float value) {
        this.dpiScale = value;
    }

    public boolean isAlwaysUpdateBuffers() {
        return this.alwaysUpdateBuffers;
    }

    public void setAlwaysUpdateBuffers(boolean value) {
        this.alwaysUpdateBuffers = value;
    }

    public boolean isOrthographic() {
        return this.orthographic;
    }

    public void setOrthographic(boolean value) {
        this.orthographic = value;
        if (this.drawable != null) {
            this.drawable.invoke(true, new GLRunnable(){

                public boolean run(GLAutoDrawable drawable) {
                    GLPlot.this.updateProjections(drawable);
                    return false;
                }
            });
        }
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float value) {
        this.distance = value;
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(float value) {
        this.fieldOfView = value;
    }

    public void addLegend(ChartLegend legend) {
        this.legends.clear();
        this.legends.add(legend);
    }

    public void removeLegend(ChartLegend legend) {
        this.legends.remove((Object)legend);
    }

    public void removeLegend(int idx) {
        this.legends.remove(idx);
    }

    @Override
    public Rectangle2D getOuterPositionArea(Rectangle2D area) {
        Rectangle2D rect = this.getOuterPosition();
        double x = area.getWidth() * rect.getX() + area.getX();
        double y = area.getHeight() * (1.0 - rect.getHeight() - rect.getY()) + area.getY();
        double w = area.getWidth() * rect.getWidth();
        double h = area.getHeight() * rect.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XYZ;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
    }

    protected void updateExtent() {
        this.transform.setExtent(this.drawExtent);
        this.setAxesExtent((Extent3D)this.drawExtent.clone());
    }

    public void setAxisTickFont(Font font) {
        this.xAxis.setTickLabelFont(font);
        this.yAxis.setTickLabelFont(font);
        this.zAxis.setTickLabelFont(font);
    }

    public void addGraphic(Graphic graphic) {
        graphic.doTransform();
        this.graphics.add(graphic);
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        ex.asNonZero();
        this.graphicExtent = (Extent3D)ex;
        if (!this.fixExtent) {
            this.setAxesExtent((Extent3D)this.graphicExtent.clone());
            this.setDrawExtent((Extent)((Extent3D)this.graphicExtent.clone()));
        }
    }

    public void addGraphic(int index, Graphic graphic) {
        graphic.doTransform();
        this.graphics.add(index, graphic);
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        ex.asNonZero();
        this.graphicExtent = (Extent3D)ex;
        if (!this.fixExtent) {
            this.setAxesExtent((Extent3D)this.graphicExtent.clone());
            this.setDrawExtent((Extent)((Extent3D)this.graphicExtent.clone()));
        }
    }

    public void addGraphic(Graphic graphic, ProjectionInfo proj) {
        if (this.projInfo == null || proj.equals(this.projInfo)) {
            this.addGraphic(graphic);
        } else {
            Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphic, (ProjectionInfo)proj, (ProjectionInfo)this.projInfo);
            this.addGraphic(nGraphic);
        }
    }

    public void addGraphic(int index, Graphic graphic, ProjectionInfo proj) {
        if (this.projInfo == null || proj.equals(this.projInfo)) {
            this.addGraphic(index, graphic);
        } else {
            Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphic, (ProjectionInfo)proj, (ProjectionInfo)this.projInfo);
            this.addGraphic(index, nGraphic);
        }
    }

    public void removeGraphic(Graphic graphic) {
        if (this.graphics.contains(graphic)) {
            this.graphics.remove(graphic);
            if (this.renderMap.containsKey(graphic)) {
                this.renderMap.remove(graphic);
            }
        }
    }

    public void removeGraphic(int idx) {
        this.graphics.remove(this.graphics.get(idx));
    }

    public void removeLastGraphic() {
        this.graphics.remove(this.graphics.size() - 1);
    }

    public void removeAllGraphics() {
        this.graphics.clear();
        this.renderMap.clear();
    }

    public void setAutoExtent() {
    }

    public void addZAxis(float x, float y, boolean left) {
        this.zAxisLocations.add(new ZAxisOption(x, y, left));
    }

    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glLoadIdentity();
        float[] rgba = this.background.getRGBComponents(null);
        gl.glClearColor(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glClear(17664);
        this.updateTextRender(this.xAxis.getTickLabelFont());
        this.lighting.setPosition(gl);
        gl.glPushMatrix();
        this.modelViewMatrix = new Matrix4f();
        this.modelViewMatrix.rotate((float)Math.toRadians(this.angleX), 1.0f, 0.0f, 0.0f);
        this.modelViewMatrix.rotate((float)Math.toRadians(this.angleY), 0.0f, 0.0f, 1.0f);
        if (this.headAngle != 0.0f) {
            this.modelViewMatrix.rotate((float)Math.toRadians(this.headAngle), 0.0f, 1.0f, 0.0f);
        }
        this.modelViewMatrixR = new Matrix4f((Matrix4fc)this.modelViewMatrix);
        Vector3f center = this.transform.getCenter();
        Vector3f scale = this.transform.getScale();
        this.modelViewMatrix.scale((Vector3fc)scale);
        this.modelViewMatrix.translate((Vector3fc)center.negate());
        FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
        gl.glLoadMatrixf(this.modelViewMatrix.get(fb));
        this.updateMatrix(gl);
        if (this.drawBase) {
            this.drawBase(gl);
        }
        if (this.boxed) {
            this.drawBox(gl);
        }
        if (this.clipPlane) {
            this.enableClipPlane(gl);
        }
        this.drawGridLine(gl);
        this.setLight(gl);
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            Graphic graphic = this.graphics.get(m);
            this.drawGraphics(gl, graphic);
        }
        if (this.clipPlane) {
            this.disableClipPlane(gl);
        }
        if (this.lighting.isEnable()) {
            this.lighting.stop(gl);
        }
        if (this.drawBoundingBox) {
            this.drawBoundingBox(gl);
        }
        this.drawAxis(gl);
        this.drawAllZAxis(gl);
        gl.glPopMatrix();
        this.updateMatrix(gl);
        if (!this.legends.isEmpty()) {
            ChartColorBar legend = (ChartColorBar)this.legends.get(0);
            this.updateTextRender(legend.getTickLabelFont());
            if (legend.getLegendScheme().getColorMap() == null) {
                this.drawLegend(gl, legend);
            } else {
                this.drawColorbar(gl, legend);
            }
        }
        this.drawTitle();
        this.textRenderer.dispose();
        this.textRenderer = null;
        gl.glFlush();
        if (this.alwaysUpdateBuffers) {
            this.alwaysUpdateBuffers = false;
        }
    }

    private void disableClipPlane(GL2 gl) {
        gl.glDisable(12288);
        gl.glDisable(12289);
        gl.glDisable(12290);
        gl.glDisable(12291);
        gl.glDisable(12292);
        gl.glDisable(12293);
    }

    private void enableClipPlane(GL2 gl) {
        float xMin = (float)this.axesExtent.minX - (float)this.axesExtent.getWidth() * 0.001f;
        float xMax = (float)this.axesExtent.maxX + (float)this.axesExtent.getWidth() * 0.001f;
        float yMin = (float)this.axesExtent.minY - (float)this.axesExtent.getHeight() * 0.001f;
        float yMax = (float)this.axesExtent.maxY + (float)this.axesExtent.getHeight() * 0.001f;
        float zMin = (float)this.axesExtent.minZ - (float)this.axesExtent.getZLength() * 0.001f;
        float zMax = (float)this.axesExtent.maxZ + (float)this.axesExtent.getZLength() * 0.001f;
        gl.glClipPlane(12288, new double[]{-1.0, 0.0, 0.0, xMax}, 0);
        gl.glEnable(12288);
        gl.glClipPlane(12289, new double[]{1.0, 0.0, 0.0, -xMin}, 0);
        gl.glEnable(12289);
        gl.glClipPlane(12290, new double[]{0.0, -1.0, 0.0, yMax}, 0);
        gl.glEnable(12290);
        gl.glClipPlane(12291, new double[]{0.0, 1.0, 0.0, -yMin}, 0);
        gl.glEnable(12291);
        gl.glClipPlane(12292, new double[]{0.0, 0.0, -1.0, zMax}, 0);
        gl.glEnable(12292);
        gl.glClipPlane(12293, new double[]{0.0, 0.0, 1.0, -zMin}, 0);
        gl.glEnable(12293);
    }

    protected void setLight(GL2 gl) {
        if (this.lighting.isEnable()) {
            this.lighting.start(gl);
            gl.glColorMaterial(1032, 5634);
            gl.glEnable(2903);
            gl.glLightModeli(2898, 1);
            gl.glEnable(2977);
        }
    }

    private void setCamera(GL2 gl, GLU glu, float distance) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        float widthHeightRatio = (float)this.viewport[2] / (float)this.viewport[3];
        glu.gluPerspective(45.0f, widthHeightRatio, 1.0f, 1000.0f);
        glu.gluLookAt(0.0f, 0.0f, distance, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    protected void drawBase(GL2 gl) {
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float[] rgba = this.gridLine.getColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
        gl.glBegin(3);
        gl.glVertex3f(xMin, yMax, zMin);
        gl.glVertex3f(xMin, yMin, zMin);
        gl.glVertex3f(xMax, yMin, zMin);
        gl.glVertex3f(xMax, yMax, zMin);
        gl.glVertex3f(xMin, yMax, zMin);
        gl.glEnd();
    }

    protected Matrix4f toMatrix(float[] data) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.set(data);
        return matrix4f;
    }

    protected void updateMatrix(GL2 gl) {
        gl.glGetIntegerv(2978, this.viewport, 0);
        gl.glGetFloatv(2982, this.mvmatrix, 0);
        gl.glGetFloatv(2983, this.projmatrix, 0);
        this.modelViewMatrix = this.toMatrix(this.mvmatrix);
        this.projectionMatrix = this.toMatrix(this.projmatrix);
        this.viewProjMatrix = this.projectionMatrix.mul((Matrix4fc)this.modelViewMatrix);
    }

    public Vector3f unProject(float x, float y) {
        if (this.gl == null) {
            return new Vector3f();
        }
        y = (float)this.viewport[3] - y;
        FloatBuffer buffer = FloatBuffer.allocate(4);
        this.gl.glReadPixels((int)x, (int)y, 1, 1, 6402, 5126, (Buffer)buffer);
        float z = buffer.get();
        float[] out = new float[4];
        this.glu.gluUnProject(x, y, z, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, out, 0);
        return new Vector3f(out[0], out[1], out[2]);
    }

    public Vector3f unProject(float x, float y, GL2 gl) {
        y = (float)this.viewport[3] - y;
        FloatBuffer buffer = FloatBuffer.allocate(4);
        gl.glReadPixels((int)x, (int)y, 1, 1, 6402, 5126, (Buffer)buffer);
        float z = buffer.get();
        float[] out = new float[4];
        this.glu.gluUnProject(x, y, z, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, out, 0);
        return new Vector3f(out[0], out[1], out[2]);
    }

    protected Vector2f toScreen(float vx, float vy, float vz) {
        float[] coord = new float[4];
        this.glu.gluProject(vx, vy, vz, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, coord, 0);
        if (this.viewport[0] != 0) {
            coord[0] = coord[0] - (float)this.viewport[0];
        }
        if (this.viewport[1] != 0) {
            coord[1] = coord[1] - (float)this.viewport[1];
        }
        return new Vector2f(coord[0], coord[1]);
    }

    protected float toScreenLength(float x1, float y1, float z1, float x2, float y2, float z2) {
        Vector2f coord = this.toScreen(x1, y1, z1);
        float sx1 = coord.x;
        float sy1 = coord.y;
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord.x;
        float sy2 = coord.y;
        return (float)Math.sqrt(Math.pow(sx2 - sx1, 2.0) + Math.pow(sy2 - sy1, 2.0));
    }

    protected float toScreenAngle(float x1, float y1, float z1, float x2, float y2, float z2) {
        Vector2f coord = this.toScreen(x1, y1, z1);
        float sx1 = coord.x;
        float sy1 = coord.y;
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord.x;
        float sy2 = coord.y;
        return (float)MeteoMath.uv2ds((double)(sx2 - sx1), (double)(sy2 - sy1))[0];
    }

    protected int getLabelGap(Font font, List<ChartText> labels, double len) {
        TextRenderer textRenderer = new TextRenderer(font);
        int n = labels.size();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    protected int getLegendTickGap(ChartColorBar legend, double len) {
        if (legend.getTickLabelAngle() != 0.0f) {
            return 1;
        }
        Font font = legend.getTickLabelFont();
        if (this.dpiScale != 1.0f) {
            font = new Font(font.getFontName(), font.getStyle(), (int)((float)font.getSize() * this.dpiScale));
        }
        TextRenderer textRenderer = new TextRenderer(font);
        int n = legend.getLegendScheme().getBreakNum();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    protected void drawBox(GL2 gl) {
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        float[] rgba = this.gridLine.getColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
        if (this.angleY >= 180.0f && this.angleY < 360.0f) {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glVertex3f(xMin, yMin, zMax);
            gl.glVertex3f(xMin, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glEnd();
        } else {
            gl.glBegin(3);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glVertex3f(xMax, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMax);
            gl.glVertex3f(xMax, yMax, zMax);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glEnd();
        }
        if (this.angleY >= 90.0f && this.angleY < 270.0f) {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMax);
            gl.glVertex3f(xMin, yMin, zMax);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glEnd();
        } else {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glVertex3f(xMax, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glEnd();
        }
    }

    protected void drawBoundingBox(GL2 gl) {
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        float[] rgba = this.gridLine.getColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
        if (this.angleY >= 180.0f && this.angleY < 360.0f) {
            gl.glBegin(3);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glVertex3f(xMax, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMax);
            gl.glVertex3f(xMax, yMax, zMax);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glEnd();
        } else {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glVertex3f(xMin, yMin, zMax);
            gl.glVertex3f(xMin, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glEnd();
        }
        if (this.angleY >= 90.0f && this.angleY < 270.0f) {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glVertex3f(xMax, yMax, zMin);
            gl.glVertex3f(xMax, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMax);
            gl.glVertex3f(xMin, yMax, zMin);
            gl.glEnd();
        } else {
            gl.glBegin(3);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMin);
            gl.glVertex3f(xMax, yMin, zMax);
            gl.glVertex3f(xMin, yMin, zMax);
            gl.glVertex3f(xMin, yMin, zMin);
            gl.glEnd();
        }
    }

    protected void drawXYGridLine(GL2 gl) {
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        if (this.displayXY) {
            float x1;
            float x;
            float[] rgba;
            float v;
            int i;
            float y1;
            float y;
            if (this.angleY >= 90.0f && this.angleY < 270.0f) {
                y = yMax;
                y1 = yMin;
            } else {
                y = yMin;
                y1 = yMax;
            }
            this.xAxis.updateTickLabels();
            List<ChartText> tlabs = this.xAxis.getTickLabels();
            float axisLen = this.toScreenLength(xMin, y, zMin, xMax, y, zMin);
            int skip = this.getLabelGap(this.xAxis.getTickLabelFont(), tlabs, axisLen);
            for (i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                v = (float)this.xAxis.getTickValues()[i];
                if ((double)v <= this.axesExtent.minX || (double)v >= this.axesExtent.maxX) continue;
                if (i == tlabs.size()) break;
                if (!this.gridLine.isDrawXLine()) continue;
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(v, y, zMin);
                gl.glVertex3f(v, y1, zMin);
                gl.glEnd();
                if (!this.displayZ || !this.boxed) continue;
                gl.glBegin(1);
                gl.glVertex3f(v, y1, zMin);
                gl.glVertex3f(v, y1, zMax);
                gl.glEnd();
            }
            if (this.angleY >= 180.0f && this.angleY < 360.0f) {
                x = xMax;
                x1 = xMin;
            } else {
                x = xMin;
                x1 = xMax;
            }
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            axisLen = this.toScreenLength(x, yMin, zMin, x, yMax, zMin);
            skip = this.getLabelGap(this.yAxis.getTickLabelFont(), tlabs, axisLen);
            for (i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                v = (float)this.yAxis.getTickValues()[i];
                if ((double)v <= this.axesExtent.minY || (double)v >= this.axesExtent.maxY) continue;
                if (i == tlabs.size()) break;
                if (!this.gridLine.isDrawYLine()) continue;
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, v, zMin);
                gl.glVertex3f(x1, v, zMin);
                gl.glEnd();
                if (!this.displayZ || !this.boxed) continue;
                gl.glBegin(1);
                gl.glVertex3f(x1, v, zMin);
                gl.glVertex3f(x1, v, zMax);
                gl.glEnd();
            }
        }
    }

    protected void drawZGridLine(GL2 gl) {
        float y1;
        float y;
        float x1;
        float x;
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        if (this.angleY < 90.0f) {
            x = xMin;
            x1 = xMax;
            y = yMax;
            y1 = yMin;
        } else if (this.angleY < 180.0f) {
            x = xMax;
            x1 = xMin;
            y = yMax;
            y1 = yMin;
        } else if (this.angleY < 270.0f) {
            x = xMax;
            x1 = xMin;
            y = yMin;
            y1 = yMax;
        } else {
            x = xMin;
            x1 = xMax;
            y = yMin;
            y1 = yMax;
        }
        this.zAxis.updateTickLabels();
        List<ChartText> tlabs = this.zAxis.getTickLabels();
        float axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
        int skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
        for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
            float v = (float)this.zAxis.getTickValues()[i];
            if ((double)v <= this.axesExtent.minZ || (double)v >= this.axesExtent.maxZ) continue;
            if (i == tlabs.size()) break;
            if (!this.gridLine.isDrawZLine() || !this.boxed) continue;
            float[] rgba = this.gridLine.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
            gl.glBegin(3);
            gl.glVertex3f(x, y, v);
            if (x < x1) {
                if (y > y1) {
                    gl.glVertex3f(x1, y, v);
                    gl.glVertex3f(x1, y1, v);
                } else {
                    gl.glVertex3f(x, y1, v);
                    gl.glVertex3f(x1, y1, v);
                }
            } else if (y > y1) {
                gl.glVertex3f(x, y1, v);
                gl.glVertex3f(x1, y1, v);
            } else {
                gl.glVertex3f(x1, y, v);
                gl.glVertex3f(x1, y1, v);
            }
            gl.glEnd();
        }
    }

    protected void drawGridLine(GL2 gl) {
        if (this.displayXY) {
            this.drawXYGridLine(gl);
        }
        if (this.displayZ) {
            this.drawZGridLine(gl);
        }
    }

    protected void drawBoxGrids(GL2 gl) {
        if (this.drawBase) {
            this.drawBase(gl);
        }
        if (this.boxed) {
            this.drawBox(gl);
        }
        this.drawGridLine(gl);
    }

    protected void drawAxis(GL2 gl) {
        float xMin = (float)this.axesExtent.minX;
        float xMax = (float)this.axesExtent.maxX;
        float yMin = (float)this.axesExtent.minY;
        float yMax = (float)this.axesExtent.maxY;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        gl.glDepthFunc(519);
        Vector3f center = this.transform.getCenter();
        if (this.displayXY) {
            float yShift;
            float angle;
            Rectangle2D rect;
            float v;
            int i;
            float strHeight;
            float strWidth;
            YAlign yAlign;
            XAlign xAlign;
            int skip;
            float axisLen;
            float y = this.angleY >= 90.0f && this.angleY < 270.0f ? yMax : yMin;
            float[] rgba = this.xAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(xMin, y, zMin);
            gl.glVertex3f(xMax, y, zMin);
            gl.glEnd();
            float tickLen = this.xAxis.getTickLength() * this.lenScale * this.transform.getYLength() / 2.0f;
            this.xAxis.updateTickLabels();
            List<ChartText> tlabs = this.xAxis.getTickLabels();
            if (tlabs.size() > 0) {
                ChartText label;
                axisLen = this.toScreenLength(xMin, y, zMin, xMax, y, zMin);
                skip = this.getLabelGap(this.xAxis.getTickLabelFont(), tlabs, axisLen);
                float y1 = y > center.y ? y + tickLen : y - tickLen;
                xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.LEFT : XAlign.RIGHT;
                yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
                strWidth = 0.0f;
                strHeight = 0.0f;
                if (this.xAxis.isDrawTickLabel()) {
                    this.updateTextRender(tlabs.get(0).getFont());
                }
                for (i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                    v = (float)this.xAxis.getTickValues()[i];
                    if ((double)v < this.axesExtent.minX || (double)v > this.axesExtent.maxX) continue;
                    if (i == tlabs.size()) break;
                    rgba = this.xAxis.getLineColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
                    gl.glBegin(1);
                    gl.glVertex3f(v, y, zMin);
                    gl.glVertex3f(v, y1, zMin);
                    gl.glEnd();
                    if (!this.xAxis.isDrawTickLabel()) continue;
                    rect = this.drawString(gl, tlabs.get(i), v, y1, zMin, xAlign, yAlign);
                    if ((double)strWidth < rect.getWidth()) {
                        strWidth = (float)rect.getWidth();
                    }
                    if (!((double)strHeight < rect.getHeight())) continue;
                    strHeight = (float)rect.getHeight();
                }
                if (this.xAxis.isDrawLabel() && (label = this.xAxis.getLabel()) != null) {
                    this.updateTextRender(label.getFont());
                    angle = this.toScreenAngle(xMin, y, zMin, xMax, y, zMin);
                    angle = y < center.y ? 270.0f - angle : 90.0f - angle;
                    yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                    if (this.angleX <= -120.0f) {
                        yShift = -yShift;
                    }
                    float x1 = (xMin + xMax) / 2.0f;
                    this.drawString(gl, label, x1, y1, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
                }
            }
            float x = this.angleY >= 180.0f && this.angleY < 360.0f ? xMax : xMin;
            rgba = this.yAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x, yMin, zMin);
            gl.glVertex3f(x, yMax, zMin);
            gl.glEnd();
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            if (tlabs.size() > 0) {
                ChartText label;
                axisLen = this.toScreenLength(x, yMin, zMin, x, yMax, zMin);
                skip = this.getLabelGap(this.yAxis.getTickLabelFont(), tlabs, axisLen);
                tickLen = this.yAxis.getTickLength() * this.lenScale * this.transform.getXLength() / 2.0f;
                float x1 = x > center.x ? x + tickLen : x - tickLen;
                xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.RIGHT : XAlign.LEFT;
                yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
                strWidth = 0.0f;
                strHeight = 0.0f;
                if (this.yAxis.isDrawTickLabel()) {
                    this.updateTextRender(tlabs.get(0).getFont());
                }
                for (i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                    v = (float)this.yAxis.getTickValues()[i];
                    if ((double)v < this.axesExtent.minY || (double)v > this.axesExtent.maxY) continue;
                    if (i == tlabs.size()) break;
                    rgba = this.yAxis.getLineColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
                    gl.glBegin(1);
                    gl.glVertex3f(x, v, zMin);
                    gl.glVertex3f(x1, v, zMin);
                    gl.glEnd();
                    if (!this.yAxis.isDrawTickLabel()) continue;
                    rect = this.drawString(gl, tlabs.get(i), x1, v, zMin, xAlign, yAlign);
                    if ((double)strWidth < rect.getWidth()) {
                        strWidth = (float)rect.getWidth();
                    }
                    if (!((double)strHeight < rect.getHeight())) continue;
                    strHeight = (float)rect.getHeight();
                }
                if (this.yAxis.isDrawLabel() && (label = this.yAxis.getLabel()) != null) {
                    this.updateTextRender(label.getFont());
                    angle = this.toScreenAngle(x, yMin, zMin, x, yMax, zMin);
                    angle = x > center.x ? 270.0f - angle : 90.0f - angle;
                    yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                    if (this.angleX <= -120.0f) {
                        yShift = -yShift;
                    }
                    float y1 = (yMin + yMax) / 2.0f;
                    this.drawString(gl, label, x1, y1, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
                }
            }
        }
        if (this.displayZ) {
            PointF loc = new PointF();
            loc = this.angleY < 90.0f ? new PointF((float)this.axesExtent.minX, (float)this.axesExtent.maxY) : (this.angleY < 180.0f ? new PointF((float)this.axesExtent.maxX, (float)this.axesExtent.maxY) : (this.angleY < 270.0f ? new PointF((float)this.axesExtent.maxX, (float)this.axesExtent.minY) : new PointF((float)this.axesExtent.minX, (float)this.axesExtent.minY)));
            this.drawZAxis(gl, loc);
        }
        gl.glDepthFunc(515);
    }

    protected void drawZAxis(GL2 gl, PointF loc) {
        ChartText label;
        Vector3f center = this.transform.getCenter();
        float x = loc.X;
        float y = loc.Y;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        float[] rgba = this.zAxis.getLineColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
        gl.glBegin(1);
        gl.glVertex3f(x, y, zMin);
        gl.glVertex3f(x, y, zMax);
        gl.glEnd();
        this.zAxis.updateTickLabels();
        List<ChartText> tlabs = this.zAxis.getTickLabels();
        float axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
        int skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
        float x1 = x;
        float y1 = y;
        float yTickLen = this.zAxis.getTickLength() * this.lenScale * this.transform.getYLength() / 2.0f;
        float xTickLen = this.zAxis.getTickLength() * this.lenScale * this.transform.getXLength() / 2.0f;
        if (x < center.x) {
            if (y > center.y) {
                y1 += yTickLen;
            } else {
                x1 -= xTickLen;
            }
        } else if (y > center.y) {
            x1 += xTickLen;
        } else {
            y1 -= yTickLen;
        }
        XAlign xAlign = XAlign.RIGHT;
        YAlign yAlign = YAlign.CENTER;
        float strWidth = 0.0f;
        if (this.zAxis.isDrawTickLabel()) {
            this.updateTextRender(tlabs.get(0).getFont());
        }
        for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
            Rectangle2D rect;
            float v = (float)this.zAxis.getTickValues()[i];
            if ((double)v < this.axesExtent.minZ || (double)v > this.axesExtent.maxZ) continue;
            if (i == tlabs.size()) break;
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x, y, v);
            gl.glVertex3f(x1, y1, v);
            gl.glEnd();
            if (!this.zAxis.isDrawTickLabel() || !((double)strWidth < (rect = this.drawString(gl, tlabs.get(i), x1, y1, v, xAlign, yAlign, -this.tickSpace, 0.0f)).getWidth())) continue;
            strWidth = (float)rect.getWidth();
        }
        if (this.zAxis.isDrawLabel() && (label = this.zAxis.getLabel()) != null) {
            this.updateTextRender(label.getFont());
            float yShift = strWidth + this.tickSpace * 3.0f;
            float z1 = (zMax + zMin) * 0.5f;
            this.drawString(gl, label, x1, y1, z1, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
        }
    }

    protected void drawZAxis(GL2 gl, ZAxisOption zAxisOption) {
        ChartText label;
        Vector3f xyz;
        Matrix4f mvMatrix = this.toMatrix(this.mvmatrix);
        gl.glPushMatrix();
        PointF loc = zAxisOption.getLocation();
        boolean left = zAxisOption.isLeft();
        float x = loc.X;
        float y = loc.Y;
        float zMin = (float)this.axesExtent.minZ;
        float zMax = (float)this.axesExtent.maxZ;
        float[] rgba = this.zAxis.getLineColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
        gl.glBegin(1);
        gl.glVertex3f(x, y, zMin);
        gl.glVertex3f(x, y, zMax);
        gl.glEnd();
        float axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
        gl.glLoadIdentity();
        this.updateMatrix(gl);
        this.zAxis.updateTickLabels();
        List<ChartText> tlabs = this.zAxis.getTickLabels();
        int skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
        float tickLen = this.zAxis.getTickLength() * this.lenScale;
        YAlign yAlign = YAlign.CENTER;
        float strWidth = 0.0f;
        for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
            float xShift;
            XAlign xAlign;
            float v = (float)this.zAxis.getTickValues()[i];
            if ((double)v < this.axesExtent.minZ || (double)v > this.axesExtent.maxZ) continue;
            if (i == tlabs.size()) break;
            xyz = new Vector3f(x, y, v);
            mvMatrix.transformPosition(xyz);
            Vector3f xyz1 = new Vector3f(xyz.x, xyz.y, xyz.z);
            if (left) {
                xyz1.x -= tickLen;
                xAlign = XAlign.RIGHT;
                xShift = -this.tickSpace;
            } else {
                xyz1.x += tickLen;
                xAlign = XAlign.LEFT;
                xShift = this.tickSpace;
            }
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(xyz.x, xyz.y, xyz.z);
            gl.glVertex3f(xyz1.x, xyz1.y, xyz1.z);
            gl.glEnd();
            Rectangle2D rect = this.drawString(gl, tlabs.get(i), xyz1.x, xyz1.y, xyz1.z, xAlign, yAlign, xShift, 0.0f);
            if (!((double)strWidth < rect.getWidth())) continue;
            strWidth = (float)rect.getWidth();
        }
        if ((label = this.zAxis.getLabel()) != null) {
            float yShift;
            xyz = new Vector3f(x, y, 0.0f);
            mvMatrix.transformPosition(xyz);
            if (left) {
                xyz.x -= tickLen;
                yShift = strWidth + this.tickSpace * 3.0f;
                this.drawString(gl, label, xyz.x, xyz.y, xyz.z, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
            } else {
                xyz.x += tickLen;
                yShift = -(strWidth + this.tickSpace * 3.0f);
                this.drawString(gl, label, xyz.x, xyz.y, xyz.z, XAlign.CENTER, YAlign.TOP, 90.0f, 0.0f, yShift);
            }
        }
        gl.glPopMatrix();
        this.updateMatrix(gl);
    }

    protected void drawAllZAxis(GL2 gl) {
        for (ZAxisOption zAxisOption : this.zAxisLocations) {
            this.drawZAxis(gl, zAxisOption);
        }
    }

    void updateTextRender(Font font) {
        boolean newTR = false;
        if (this.dpiScale != 1.0f) {
            newTR = true;
        } else if (this.textRenderer == null) {
            newTR = true;
        } else if (!this.textRenderer.getFont().equals(font)) {
            newTR = true;
        }
        if (newTR) {
            this.textRenderer = this.dpiScale == 1.0f ? new TextRenderer(font, true, true) : new TextRenderer(font.deriveFont((float)font.getSize() * this.dpiScale), true, true);
        }
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, text, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, xShift, yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        if (Draw.getStringType((String)str) == StringType.LATEX) {
            return this.drawLaTex(gl, str, font, color, vx, vy, vz, xAlign, yAlign, xShift, yShift);
        }
        Vector2f coord = this.toScreen(vx, vy, vz);
        float x = coord.x;
        float y = coord.y;
        this.textRenderer.beginRendering(this.width, this.height);
        this.textRenderer.setColor(color);
        this.textRenderer.setSmoothing(true);
        Rectangle2D rect = this.textRenderer.getBounds(str.subSequence(0, str.length()));
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.3);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        this.textRenderer.draw(str, (int)(x + xShift), (int)(y + yShift));
        this.textRenderer.endRendering();
        return rect;
    }

    Rectangle2D drawLaTex(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        Vector2f coord = this.toScreen(vx, vy, vz);
        float x = coord.x;
        float y = coord.y;
        return this.drawLaTex(gl, str, font, color, x, y, xAlign, yAlign, xShift, yShift);
    }

    Rectangle2D drawLaTex(GL2 gl, String str, Font font, Color color, float x, float y, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        TeXFormula formula = new TeXFormula(str);
        TeXIcon icon = formula.createTeXIcon(2, (float)font.getSize());
        icon.setInsets(new Insets(5, 5, 5, 5));
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        Dimension dim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - (double)dim.width * 0.5);
                break;
            }
            case RIGHT: {
                x -= (float)dim.width;
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - (double)dim.height * 0.3);
                break;
            }
            case TOP: {
                y -= (float)dim.height;
            }
        }
        icon.setForeground(color);
        icon.paintIcon(null, (Graphics)g2, 0, 0);
        Rectangle2D.Float rect = new Rectangle2D.Float(x += xShift, y += yShift, icon.getIconWidth(), icon.getIconHeight());
        int attribBits = 291072;
        gl.glPushAttrib(291072);
        gl.glDisable(2929);
        gl.glDisable(2884);
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, (float)this.width, 0.0f, (float)this.height);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5890);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        this.drawTexture(gl, texture, rect);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glMatrixMode(5890);
        gl.glPopMatrix();
        gl.glPopAttrib();
        return rect;
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, (float)text.getXShift(), (float)text.getYShift());
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, (float)text.getXShift() + xShift, (float)text.getYShift() + yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, angle, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        Vector2f coord = this.toScreen(vx, vy, vz);
        float x = coord.x;
        float y = coord.y;
        if (Draw.getStringType((String)str) == StringType.LATEX) {
            return this.drawLaTex(gl, str, font, color, x, y, xAlign, yAlign, angle, xShift, yShift);
        }
        this.textRenderer.beginRendering(this.width, this.height);
        this.textRenderer.setColor(color);
        this.textRenderer.setSmoothing(true);
        Rectangle2D rect = this.textRenderer.getBounds(str.subSequence(0, str.length()));
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glTranslatef(x, y, 0.0f);
        if (angle != 0.0f) {
            gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        }
        x = 0.0f;
        y = 0.0f;
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.5);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        this.textRenderer.draw(str, (int)(x += xShift), (int)(y += yShift));
        this.textRenderer.endRendering();
        gl.glPopMatrix();
        return rect;
    }

    Rectangle2D drawLaTex(GL2 gl, String str, Font font, Color color, float x, float y, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        TeXFormula formula = new TeXFormula(str);
        TeXIcon icon = formula.createTeXIcon(2, font.getSize2D());
        icon.setInsets(new Insets(5, 5, 5, 5));
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        int attribBits = 291072;
        gl.glPushAttrib(291072);
        gl.glDisable(2929);
        gl.glDisable(2884);
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, (float)this.width, 0.0f, (float)this.height);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glTranslatef(x, y, 0.0f);
        if (angle != 0.0f) {
            gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        }
        x = 0.0f;
        y = 0.0f;
        Dimension dim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - (double)dim.width * 0.5);
                break;
            }
            case RIGHT: {
                x -= (float)dim.width;
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - (double)dim.height * 0.3);
                break;
            }
            case TOP: {
                y -= (float)dim.height;
            }
        }
        icon.setForeground(color);
        icon.paintIcon(null, (Graphics)g2, 0, 0);
        Rectangle2D.Float rect = new Rectangle2D.Float(x += xShift, y += yShift, icon.getIconWidth(), icon.getIconHeight());
        gl.glMatrixMode(5890);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        this.drawTexture(gl, texture, rect, angle);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glMatrixMode(5890);
        gl.glPopMatrix();
        gl.glPopAttrib();
        return rect;
    }

    Rectangle2D drawString3D(GL2 gl, ChartText3D text3D, float vx, float vy, float vz) {
        return this.drawString3D(gl, text3D.getText(), text3D.getColor(), vx, vy, vz);
    }

    Rectangle2D drawString3D(GL2 gl, String str, Color color, float vx, float vy, float vz) {
        float scale = 0.5f;
        this.textRenderer.begin3DRendering();
        this.textRenderer.setColor(color);
        this.textRenderer.setSmoothing(true);
        Rectangle2D rect = this.textRenderer.getBounds(str.subSequence(0, str.length()));
        this.textRenderer.draw3D(str, vx, vy, vz, scale);
        this.textRenderer.end3DRendering();
        return rect;
    }

    void drawTitle() {
        if (this.title != null) {
            float x = (float)this.width / 2.0f;
            float y = this.height;
            if (Draw.getStringType((String)this.title.getText()) == StringType.LATEX) {
                if (this.gl == null) {
                    this.gl = GLContext.getCurrentGL().getGL2();
                }
                this.drawLaTex(this.gl, this.title.getText(), this.title.getFont(), this.title.getColor(), x, y, XAlign.CENTER, YAlign.TOP, 0.0f, 0.0f);
            } else {
                Font font = this.title.getFont();
                this.updateTextRender(font);
                this.textRenderer.beginRendering(this.width, this.height);
                this.textRenderer.setColor(this.title.getColor());
                this.textRenderer.setSmoothing(true);
                Rectangle2D rect = this.textRenderer.getBounds(this.title.getText().subSequence(0, this.title.getText().length()));
                x = (float)this.width / 2.0f - (float)rect.getWidth() / 2.0f;
                y = (float)this.height - (float)rect.getHeight();
                this.textRenderer.draw(this.title.getText(), (int)x, (int)y);
                this.textRenderer.endRendering();
            }
        }
    }

    protected void drawTriMeshGraphic(GL2 gl, TriMeshGraphic graphic) {
        if (!this.renderMap.containsKey((Object)graphic)) {
            this.renderMap.put((Graphic)graphic, new TriMeshRender(gl, graphic));
        }
        TriMeshRender triMeshRender = (TriMeshRender)this.renderMap.get((Object)graphic);
        triMeshRender.setTransform(this.transform, this.alwaysUpdateBuffers);
        triMeshRender.setOrthographic(this.orthographic);
        triMeshRender.setLighting(this.lighting);
        triMeshRender.updateMatrix();
        triMeshRender.draw();
    }

    protected void drawGraphics(GL2 gl, Graphic graphic) {
        boolean lightEnabled = this.lighting.isEnable();
        if (graphic instanceof GraphicCollection3D && lightEnabled && !((GraphicCollection3D)graphic).isUsingLight()) {
            this.lighting.stop(gl);
        }
        if (graphic instanceof MeshGraphic) {
            if (!this.renderMap.containsKey(graphic)) {
                this.renderMap.put(graphic, new MeshRender(gl, (MeshGraphic)graphic));
            }
            MeshRender meshRender = (MeshRender)this.renderMap.get(graphic);
            meshRender.setTransform(this.transform, this.alwaysUpdateBuffers);
            meshRender.setOrthographic(this.orthographic);
            meshRender.setLighting(this.lighting);
            meshRender.updateMatrix();
            meshRender.draw();
        } else if (graphic instanceof ParticleGraphics) {
            if (!this.renderMap.containsKey(graphic)) {
                this.renderMap.put(graphic, new PointRender(gl, (GraphicCollection3D)graphic));
            }
            PointRender pointRender = (PointRender)this.renderMap.get(graphic);
            pointRender.setTransform(this.transform, this.alwaysUpdateBuffers);
            pointRender.setOrthographic(this.orthographic);
            pointRender.setLighting(this.lighting);
            pointRender.updateMatrix();
            pointRender.draw();
        } else if (graphic instanceof TriMeshGraphic) {
            if (graphic instanceof Model) {
                if (!this.renderMap.containsKey(graphic)) {
                    this.renderMap.put(graphic, new ModelRender(gl, (Model)graphic));
                }
                ModelRender modelRender = (ModelRender)this.renderMap.get(graphic);
                modelRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                modelRender.setOrthographic(this.orthographic);
                modelRender.setLighting(this.lighting);
                modelRender.updateMatrix();
                modelRender.setRotateModelView(this.modelViewMatrixR);
                modelRender.draw();
            } else {
                this.drawTriMeshGraphic(gl, (TriMeshGraphic)graphic);
            }
        } else if (graphic instanceof VolumeGraphic) {
            try {
                if (this.clipPlane) {
                    this.disableClipPlane(gl);
                }
                if (!this.renderMap.containsKey(graphic)) {
                    this.renderMap.put(graphic, new VolumeRender(gl, (VolumeGraphic)graphic));
                }
                VolumeRender volumeRender = (VolumeRender)this.renderMap.get(graphic);
                volumeRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                volumeRender.setOrthographic(this.orthographic);
                volumeRender.updateMatrix();
                volumeRender.draw();
                if (this.clipPlane) {
                    this.enableClipPlane(gl);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean isDraw = true;
            if (graphic instanceof GraphicCollection3D) {
                if (graphic.getNumGraphics() == 0) {
                    isDraw = false;
                } else {
                    GraphicCollection3D gg = (GraphicCollection3D)graphic;
                    if (gg.isAllQuads()) {
                        this.drawQuadsPolygons(gl, gg);
                        isDraw = false;
                    } else if (gg.isAllTriangle()) {
                        this.drawTrianglePolygons(gl, gg);
                        isDraw = false;
                    }
                }
            }
            if (isDraw) {
                switch (graphic.getGraphicN(0).getShapeType()) {
                    case POINT_Z: {
                        if (!this.renderMap.containsKey(graphic)) {
                            this.renderMap.put(graphic, new PointRender(gl, (GraphicCollection3D)graphic));
                        }
                        PointRender pointRender = (PointRender)this.renderMap.get(graphic);
                        pointRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                        pointRender.setOrthographic(this.orthographic);
                        pointRender.setLighting(this.lighting);
                        pointRender.updateMatrix();
                        pointRender.setRotateModelView(this.modelViewMatrixR);
                        pointRender.draw();
                        break;
                    }
                    case POLYLINE_Z: {
                        if (graphic.getGraphicN(0).getShape() instanceof PipeShape) {
                            if (!this.renderMap.containsKey(graphic)) {
                                this.renderMap.put(graphic, new PipeRender(gl, (GraphicCollection3D)graphic));
                            }
                            PipeRender pipeRender = (PipeRender)this.renderMap.get(graphic);
                            pipeRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                            pipeRender.setOrthographic(this.orthographic);
                            pipeRender.setLighting(this.lighting);
                            pipeRender.updateMatrix();
                            pipeRender.setRotateModelView(this.modelViewMatrixR);
                            pipeRender.draw();
                            break;
                        }
                        if (!this.renderMap.containsKey(graphic)) {
                            this.renderMap.put(graphic, new LineRender(gl, (GraphicCollection3D)graphic));
                        }
                        LineRender lineRender = (LineRender)this.renderMap.get(graphic);
                        lineRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                        lineRender.setOrthographic(this.orthographic);
                        lineRender.setLighting(this.lighting);
                        lineRender.updateMatrix();
                        lineRender.setRotateModelView(this.modelViewMatrixR);
                        lineRender.draw();
                        break;
                    }
                    case WIND_ARROW: {
                        if (!this.renderMap.containsKey(graphic)) {
                            this.renderMap.put(graphic, new QuiverRender(gl, (GraphicCollection3D)graphic));
                        }
                        QuiverRender quiverRender = (QuiverRender)this.renderMap.get(graphic);
                        quiverRender.setTransform(this.transform, this.alwaysUpdateBuffers);
                        quiverRender.setOrthographic(this.orthographic);
                        quiverRender.setLighting(this.lighting);
                        quiverRender.updateMatrix();
                        quiverRender.setRotateModelView(this.modelViewMatrixR);
                        quiverRender.draw();
                        break;
                    }
                    default: {
                        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                            Graphic gg = graphic.getGraphicN(i);
                            if (gg instanceof TriMeshGraphic) {
                                this.drawTriMeshGraphic(gl, (TriMeshGraphic)gg);
                                continue;
                            }
                            this.drawGraphic(gl, gg);
                        }
                    }
                }
            }
        }
        if (graphic instanceof GraphicCollection3D && lightEnabled && !((GraphicCollection3D)graphic).isUsingLight()) {
            this.lighting.start(gl);
        }
    }

    protected void drawGraphic(GL2 gl, Graphic graphic) {
        Shape shape = graphic.getGraphicN(0).getShape();
        switch (shape.getShapeType()) {
            case POINT_Z: 
            case POINT: {
                this.drawPoint(gl, graphic);
                break;
            }
            case TEXT: {
                if (this.clipPlane) {
                    this.disableClipPlane(gl);
                }
                this.drawText(gl, (ChartText3D)shape);
                if (!this.clipPlane) break;
                this.enableClipPlane(gl);
                break;
            }
            case POLYLINE_Z: 
            case POLYLINE: {
                break;
            }
            case POLYGON: 
            case POLYGON_Z: {
                this.drawPolygonShape(gl, graphic);
                break;
            }
            case WIND_ARROW: {
                break;
            }
            case CUBIC: {
                this.drawCubic(gl, graphic);
                break;
            }
            case CYLINDER: {
                this.drawCylinder(gl, graphic);
                break;
            }
            case IMAGE: {
                this.drawImage(gl, graphic);
                break;
            }
            case TEXTURE: {
                this.drawTexture(gl, graphic);
            }
        }
    }

    protected void drawText(GL2 gl, ChartText3D text) {
        Vector3f xyz = new Vector3f((float)text.getX(), (float)text.getY(), (float)text.getZ());
        this.updateTextRender(text.getFont());
        if (text.isDraw3D()) {
            this.drawString3D(gl, text, xyz.x, xyz.y, xyz.z);
        } else {
            this.drawString(gl, text, xyz.x, xyz.y, xyz.z, text.getXAlign(), text.getYAlign());
        }
    }

    protected void drawText3D(GL2 gl, ChartText3D text) {
        Vector3f xyz = new Vector3f((float)text.getX(), (float)text.getY(), (float)text.getZ());
        this.drawString3D(gl, text, xyz.x, xyz.y, xyz.z);
    }

    private void drawPoint(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glPointSize(pb.getSize() * this.dpiScale);
            gl.glBegin(0);
            PointZ p = (PointZ)shape.getPoint();
            gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            gl.glEnd();
        }
    }

    private void drawPoints(GL2 gl, Graphic graphic) {
        PointBreak pb = (PointBreak)graphic.getGraphicN(0).getLegend();
        gl.glPointSize(pb.getSize() * this.dpiScale);
        gl.glBegin(0);
        for (Graphic gg : ((GraphicCollection)graphic).getGraphics()) {
            PointZShape shape = (PointZShape)gg.getShape();
            pb = (PointBreak)gg.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            PointZ p = (PointZ)shape.getPoint();
            gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
        }
        gl.glEnd();
    }

    private void drawSphere(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4fv(rgba, 0);
            gl.glPushMatrix();
            PointZ p = (PointZ)shape.getPoint();
            Vector3f xyz = new Vector3f((float)p.X, (float)p.Y, (float)p.Z);
            gl.glTranslated((double)xyz.x, (double)xyz.y, (double)xyz.z);
            GLUquadric sphere = this.glu.gluNewQuadric();
            this.glu.gluQuadricDrawStyle(sphere, 100012);
            this.glu.gluQuadricNormals(sphere, 100001);
            this.glu.gluQuadricOrientation(sphere, 100020);
            this.glu.gluSphere(sphere, (double)pb.getSize() * 0.005 * (double)this.dpiScale, 16, 16);
            this.glu.gluDeleteQuadric(sphere);
            gl.glPopMatrix();
        }
    }

    private void drawSpheres(GL2 gl, Graphic graphic) {
        for (Graphic gg : ((GraphicCollection)graphic).getGraphics()) {
            this.drawSphere(gl, gg);
        }
    }

    private void drawParticles(GL2 gl, ParticleGraphics particles) {
        for (Map.Entry<Integer, List> map : particles.getParticleList()) {
            gl.glPointSize(particles.getPointSize() * this.dpiScale);
            gl.glBegin(0);
            for (ParticleGraphics.Particle p : map.getValue()) {
                float[] rgba = p.rgba;
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glVertex3f(p.x, p.y, p.z);
            }
            gl.glEnd();
        }
    }

    private int getTextureID(GL2 gl) {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl.glGenTextures(1, intBuffer);
        return intBuffer.get(0);
    }

    private void drawVolume(GL2 gl, VolumeGraphic volume) throws Exception {
        gl.glDisable(2929);
        gl.glActiveTexture(33985);
        gl.glBindTexture(3553, this.getTextureID(gl));
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glTexImage2D(3553, 0, 6408, 1, 1, 0, 6408, 5121, (Buffer)Buffers.newDirectByteBuffer((byte[])volume.getColors()));
        int idData = this.getTextureID(gl);
        gl.glActiveTexture(33984);
        gl.glBindTexture(32879, idData);
        gl.glTexParameteri(32879, 33084, 0);
        gl.glTexParameteri(32879, 10241, 9729);
        gl.glTexParameteri(32879, 10240, 9729);
        gl.glTexParameteri(32879, 10242, 33071);
        gl.glTexParameteri(32879, 10243, 33071);
        gl.glTexParameteri(32879, 32882, 33071);
        String vertexShaderCode = Utils.loadResource("/shaders/volume/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/volume/maxValue.frag");
        Program program = new Program("volume", vertexShaderCode, fragmentShaderCode);
        try {
            program.init(gl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl.glGenBuffers(1, intBuffer);
        int vertexBuffer = intBuffer.get(0);
        gl.glBindBuffer(34962, vertexBuffer);
        float[] vertexBufferData = volume.getVertexBufferData(this.transform);
        gl.glBufferData(34962, (long)(vertexBufferData.length * 4), (Buffer)Buffers.newDirectFloatBuffer((float[])vertexBufferData), 35044);
        program.allocateUniform(gl, "orthographic", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), this.orthographic ? 1 : 0));
        program.allocateUniform(gl, "MVP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.viewProjMatrix.get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "iV", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "iP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.projmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "viewSize", (gl2, loc) -> gl2.glUniform2f(loc.intValue(), (float)this.width, (float)this.height));
        int sampleCount = 512;
        program.allocateUniform(gl, "depthSampleCount", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), sampleCount));
        program.allocateUniform(gl, "tex", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 0));
        program.allocateUniform(gl, "colorMap", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 1));
        float[] aabbMin = volume.getAabbMin();
        float[] aabbMax = volume.getAabbMax();
        program.allocateUniform(gl, "aabbMin", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMin[0], aabbMin[1], aabbMin[2]));
        program.allocateUniform(gl, "aabbMax", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMax[0], aabbMax[1], aabbMax[2]));
        program.use(gl);
        program.setUniforms(gl);
        gl.glActiveTexture(33985);
        gl.glTexImage2D(3553, 0, 6408, volume.getColorNum(), 1, 0, 6408, 5121, Buffers.newDirectByteBuffer((byte[])volume.getColors()).rewind());
        gl.glActiveTexture(33984);
        gl.glBindTexture(32879, idData);
        gl.glPixelStorei(3317, 1);
        gl.glTexImage3D(32879, 0, 6409, volume.getWidth(), volume.getHeight(), volume.getDepth(), 0, 6409, 5121, Buffers.newDirectByteBuffer((byte[])volume.getByteData()).rewind());
        gl.glEnableVertexAttribArray(0);
        gl.glBindBuffer(34962, vertexBuffer);
        gl.glVertexAttribPointer(0, 3, 5126, false, 12, 0L);
        gl.glDrawArrays(4, 0, vertexBufferData.length / 3);
        gl.glDisableVertexAttribArray(0);
        Program.destroyAllPrograms(gl);
        gl.glUseProgram(0);
        gl.glEnable(2929);
    }

    private void drawLineString(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                Polyline line = (Polyline)shape.getPolylines().get(0);
                List ps = line.getPointList();
                gl.glLineWidth(((PolylineBreak)cbc.get(0)).getWidth() * this.dpiScale);
                gl.glBegin(3);
                for (int i = 0; i < ps.size(); ++i) {
                    PolylineBreak plb = (PolylineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(plb.getWidth() * this.dpiScale);
                    PointZ p = (PointZ)ps.get(i);
                    gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                }
                gl.glEnd();
            } else {
                PolylineBreak pb = (PolylineBreak)cb;
                float[] rgba = pb.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(pb.getWidth() * this.dpiScale);
                for (Polyline line : shape.getPolylines()) {
                    gl.glBegin(3);
                    List ps = line.getPointList();
                    for (PointZ p : ps) {
                        gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                    }
                    gl.glEnd();
                }
            }
        }
    }

    private void drawPipe(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            PipeShape shape = (PipeShape)graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            shape.transform(this.transform);
            Pipe pipe = shape.getPipe();
            int count = pipe.getContourCount();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                for (int i = 0; i < count - 1; ++i) {
                    PolylineBreak plb = (PolylineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    List<Vector3f> c1 = pipe.getContour(i);
                    List<Vector3f> c2 = pipe.getContour(i + 1);
                    List<Vector3f> n1 = pipe.getNormal(i);
                    List<Vector3f> n2 = pipe.getNormal(i + 1);
                    gl.glBegin(5);
                    for (int j = 0; j < c2.size(); ++j) {
                        gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                    }
                    gl.glEnd();
                }
                gl.glEnd();
            } else {
                PolylineBreak pb = (PolylineBreak)cb;
                float[] rgba = pb.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                for (int i = 0; i < count - 1; ++i) {
                    List<Vector3f> c1 = pipe.getContour(i);
                    List<Vector3f> c2 = pipe.getContour(i + 1);
                    List<Vector3f> n1 = pipe.getNormal(i);
                    List<Vector3f> n2 = pipe.getNormal(i + 1);
                    gl.glBegin(5);
                    for (int j = 0; j < c2.size(); ++j) {
                        gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                    }
                    gl.glEnd();
                }
            }
        }
    }

    protected void drawPolygonShape(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            PolygonZShape shape = (PolygonZShape)graphic.getShape();
            PolygonBreak pb = (PolygonBreak)graphic.getLegend();
            List polygonZS = shape.getPolygons();
            for (int i = 0; i < polygonZS.size(); ++i) {
                PolygonZ polygonZ = (PolygonZ)polygonZS.get(i);
                if (pb.isDrawFill()) {
                    if (polygonZ instanceof TessPolygon) {
                        this.drawTessPolygon(gl, (TessPolygon)polygonZ, pb);
                        continue;
                    }
                    if (polygonZ.getOutLine().size() <= 5) {
                        this.drawConvexPolygon(gl, polygonZ, pb);
                        continue;
                    }
                    TessPolygon tessPolygon = new TessPolygon(polygonZ);
                    this.drawTessPolygon(gl, tessPolygon, pb);
                    polygonZS.set(i, tessPolygon);
                    continue;
                }
                this.drawPolygon(gl, polygonZ, pb);
            }
        }
    }

    private void drawTessPolygon(GL2 gl, TessPolygon tessPolygon, PolygonBreak aPGB) {
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            if (tessPolygon.getPrimitives() != null) {
                try {
                    for (Primitive primitive : tessPolygon.getPrimitives()) {
                        gl.glBegin(primitive.type);
                        for (PointZ p : primitive.vertices) {
                            gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                        }
                        gl.glEnd();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (aPGB.isDrawOutline()) {
            PointZ p;
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < tessPolygon.getOutLine().size(); ++i) {
                p = (PointZ)tessPolygon.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
            if (tessPolygon.hasHole()) {
                for (int h = 0; h < tessPolygon.getHoleLines().size(); ++h) {
                    gl.glBegin(3);
                    List newPList = (List)tessPolygon.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                    }
                    gl.glEnd();
                }
            }
            gl.glDisable(32823);
        }
    }

    private void drawPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            try {
                TessPolygon tessPolygon = new TessPolygon(aPG);
                for (Primitive primitive : tessPolygon.getPrimitives()) {
                    gl.glBegin(primitive.type);
                    for (PointZ p : primitive.vertices) {
                        gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                    }
                    gl.glEnd();
                }
                aPG = tessPolygon;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aPGB.isDrawOutline()) {
            PointZ p;
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
            if (aPG.hasHole()) {
                gl.glBegin(3);
                for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                    List newPList = (List)aPG.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
                    }
                }
                gl.glEnd();
            }
            gl.glDisable(32823);
        }
    }

    private void drawConvexPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba;
        if (aPGB.isDrawFill()) {
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(9);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
    }

    private void drawQuadsPolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            boolean isDraw = true;
            if (this.clipPlane) {
                isDraw = this.drawExtent.intersects(gg.getExtent());
            }
            if (!isDraw) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ poly : shape.getPolygons()) {
                this.drawQuads(gl, poly, pb);
            }
        }
    }

    private void drawQuads(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
    }

    private void drawTrianglePolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            boolean isDraw = true;
            if (this.clipPlane) {
                isDraw = this.drawExtent.intersects(gg.getExtent());
            }
            if (!isDraw) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ poly : shape.getPolygons()) {
                this.drawTriangle(gl, poly, pb);
            }
        }
    }

    private void drawTriangle(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(4);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
    }

    private void drawTriangle(GL2 gl, PointZ[] points, PolygonBreak aPGB) {
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            float[] x0 = points[0].toFloatArray();
            float[] x1 = points[1].toFloatArray();
            float[] x2 = points[2].toFloatArray();
            gl.glBegin(4);
            if (this.lighting.isEnable()) {
                float[] normal = JOGLUtil.normalize(x0, x1, x2);
                gl.glNormal3fv(normal, 0);
            }
            gl.glVertex3fv(x0, 0);
            gl.glVertex3fv(x1, 0);
            gl.glVertex3fv(x2, 0);
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < 3; ++i) {
                PointZ p = points[i];
                gl.glVertex3f((float)p.X, (float)p.Y, (float)p.Z);
            }
            gl.glEnd();
        }
    }

    private void drawIsosurface(GL2 gl, IsosurfaceGraphics isosurface) {
        List<PointZ[]> triangles = isosurface.getTriangles();
        PolygonBreak pgb = (PolygonBreak)isosurface.getLegendBreak();
        for (PointZ[] triangle : triangles) {
            this.drawTriangle(gl, triangle, pgb);
        }
    }

    private void drawImage(GL2 gl, Graphic graphic) {
        ImageShape ishape = (ImageShape)graphic.getShape();
        BufferedImage image = ishape.getImage();
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = texture.getTextureObject();
        List coords = ishape.getCoords();
        gl.glEnable(3553);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)0)).X, (float)((PointZ)coords.get((int)0)).Y, (float)((PointZ)coords.get((int)0)).Z);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)1)).X, (float)((PointZ)coords.get((int)1)).Y, (float)((PointZ)coords.get((int)1)).Z);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)2)).X, (float)((PointZ)coords.get((int)2)).Y, (float)((PointZ)coords.get((int)2)).Z);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)3)).X, (float)((PointZ)coords.get((int)3)).Y, (float)((PointZ)coords.get((int)3)).Z);
        gl.glEnd();
        gl.glBindTexture(3553, 0);
        gl.glDisable(3553);
    }

    private void drawImage(GL2 gl) throws IOException {
        File im = new File("D:\\Temp\\image\\lenna.jpg ");
        BufferedImage image = ImageIO.read(im);
        Texture t = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = t.getTextureObject((GL)gl);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    private void drawTexture(GL2 gl, Graphic graphic) {
        TextureShape ishape = (TextureShape)graphic.getShape();
        ishape.updateTexture(gl);
        int idTexture = ishape.getTextureID();
        List coords = ishape.getCoords();
        int xRepeat = ishape.getXRepeat();
        int yRepeat = ishape.getYRepeat();
        float width = (float)(((PointZ)coords.get((int)1)).X - ((PointZ)coords.get((int)0)).X);
        float height = (float)(((PointZ)coords.get((int)1)).Y - ((PointZ)coords.get((int)2)).Y);
        width *= (float)(xRepeat - 1);
        height *= (float)(yRepeat - 1);
        gl.glEnable(3553);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9987);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10242, 10497);
        gl.glTexParameteri(3553, 10243, 10497);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 1.0f * (float)yRepeat);
        gl.glVertex3f((float)((PointZ)coords.get((int)0)).X, (float)((PointZ)coords.get((int)0)).Y + height, (float)((PointZ)coords.get((int)0)).Z);
        gl.glTexCoord2f(1.0f * (float)xRepeat, 1.0f * (float)yRepeat);
        gl.glVertex3f((float)((PointZ)coords.get((int)1)).X + width, (float)((PointZ)coords.get((int)1)).Y + height, (float)((PointZ)coords.get((int)1)).Z);
        gl.glTexCoord2f(1.0f * (float)xRepeat, 0.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)2)).X + width, (float)((PointZ)coords.get((int)2)).Y, (float)((PointZ)coords.get((int)2)).Z);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f((float)((PointZ)coords.get((int)3)).X, (float)((PointZ)coords.get((int)3)).Y, (float)((PointZ)coords.get((int)3)).Z);
        gl.glEnd();
        gl.glFlush();
        gl.glBindTexture(3553, 0);
        gl.glDisable(3553);
    }

    private void drawTexture(GL2 gl, Texture texture, Rectangle2D rect) {
        this.drawTexture(gl, texture, rect, 0.0f);
    }

    private void drawTexture(GL2 gl, Texture texture, Rectangle2D rect, float angle) {
        int idTexture = texture.getTextureObject((GL)gl);
        int width = texture.getWidth();
        int height = texture.getHeight();
        gl.glEnable(3553);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        int filter = 9728;
        if (angle != 0.0f && angle != 90.0f) {
            filter = 9729;
        }
        gl.glTexParameteri(3553, 10241, filter);
        gl.glTexParameteri(3553, 10240, filter);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex2f((float)rect.getX(), (float)rect.getY());
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex2f((float)rect.getMaxX(), (float)rect.getY());
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex2f((float)rect.getMaxX(), (float)rect.getMaxY());
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f((float)rect.getX(), (float)rect.getMaxY());
        gl.glEnd();
        gl.glFlush();
        gl.glBindTexture(3553, 0);
        gl.glDisable(3553);
    }

    void drawCircle(GL2 gl, float z, float radius, PolygonBreak bb) {
        this.drawCircle(gl, z, radius, bb, false);
    }

    void drawCircle(GL2 gl, float z, float radius, PolygonBreak bb, boolean clockwise) {
        int i;
        int i2;
        int points = 100;
        ArrayList<float[]> vertex = new ArrayList<float[]>();
        double angle = 0.0;
        if (clockwise) {
            for (i2 = points - 1; i2 >= 0; --i2) {
                angle = Math.PI * 2 * (double)i2 / (double)points;
                vertex.add(new float[]{(float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z});
            }
        } else {
            for (i2 = 0; i2 < points; ++i2) {
                angle = Math.PI * 2 * (double)i2 / (double)points;
                vertex.add(new float[]{(float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z});
            }
        }
        if (bb.isDrawFill()) {
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(6);
            if (this.lighting.isEnable()) {
                int ii = points / 4;
                float[] normal = JOGLUtil.normalize((float[])vertex.get(0), (float[])vertex.get(ii), (float[])vertex.get(ii * 2));
                gl.glNormal3fv(normal, 0);
            }
            for (i = 0; i < points; ++i) {
                gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
            }
            gl.glEnd();
        }
        if (bb.isDrawOutline()) {
            float[] rgba = bb.getOutlineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(bb.getOutlineSize() * this.dpiScale);
            gl.glBegin(2);
            for (i = 0; i < points; ++i) {
                gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
            }
            gl.glEnd();
        }
    }

    void drawCubic(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            CubicShape cubic = (CubicShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List ps = cubic.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{(float)p.X, (float)p.Y, (float)p.Z});
            }
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            int[][] index = cubic.getIndex();
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            for (int[] ii : index) {
                if (this.lighting.isEnable()) {
                    float[] normal = JOGLUtil.normalize((float[])vertex.get(ii[0]), (float[])vertex.get(ii[1]), (float[])vertex.get(ii[2]));
                    gl.glNormal3fv(normal, 0);
                }
                for (int i2 : ii) {
                    gl.glVertex3f(((float[])vertex.get(i2))[0], ((float[])vertex.get(i2))[1], ((float[])vertex.get(i2))[2]);
                }
            }
            gl.glEnd();
            gl.glDisable(32823);
            if (bb.isDrawOutline()) {
                rgba = bb.getOutlineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(bb.getOutlineSize() * this.dpiScale);
                gl.glBegin(1);
                int[][] nArray = cubic.getLineIndex();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] ii;
                    for (int i2 : ii = nArray[i]) {
                        gl.glVertex3f(((float[])vertex.get(i2))[0], ((float[])vertex.get(i2))[1], ((float[])vertex.get(i2))[2]);
                    }
                }
                gl.glEnd();
            }
        }
    }

    void drawCylinder(GL2 gl, Graphic graphic) {
        boolean isDraw = true;
        if (this.clipPlane) {
            isDraw = this.drawExtent.intersects(graphic.getExtent());
        }
        if (isDraw) {
            CylinderShape cylinder = (CylinderShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List ps = cylinder.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{(float)p.X, (float)p.Y, (float)p.Z});
            }
            double height = ((float[])vertex.get(1))[2] - ((float[])vertex.get(0))[2];
            gl.glPushMatrix();
            gl.glPushAttrib(8);
            gl.glDisable(2884);
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glTranslatef(((float[])vertex.get(0))[0], ((float[])vertex.get(0))[1], ((float[])vertex.get(0))[2]);
            GLUquadric cone_obj = this.glu.gluNewQuadric();
            this.glu.gluCylinder(cone_obj, cylinder.getRadius(), cylinder.getRadius(), height, 100, 1);
            bb.setDrawOutline(false);
            this.drawCircle(gl, (float)height, (float)cylinder.getRadius(), (PolygonBreak)bb);
            this.drawCircle(gl, 0.0f, (float)cylinder.getRadius(), (PolygonBreak)bb, true);
            gl.glPopAttrib();
            gl.glPopMatrix();
        }
    }

    void drawLegend(GL2 gl, ChartColorBar legend) {
        LegendScheme ls = legend.getLegendScheme();
        int bNum = ls.getBreakNum();
        if (((ColorBreak)ls.getLegendBreaks().get(bNum - 1)).isNoData()) {
            --bNum;
        }
        float x = 1.6f;
        x += legend.getXShift() * this.lenScale;
        float y = -1.0f;
        float lHeight = 2.0f;
        float lWidth = lHeight / (float)legend.getAspect();
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        ArrayList<String> tLabels = new ArrayList<String>();
        if (legend.isAutoTick()) {
            float legendLen = this.toScreenLength(x, y, 0.0f, x, y + lHeight, 0.0f);
            int tickGap = this.getLegendTickGap(legend, legendLen);
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum - 1;
            if (ls.getLegendType() == LegendType.UNIQUE_VALUE) {
                ++labNum;
            } else if (legend.isDrawMinLabel()) {
                sIdx = 0;
                labNum = bNum;
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(i);
                double v = Double.parseDouble(cb.getEndValue().toString());
                if (!legend.getTickLocations().contains(v)) continue;
                labelIdxs.add(i);
                int tickIdx = legend.getTickLocations().indexOf(v);
                tLabels.add(legend.getTickLabels().get(tickIdx).getText());
            }
        }
        float barHeight = lHeight / (float)bNum;
        gl.glDepthFunc(519);
        float yy = y;
        for (int i = 0; i < bNum; ++i) {
            float[] rgba = ls.getLegendBreak(i).getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            gl.glVertex2f(x, yy);
            gl.glVertex2f(x + lWidth, yy);
            gl.glVertex2f(x + lWidth, yy + barHeight);
            gl.glVertex2f(x, yy + barHeight);
            gl.glEnd();
            yy += barHeight;
        }
        float[] rgba = legend.getTickColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(legend.getNeatLineSize() * this.dpiScale);
        gl.glBegin(3);
        gl.glVertex2f(x, y);
        gl.glVertex2f(x, y + lHeight);
        gl.glVertex2f(x + lWidth, y + lHeight);
        gl.glVertex2f(x + lWidth, y);
        gl.glVertex2f(x, y);
        gl.glEnd();
        int idx = 0;
        yy = y;
        float tickLen = legend.getTickLength() * this.lenScale;
        float labelX = x + lWidth;
        if (legend.isInsideTick()) {
            if (tickLen > lWidth) {
                tickLen = lWidth;
            }
        } else {
            labelX += tickLen;
        }
        float strWidth = 0.0f;
        float xShift = this.tickSpace * this.dpiScale;
        this.updateTextRender(legend.getTickLabelFont());
        for (int i = 0; i < bNum; ++i) {
            if (labelIdxs.contains(i)) {
                Rectangle2D rect;
                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(i);
                String caption = legend.isAutoTick() ? (ls.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
                if (ls.getLegendType() == LegendType.UNIQUE_VALUE) {
                    rect = this.drawString(gl, caption, legend.getTickLabelFont(), legend.getTickLabelColor(), x + lWidth, yy + barHeight * 0.5f, 0.0f, XAlign.LEFT, YAlign.CENTER, xShift, 0.0f);
                } else {
                    rgba = legend.getTickColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(legend.getTickWidth() * this.dpiScale);
                    gl.glBegin(1);
                    if (legend.isInsideTick()) {
                        gl.glVertex2f(x + lWidth - tickLen, yy + barHeight);
                    } else {
                        gl.glVertex2f(x + lWidth + tickLen, yy + barHeight);
                    }
                    gl.glVertex2f(x + lWidth, yy + barHeight);
                    gl.glEnd();
                    rect = this.drawString(gl, caption, legend.getTickLabelFont(), legend.getTickLabelColor(), labelX, yy + barHeight, 0.0f, XAlign.LEFT, YAlign.CENTER, xShift, 0.0f);
                }
                if ((double)strWidth < rect.getWidth()) {
                    strWidth = (float)rect.getWidth();
                }
                ++idx;
            }
            yy += barHeight;
        }
        ChartText label = legend.getLabel();
        if (label != null) {
            this.updateTextRender(legend.getLabelFont());
            label.setColor(legend.getTickColor());
            float yShift = this.tickSpace * this.dpiScale;
            switch (legend.getLabelLocation()) {
                case "top": {
                    float sx = x + lWidth * 0.5f;
                    float sy = y + lHeight;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 0.0f, 0.0f, yShift);
                    break;
                }
                case "bottom": {
                    float sx = x + lWidth * 0.5f;
                    float sy = y;
                    yShift = -yShift;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 0.0f, 0.0f, yShift);
                    break;
                }
                case "left": 
                case "in": {
                    float sx = x;
                    float sy = y + lHeight * 0.5f;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
                    break;
                }
                default: {
                    float sx = labelX;
                    float sy = y + lHeight * 0.5f;
                    yShift = -strWidth - yShift;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 90.0f, 0.0f, yShift);
                }
            }
        }
        gl.glDepthFunc(515);
    }

    void drawColorbar(GL2 gl, ChartColorBar legend) {
        float[] rgba;
        LegendScheme ls = legend.getLegendScheme();
        ColorMap colorMap = ls.getColorMap();
        Normalize normalize = ls.getNormalize();
        int bNum = colorMap.getColorCount();
        if (normalize instanceof BoundaryNorm) {
            bNum = ((BoundaryNorm)normalize).getNRegions();
        }
        float x = 1.6f;
        x += legend.getXShift() * this.lenScale;
        float y = -1.0f;
        float legendHeight = 2.0f;
        float barWidth = legendHeight / (float)legend.getAspect();
        float minMaxHeight = legendHeight;
        float y_shift = 0.0f;
        switch (legend.getExtendType()) {
            case MIN: {
                minMaxHeight -= barWidth;
                y_shift += barWidth;
                break;
            }
            case MAX: {
                minMaxHeight -= barWidth;
                break;
            }
            case BOTH: {
                minMaxHeight -= barWidth * 2.0f;
                y_shift += barWidth;
            }
        }
        float barHeight = minMaxHeight / (float)bNum;
        gl.glDepthFunc(519);
        float yy = y;
        Color[] colors = colorMap.getColors(bNum);
        for (int i = 0; i < bNum; ++i) {
            rgba = colors[i].getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            gl.glVertex2f(x, yy);
            gl.glVertex2f(x + barWidth, yy);
            gl.glVertex2f(x + barWidth, yy + barHeight);
            gl.glVertex2f(x, yy + barHeight);
            gl.glEnd();
            yy += barHeight;
        }
        rgba = legend.getTickColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(legend.getNeatLineSize() * this.dpiScale);
        gl.glBegin(3);
        gl.glVertex2f(x, y);
        gl.glVertex2f(x, y + legendHeight);
        gl.glVertex2f(x + barWidth, y + legendHeight);
        gl.glVertex2f(x + barWidth, y);
        gl.glVertex2f(x, y);
        gl.glEnd();
        boolean idx = false;
        yy = y;
        float tickLen = legend.getTickLength() * this.lenScale;
        float labelX = x + barWidth;
        if (legend.isInsideTick()) {
            if (tickLen > barWidth) {
                tickLen = barWidth;
            }
        } else {
            labelX += tickLen;
        }
        float strWidth = 0.0f;
        float xShift = this.tickSpace * this.dpiScale;
        this.updateTextRender(legend.getTickLabelFont());
        for (int i = 0; i < legend.getTickLocations().size(); ++i) {
            yy = y + minMaxHeight * normalize.apply((Number)legend.getTickLocations().get(i)).floatValue();
            String label = legend.getTickLabels().get(i).getText();
            rgba = legend.getTickColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(legend.getTickWidth() * this.dpiScale);
            gl.glBegin(1);
            if (legend.isInsideTick()) {
                gl.glVertex2f(x + barWidth - tickLen, yy);
            } else {
                gl.glVertex2f(x + barWidth + tickLen, yy);
            }
            gl.glVertex2f(x + barWidth, yy);
            gl.glEnd();
            Rectangle2D rect = this.drawString(gl, label, legend.getTickLabelFont(), legend.getTickLabelColor(), labelX, yy, 0.0f, XAlign.LEFT, YAlign.CENTER, xShift, 0.0f);
            if (!((double)strWidth < rect.getWidth())) continue;
            strWidth = (float)rect.getWidth();
        }
        ChartText label = legend.getLabel();
        if (label != null) {
            this.updateTextRender(legend.getLabelFont());
            label.setColor(legend.getTickColor());
            float yShift = this.tickSpace * this.dpiScale;
            switch (legend.getLabelLocation()) {
                case "top": {
                    float sx = x + barWidth * 0.5f;
                    float sy = y + legendHeight;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 0.0f, 0.0f, yShift);
                    break;
                }
                case "bottom": {
                    float sx = x + barWidth * 0.5f;
                    float sy = y;
                    yShift = -yShift;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 0.0f, 0.0f, yShift);
                    break;
                }
                case "left": 
                case "in": {
                    float sx = x;
                    float sy = y + legendHeight * 0.5f;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
                    break;
                }
                default: {
                    float sx = labelX;
                    float sy = y + legendHeight * 0.5f;
                    yShift = -strWidth - yShift;
                    this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 90.0f, 0.0f, yShift);
                }
            }
        }
        gl.glDepthFunc(515);
    }

    public LegendScheme getLegendScheme() {
        LegendScheme ls = null;
        int n = this.graphics.getNumGraphics();
        for (int i = n - 1; i >= 0; --i) {
            Graphic g = this.graphics.getGraphicN(i);
            if (!(g instanceof GraphicCollection)) continue;
            ls = ((GraphicCollection)g).getLegendScheme();
            break;
        }
        if (ls == null) {
            ShapeTypes stype = ShapeTypes.POLYLINE;
            ls = new LegendScheme(stype);
            for (Graphic g : this.graphics.getGraphics()) {
                ls.getLegendBreaks().add(g.getLegend());
            }
        }
        return ls;
    }

    public float getScale() {
        return (float)(this.graphicExtent.getWidth() / this.drawExtent.getWidth());
    }

    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        Program.destroyAllPrograms(gl);
        this.alwaysUpdateBuffers = true;
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl;
        this.drawable = drawable;
        drawable.getGL().setSwapInterval(1);
        this.gl = gl = drawable.getGL().getGL2();
        this.glu = GLU.createGLU((GL)gl);
        Font font = this.xAxis.getTickLabelFont();
        this.updateTextRender(font);
        gl.glEnable(2832);
        gl.glEnable(2929);
        gl.glShadeModel(7425);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        this.tessCallback = new TessCallback(gl, this.glu);
        this.positionArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.positionArea = this.getPositionArea(new Rectangle2D.Double(0.0, 0.0, width, height));
        this.setGraphArea(this.positionArea);
        this.width = (int)this.positionArea.getWidth();
        this.height = (int)this.positionArea.getHeight();
        GL2 gl = drawable.getGL().getGL2();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glViewport((int)this.positionArea.getX(), (int)((double)(height - this.height) - this.positionArea.getY()), this.width, this.height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (this.orthographic) {
            float v = 2.0f;
            switch (this.aspectType) {
                case EQUAL: {
                    gl.glOrthof(-v * h, v * h, -v, v, -this.distance, this.distance);
                    break;
                }
                default: {
                    gl.glOrthof(-v, v, -v, v, -this.distance, this.distance);
                    break;
                }
            }
        } else {
            float near = 0.1f;
            float far = 1000.0f;
            switch (this.aspectType) {
                case EQUAL: {
                    this.glu.gluPerspective(this.fieldOfView, h, near, far);
                    break;
                }
                default: {
                    this.glu.gluPerspective(this.fieldOfView, 1.0f, near, far);
                }
            }
            float z = this.distance * 45.0f / this.fieldOfView;
            this.glu.gluLookAt(0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void updateProjections(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        float h = (float)this.width / (float)this.height;
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (this.orthographic) {
            float v = 2.0f;
            switch (this.aspectType) {
                case EQUAL: {
                    gl.glOrthof(-v * h, v * h, -v, v, -this.distance, this.distance);
                    break;
                }
                default: {
                    gl.glOrthof(-v, v, -v, v, -this.distance, this.distance);
                    break;
                }
            }
        } else {
            float near = 0.1f;
            float far = 1000.0f;
            switch (this.aspectType) {
                case EQUAL: {
                    this.glu.gluPerspective(45.0f, h, near, far);
                    break;
                }
                default: {
                    this.glu.gluPerspective(45.0f, 1.0f, near, far);
                }
            }
            this.glu.gluLookAt(0.0f, 0.0f, this.distance, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        int left = 2;
        int bottom = 2;
        int right = 2;
        int top = 5;
        int space = 2;
        if (this.title != null) {
            top += this.title.getTrueDimension((Graphics2D)g).height + 10;
        }
        if (!this.legends.isEmpty()) {
            ChartLegend legend = this.getLegend();
            Dimension dim = legend.getLegendDimension(g, new Dimension((int)positionArea.getWidth(), (int)positionArea.getHeight()));
            switch (legend.getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom = (int)((float)bottom + ((float)dim.height + legend.getYShift() + 10.0f));
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right = (int)((float)right + ((float)dim.width + legend.getXShift() + 10.0f));
                }
            }
        }
        return new Margin(left, right, top, bottom);
    }

    public Object clone() {
        GLPlot plot3DGL = new GLPlot();
        plot3DGL.graphics = this.graphics;
        plot3DGL.angleX = this.angleX;
        plot3DGL.angleY = this.angleY;
        plot3DGL.background = this.background;
        plot3DGL.sampleBuffers = this.sampleBuffers;
        plot3DGL.antialias = this.antialias;
        plot3DGL.boxColor = this.boxColor;
        plot3DGL.boxed = this.boxed;
        plot3DGL.clipPlane = this.clipPlane;
        plot3DGL.displayXY = this.displayXY;
        plot3DGL.displayZ = this.displayZ;
        plot3DGL.dpiScale = this.dpiScale;
        plot3DGL.drawBase = this.drawBase;
        plot3DGL.drawBoundingBox = this.drawBoundingBox;
        plot3DGL.setDrawExtent((Extent)((Extent3D)this.drawExtent.clone()));
        plot3DGL.gridLine = this.gridLine;
        plot3DGL.legends = this.legends;
        plot3DGL.hideOnDrag = this.hideOnDrag;
        plot3DGL.lighting = this.lighting;
        plot3DGL.title = this.title;
        return plot3DGL;
    }

    public static void main(String[] args) {
        GLProfile gp = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(gp);
        GLChartPanel gc = new GLChartPanel();
        gc.setSize(400, 400);
        JFrame frame = new JFrame("JOGL Line");
        frame.add((Component)((Object)gc));
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    public static class TessCallback
    extends GLUtessellatorCallbackAdapter {
        GL2 gl;
        GLU glu;

        public TessCallback(GL2 gl, GLU glu) {
            this.gl = gl;
            this.glu = glu;
        }

        public void begin(int type) {
            this.gl.glBegin(type);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object data) {
            if (data instanceof double[]) {
                double[] d = (double[])data;
                if (d.length == 6) {
                    this.gl.glColor3dv(d, 3);
                }
                this.gl.glVertex3dv(d, 0);
            }
        }

        public void error(int errnum) {
            String estring = this.glu.gluErrorString(errnum);
            System.out.println("Tessellation Error: " + estring);
            throw new RuntimeException();
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[6];
            vertex[0] = coords[0];
            vertex[1] = coords[1];
            vertex[2] = coords[2];
            for (int i = 3; i < 6; ++i) {
                vertex[i] = (double)weight[0] * ((double[])data[0])[i] + (double)weight[1] * ((double[])data[1])[i] + (double)weight[2] * ((double[])data[2])[i] + (double)weight[3] * ((double[])data[3])[i];
            }
            outData[0] = vertex;
        }
    }
}

