/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.opengl.GL2;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.meteoinfo.chart.jogl.Utils;

public class Program {
    static final List<Program> programs = new Vector<Program>();
    private final String name;
    Integer programId = null;
    private final Map<Integer, String> shaderCode = new HashMap<Integer, String>();
    private final Map<Integer, Integer> shaderIds = new HashMap<Integer, Integer>();
    static final Map<String, Integer> attributeLocations = new HashMap<String, Integer>();
    static final Map<String, Integer> uniformLocations = new HashMap<String, Integer>();
    static final Map<String, BiConsumer<GL2, Integer>> uniforms = new HashMap<String, BiConsumer<GL2, Integer>>();

    public Program(File file) throws IOException {
        this.name = null;
        File directory = file.isDirectory() ? file : new File(file.getParent());
        String mask = file.isDirectory() ? "" : file.getName();
        block16: for (File tmpFile : directory.listFiles()) {
            if (tmpFile.isDirectory() || !tmpFile.getName().startsWith(mask)) continue;
            switch (tmpFile.getName().substring(tmpFile.getName().lastIndexOf(".") + 1)) {
                case "frag": 
                case "fs": {
                    this.shaderCode.put(35632, Files.readAllLines(Paths.get(tmpFile.getAbsolutePath(), new String[0])).stream().collect(Collectors.joining("\n")));
                    continue block16;
                }
                case "vert": 
                case "vs": {
                    this.shaderCode.put(35633, Files.readAllLines(Paths.get(tmpFile.getAbsolutePath(), new String[0])).stream().collect(Collectors.joining("\n")));
                    continue block16;
                }
                case "cs": 
                case "compute": {
                    this.shaderCode.put(37305, Files.readAllLines(Paths.get(tmpFile.getAbsolutePath(), new String[0])).stream().collect(Collectors.joining("\n")));
                    continue block16;
                }
                case "gs": 
                case "geom": {
                    this.shaderCode.put(36313, Files.readAllLines(Paths.get(tmpFile.getAbsolutePath(), new String[0])).stream().collect(Collectors.joining("\n")));
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Program cannot read type of shader from file extension of %s ", tmpFile));
                }
            }
        }
    }

    public Program(String name, File vertexShaderFile, File fragmentShaderFile) throws IOException {
        this.name = name;
        try {
            String vertexShaderCode = Utils.loadResource(vertexShaderFile.getPath());
            String fragmentShaderCode = Utils.loadResource(fragmentShaderFile.getPath());
            this.shaderCode.put(35633, vertexShaderCode);
            this.shaderCode.put(35632, fragmentShaderCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Program(String name, String vertexShaderCode, String fragmentShaderCode) {
        this.name = name;
        this.shaderCode.put(35633, vertexShaderCode);
        this.shaderCode.put(35632, fragmentShaderCode);
    }

    public Integer getProgramId() {
        return this.programId;
    }

    public void init(GL2 gl) {
        if (this.programId != null) {
            return;
        }
        ByteBuffer infoLog = ByteBuffer.allocate(512);
        IntBuffer success = IntBuffer.allocate(1);
        for (Map.Entry<Integer, String> entry : this.shaderCode.entrySet()) {
            int shaderId = gl.glCreateShader(entry.getKey().intValue());
            this.shaderIds.put(entry.getKey(), shaderId);
            gl.glShaderSource(shaderId, 1, new String[]{entry.getValue()}, null);
            gl.glCompileShader(shaderId);
            gl.glGetShaderiv(shaderId, 35713, success);
            if (success.get(0) == 1) continue;
            gl.glGetShaderInfoLog(shaderId, 512, null, infoLog);
            System.out.println(new String(infoLog.array()));
        }
        this.programId = gl.glCreateProgram();
        for (Map.Entry<Integer, Object> entry : this.shaderIds.entrySet()) {
            gl.glAttachShader(this.programId.intValue(), ((Integer)entry.getValue()).intValue());
        }
        programs.add(this);
        if (this.shaderIds.size() == 0) {
            return;
        }
        gl.glLinkProgram(this.programId.intValue());
        gl.glGetProgramiv(this.programId.intValue(), 35714, success);
        if (success.get(0) != 1) {
            gl.glGetProgramInfoLog(this.programId.intValue(), 512, null, infoLog);
            System.out.println(new String(infoLog.array()));
        }
        for (Map.Entry<Integer, Object> entry : this.shaderIds.entrySet()) {
            gl.glDetachShader(this.programId.intValue(), ((Integer)entry.getValue()).intValue());
            gl.glDeleteShader(((Integer)entry.getValue()).intValue());
        }
    }

    public void destroy(GL2 gl) {
        if (this.programId != null) {
            for (Map.Entry<Integer, Integer> shaderId : this.shaderIds.entrySet()) {
                gl.glDetachShader(this.programId.intValue(), shaderId.getValue().intValue());
                gl.glDeleteShader(shaderId.getValue().intValue());
            }
            gl.glDeleteProgram(this.programId.intValue());
            this.programId = null;
        }
    }

    public void use(GL2 gl) {
        if (this.programId == null) {
            this.init(gl);
        }
        gl.glUseProgram(this.programId.intValue());
    }

    public void allocateUniform(GL2 gl, String uniformName, BiConsumer<GL2, Integer> function) {
        this.init(gl);
        int uniformLocation = gl.glGetUniformLocation(this.programId.intValue(), uniformName);
        uniformLocations.put(uniformName, uniformLocation);
        uniforms.put(uniformName, function);
    }

    public void setUniforms(GL2 gl) {
        for (Map.Entry<String, BiConsumer<GL2, Integer>> uniform : uniforms.entrySet()) {
            uniform.getValue().accept(gl, uniformLocations.get(uniform.getKey()));
        }
    }

    public static void destroyAllPrograms(GL2 gl) {
        for (Program program : programs) {
            program.destroy(gl);
        }
        programs.clear();
    }

    public static void unUse(GL2 gl) {
        gl.glUseProgram(0);
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }
}

