/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.meteoinfo.chart.graphic.ParticleGraphics;
import org.meteoinfo.chart.graphic.sphere.Sphere;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.math.Matrix4f;

public class PointRender
extends JOGLGraphicRender {
    private GraphicCollection3D graphics;
    private IntBuffer vbo;
    private Program program;
    private int pointNum;
    private int sizePosition;
    private int sizeColor;
    private int sizeNormal;
    private float pointSize;
    private boolean sphere;
    private float sphereScale = 0.005f;
    private float[] vertexPosition;
    private float[] vertexNormal;
    private float[] vertexColor;
    private int[] vertexIndices;
    private List<Vector3f> objNormals;

    public PointRender(GL2 gl) {
        super(gl);
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initVertexBuffer();
    }

    public PointRender(GL2 gl, GraphicCollection3D pointGraphics) {
        this(gl);
        this.graphics = pointGraphics;
        this.sphere = this.graphics.isSphere();
        if (this.graphics instanceof ParticleGraphics) {
            this.pointNum = ((ParticleGraphics)this.graphics).getPointNumber();
            this.pointSize = ((ParticleGraphics)this.graphics).getPointSize();
        } else {
            this.pointNum = pointGraphics.getNumGraphics();
            PointBreak pb = (PointBreak)this.graphics.getGraphicN(0).getLegend();
            this.pointSize = pb.getSize();
        }
    }

    void updateVertex() {
        if (this.sphere) {
            this.updateSphereVertex();
        } else {
            this.updateVertexPosition();
            this.updateVertexColor();
        }
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/surface/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/surface/surface.frag");
        this.program = new Program("surface", vertexShaderCode, fragmentShaderCode);
    }

    private void initVertexBuffer() {
        this.vbo = GLBuffers.newDirectIntBuffer((int)1);
    }

    private void updateVertexColor() {
        this.vertexColor = new float[this.pointNum * 4];
        int i = 0;
        if (this.graphics instanceof ParticleGraphics) {
            ParticleGraphics particles = (ParticleGraphics)this.graphics;
            for (Map.Entry<Integer, List> map : particles.getParticleList()) {
                for (ParticleGraphics.Particle p : map.getValue()) {
                    System.arraycopy(p.rgba, 0, this.vertexColor, i * 4, 4);
                    ++i;
                }
            }
        } else {
            for (Graphic graphic : this.graphics.getGraphics()) {
                PointBreak pb = (PointBreak)graphic.getLegend();
                float[] color = pb.getColor().getRGBComponents(null);
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                ++i;
            }
        }
    }

    private void updateVertexPosition() {
        if (this.sphere) {
            this.updateSphereVertexPosition();
        } else {
            this.vertexPosition = new float[this.pointNum * 3];
            int i = 0;
            if (this.graphics instanceof ParticleGraphics) {
                ParticleGraphics particles = (ParticleGraphics)this.graphics;
                for (Map.Entry<Integer, List> map : particles.getParticleList()) {
                    for (ParticleGraphics.Particle p : map.getValue()) {
                        this.vertexPosition[i] = p.x;
                        this.vertexPosition[i + 1] = p.y;
                        this.vertexPosition[i + 2] = p.z;
                        i += 3;
                    }
                }
            } else {
                for (Graphic graphic : this.graphics.getGraphics()) {
                    PointZShape shape = (PointZShape)graphic.getShape();
                    PointZ p = (PointZ)shape.getPoint();
                    this.vertexPosition[i] = (float)p.X;
                    this.vertexPosition[i + 1] = (float)p.Y;
                    this.vertexPosition[i + 2] = (float)p.Z;
                    i += 3;
                }
            }
        }
    }

    private void updateSphereVertex() {
        ArrayList<Vector3f> vertexPositionList = new ArrayList<Vector3f>();
        ArrayList<Vector3f> vertexNormalList = new ArrayList<Vector3f>();
        ArrayList<Vector4f> vertexColorList = new ArrayList<Vector4f>();
        ArrayList<Integer> vertexIndexList = new ArrayList<Integer>();
        float size = -1.0f;
        Sphere sphere = null;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointZ p = (PointZ)shape.getPoint();
            PointBreak pb = (PointBreak)graphic.getLegend();
            if (size != pb.getSize()) {
                size = pb.getSize();
                sphere = new Sphere(size * this.sphereScale * this.dpiScale, 36, 18);
            }
            Vector3f vp = this.transform.transform((float)p.X, (float)p.Y, (float)p.Z);
            Matrix4f matrix = new Matrix4f();
            matrix.translate(vp);
            List<Vector3f> vertices = sphere.getVertices();
            int n = vertices.size();
            int nAdded = vertexPositionList.size();
            for (Vector3f v : vertices) {
                vertexPositionList.add(matrix.mul(v));
            }
            List<Vector3f> normals = sphere.getNormals();
            if (vertexNormalList.isEmpty()) {
                this.objNormals = normals;
            }
            vertexNormalList.addAll(normals);
            float[] color = pb.getColor().getRGBComponents(null);
            for (int j = 0; j < n; ++j) {
                vertexColorList.add(new Vector4f(color));
            }
            if (nAdded == 0) {
                vertexIndexList.addAll(sphere.getIndices());
                continue;
            }
            for (int idx : sphere.getIndices()) {
                vertexIndexList.add(idx + nAdded);
            }
        }
        int n = vertexPositionList.size();
        this.vertexPosition = new float[n * 3];
        this.vertexNormal = new float[n * 3];
        this.vertexColor = new float[n * 4];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < n) {
            Vector3f v = (Vector3f)vertexPositionList.get(i);
            this.vertexPosition[j] = v.x;
            this.vertexPosition[j + 1] = v.y;
            this.vertexPosition[j + 2] = v.z;
            v = (Vector3f)vertexNormalList.get(i);
            this.vertexNormal[j] = v.x;
            this.vertexNormal[j + 1] = v.y;
            this.vertexNormal[j + 2] = v.z;
            Vector4f v4 = (Vector4f)vertexColorList.get(i);
            this.vertexColor[k] = v4.x;
            this.vertexColor[k + 1] = v4.y;
            this.vertexColor[k + 2] = v4.z;
            this.vertexColor[k + 3] = v4.w;
            ++i;
            j += 3;
            k += 4;
        }
        this.vertexIndices = vertexIndexList.stream().mapToInt(Integer::intValue).toArray();
    }

    private void updateSphereVertexPosition() {
        ArrayList<Vector3f> vertexPositionList = new ArrayList<Vector3f>();
        float size = -1.0f;
        Sphere sphere = null;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointZ p = (PointZ)shape.getPoint();
            PointBreak pb = (PointBreak)graphic.getLegend();
            if (size != pb.getSize()) {
                size = pb.getSize();
                sphere = new Sphere(size * this.sphereScale * this.dpiScale, 36, 18);
            }
            Vector3f vp = this.transform.transform((float)p.X, (float)p.Y, (float)p.Z);
            Matrix4f matrix = new Matrix4f();
            matrix.translate(vp);
            List<Vector3f> vertices = sphere.getVertices();
            int n = vertices.size();
            int nAdded = vertexPositionList.size();
            for (Vector3f v : vertices) {
                vertexPositionList.add(matrix.mul(v));
            }
        }
        int n = vertexPositionList.size();
        this.vertexPosition = new float[n * 3];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < n) {
            Vector3f v = (Vector3f)vertexPositionList.get(i);
            this.vertexPosition[j] = v.x;
            this.vertexPosition[j + 1] = v.y;
            this.vertexPosition[j + 2] = v.z;
            ++i;
            j += 3;
            k += 4;
        }
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (updateBuffer) {
            if (this.vertexPosition == null) {
                this.updateVertex();
            } else if (this.sphere) {
                this.updateSphereVertexPosition();
            }
            FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexPosition);
            this.sizePosition = vertexBuffer.capacity() * 4;
            FloatBuffer colorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexColor);
            this.sizeColor = colorBuffer.capacity() * 4;
            if (this.sphere) {
                FloatBuffer normalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexNormal);
                this.sizeNormal = normalBuffer.capacity() * 4;
                int totalSize = this.sizePosition + this.sizeColor + this.sizeNormal;
                this.vbo = GLBuffers.newDirectIntBuffer((int)2);
                this.gl.glGenBuffers(2, this.vbo);
                this.gl.glBindBuffer(34962, this.vbo.get(0));
                this.gl.glBufferData(34962, (long)totalSize, null, 35044);
                this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
                this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeColor, (Buffer)colorBuffer);
                this.gl.glBufferSubData(34962, (long)(this.sizePosition + this.sizeColor), (long)this.sizeNormal, (Buffer)normalBuffer);
                this.gl.glBindBuffer(34962, 0);
                IntBuffer indexBuffer = GLBuffers.newDirectIntBuffer((int[])this.vertexIndices);
                this.gl.glBindBuffer(34963, this.vbo.get(1));
                this.gl.glBufferData(34963, (long)(indexBuffer.capacity() * 4), (Buffer)indexBuffer, 35044);
                this.gl.glBindBuffer(34963, 0);
            } else {
                int totalSize = this.sizePosition + this.sizeColor;
                this.gl.glGenBuffers(1, this.vbo);
                this.gl.glBindBuffer(34962, this.vbo.get(0));
                this.gl.glBufferData(34962, (long)totalSize, null, 35044);
                this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
                this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeColor, (Buffer)colorBuffer);
                this.gl.glBindBuffer(34962, 0);
            }
        }
    }

    void setUniforms() {
    }

    @Override
    public void draw() {
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)this.sizePosition);
            if (this.sphere) {
                this.gl.glPushMatrix();
                FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
                this.gl.glLoadMatrixf(this.modelViewMatrixR.get(fb));
                this.gl.glBindBuffer(34963, this.vbo.get(1));
                this.gl.glEnableClientState(32885);
                this.gl.glNormalPointer(5126, 0, (long)(this.sizePosition + this.sizeColor));
                this.gl.glDrawElements(4, this.vertexIndices.length, 5125, 0L);
                this.gl.glDisableClientState(32884);
                this.gl.glDisableClientState(32886);
                this.gl.glDisableClientState(32885);
                this.gl.glBindBuffer(34962, 0);
                this.gl.glBindBuffer(34963, 0);
                this.gl.glPopMatrix();
            } else {
                boolean lightEnabled = this.lighting.isEnable();
                if (lightEnabled) {
                    this.lighting.stop(this.gl);
                }
                this.gl.glPointSize(this.pointSize * this.dpiScale);
                this.gl.glDrawArrays(0, 0, this.pointNum);
                if (lightEnabled) {
                    this.lighting.start(this.gl);
                }
                this.gl.glDisableClientState(32884);
                this.gl.glDisableClientState(32886);
                this.gl.glBindBuffer(34962, 0);
            }
        }
    }
}

