/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.CalibratorGvar;

public class CalibratorGvarG13
extends CalibratorGvar {
    protected static float[] imager13FK1 = new float[]{0.0f, 200750.0f, 42508.0f, 9805.0f, 5017.3f};
    protected static float[] sounder13FK1 = new float[]{3733.0f, 4035.1f, 4266.1f, 4692.0f, 4995.3f, 5802.1f, 6833.8f, 8942.0f, 13042.0f, 28772.0f, 34368.0f, 42901.0f, 125130.0f, 128120.0f, 134820.0f, 168920.0f, 189380.0f, 226080.0f};
    protected static float[] imager13FK2 = new float[]{0.0f, 3689.0f, 2198.7f, 1348.4f, 1078.6f};
    protected static float[] sounder13FK2 = new float[]{977.32f, 1003.0f, 1021.8f, 1054.7f, 1077.0f, 1132.1f, 1195.6f, 1307.7f, 1483.0f, 1930.5f, 2048.3f, 2205.5f, 3151.2f, 3176.1f, 3230.5f, 3482.6f, 3617.9f, 3838.0f};
    protected static float[] imager13TC1 = new float[]{0.0f, 1.4795f, 3.96964f, 0.3635f, 0.09502f};
    protected static float[] sounder13TC1 = new float[]{0.00944f, 0.01022f, 0.01011f, 0.01291f, 0.01353f, 0.04272f, 0.12493f, 0.12033f, 0.03838f, 0.15609f, 0.28f, 0.18057f, 0.01799f, 0.01809f, 0.02012f, 0.05092f, 0.0574f, 0.29874f};
    protected static float[] imager13TC2 = new float[]{0.0f, 0.99794f, 0.99112f, 0.99876f, 0.9996f};
    protected static float[] sounder13TC2 = new float[]{0.99996f, 0.99995f, 0.99995f, 0.99994f, 0.99994f, 0.99983f, 0.99952f, 0.99958f, 0.99988f, 0.99961f, 0.99932f, 0.99959f, 0.99997f, 0.99997f, 0.99997f, 0.99992f, 0.99992f, 0.99959f};

    public CalibratorGvarG13(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG13(int sensorId, int[] cb) {
        super(sensorId, cb);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            if (band == 6) {
                band = 5;
            }
            double expn = (double)(imager13FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager13FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager13TC1[band - 1]) / (double)imager13TC2[band - 1]);
        } else {
            double expn = (double)(sounder13FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder13FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder13TC1[band - 1]) / (double)sounder13TC2[band - 1]);
        }
        return outVal;
    }
}

