from mipylib.numeric import stats

x = arange(0, 20, 0.1)
aa = [1, 2, 3, 5, 9]
bb = [2, 2, 2, 1, 0.5]
ss = ['-b', '-r', '-c', '-g', '-m']

#PDF
subplot(1,2,1)
for a,b,s in zip(aa,bb,ss):
    y = stats.gamma.pdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$k = %.1f, \theta = %.1f$' % (a, b))
#grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 0.5)
xlim(0, 20)
title('PDF')

#CDF
subplot(1,2,2)
for a,b,s in zip(aa,bb,ss):
    y = stats.gamma.cdf(x, a, b)
    plot(x, y, s, linewidth=2, label=r'$k = %.1f, \theta = %.1f$' % (a, b))
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1.05)
xlim(0, 20)
title('CDF')

suptitle('Gamma distribution')