fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'skincancer.txt')
df = DataFrame.read_table(fn, format='%s%f%2i%f')
lat = df['Lat'].values
mort = df['Mort'].values

slope, intercept, r, p, std_err = stats.linregress(lat, mort)
scatter(lat, mort, label='original data', edge=False)
plot(lat, intercept+slope*lat, 'r', label='fitted line')
text(29, 100, r'$\hat{y} = ' + '%.2f' % slope + 'x + ' + \
    '%.1f' % intercept + '$', fontsize=16)
text(29, 88, r'$R^2 = '+ '%.4f' % (r**2) + '$', fontsize=16)
legend()
xlim(27, 50)
ylim(75, 250)
xticks(arange(30, 51, 5))
yticks(arange(100, 226, 25))
title('Skin Cancer Mortality versus State Latitude')
xlabel('Latitude (at center of state)')
ylabel('Mortality (Deaths per 10 million)')