#Set date
sdate = datetime.datetime(2019, 4, 15, 0)

#Set directory
datadir = 'D:/Temp/mm5'

#Read data
fn = os.path.join(datadir, 'WMO_SDS-WAS_Asian_Center_Model_Forecasting_CUACE-DUST_CMA_'+ sdate.strftime('%Y%m%d%H') + '.nc')
f = addfile(fn)
st = f.gettime(0)
t = 20
dust = f['CONC_DUST'][t,:,:,:]
levels = dust.dimvalue(0)
dust[dust<5] = 0
height = meteolib.pressure_to_height_std(levels)
lat = dust.dimvalue(1)
lon = dust.dimvalue(2)

#Plot
axes3d()
geoshow('cn_province', edgecolor='gray')
geoshow('country', edgecolor='b')
lighting()
isosurface(lon, lat, height, dust, 100, color=[255,180,0], edge=False)
xlim(65, 155)
xlabel('Longitude')
ylim(15, 65)
ylabel('Latitude')
zlim(0, 12000)
zlabel('Height (m)')
tt = st + datetime.timedelta(hours=t*3)
title('Dust bigger than 100 ug/m3 (%s)' % tt.strftime('%Y-%m-%d %H:00'))