import time

#Relief data
fn = 'D:/Temp/nc/elev.0.25-deg.nc'
f = addfile(fn)
elev = f['data'][0,'10:60','70:140']
lon = elev.dimvalue(1)
lat = elev.dimvalue(0)
lon, lat = meshgrid(lon, lat)

lchina = shaperead('china')
elev[elev<=0] = 1
elev = elev.maskout(lchina.shapes[0])

#
st = time.clock()
ax = axes3dgl()
levs = arange(0, 6000, 200)
levs[0] = 1
cols = makecolors(len(levs)+1, cmap='MPL_terrain')
cols[0] = (255,255,255,0)
ls = ax.plot_surface(lon, lat, elev, levs, colors=cols, edge=False)
ax.plot_layer(lchina, edgecolor='k', linewidth=2)
zlim(0, 20000)
colorbar(ls,shrink=0.8)
title('Surface 3D plot example')
et = time.clock()
print(et - st)