fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
ps = f['PS'][0,:,:]

#Plot
lchina = shaperead('cn_province')
for i in range(1, 5):
    subplot(2,2,i)
    axesm(newaxes=False, tickfontsize=12)
    geoshow(lchina)
    layer = contourfm(ps)
    xlim(72,137)
    ylim(15,55)
    yticks(arange(20,51,10))

#new axes - add China South Sea
ll = shaperead('cn_border.shp')
cols = [0, 1]
rows = [0, 1]
axs = []
for col in cols:
    for row in rows: 
        ax = axesm([0.335+(col*0.5), 0.06+(row*0.5), 0.14, 0.14], axison=False, frameon=True)
        axs.append(ax)
        geoshow(ll, color='b')
        xlim(106, 123)
        ylim(2, 23)

#Add one colorbar
axes([0.2,0.2,0.26,0.5], frameon=False, axis=False)
colorbar(layer, fontsize=12)